/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 * ֥饦Υƥȥ˥塼ˡå URL 
 * bbs2chreader ˥塼ɲä
 */
var Bbs2chBrowserContextMenu = {

	get prefBranch(){
		if(!this._prefBranch){
			this._prefBranch = Components.classes["@mozilla.org/preferences-service;1"]
								.getService(Components.interfaces.nsIPrefBranch);
		}
		return this._prefBranch;
	},
	_prefBranch: null,


	start: function(){
		var enableContextMenu = true;
		try{
			enableContextMenu = Bbs2chBrowserContextMenu.prefBranch.getBoolPref(
									"fls.bbs2chreader.enable_browser_contextmenu");
		}catch(ex){}
		
		if(enableContextMenu){
			document.getElementById("contentAreaContextMenu")
						.addEventListener("popupshowing",
								Bbs2chBrowserContextMenu.showMenu, false);
		}
	},

	stop: function(){
		document.getElementById("contentAreaContextMenu")
					.removeEventListener("popupshowing", 
							Bbs2chBrowserContextMenu.showMenu, false);
	},


	showMenu: function(aEvent){
		if(aEvent.originalTarget.id != "contentAreaContextMenu") return;
		document.getElementById("context-bbs2chreader").hidden = true;

		if(!gContextMenu || !gContextMenu.onLink) return;

		var pathname = gContextMenu.link.pathname;
		if(pathname.indexOf("/test/read.cgi/")==-1 &&
				pathname.indexOf("/bbs/read.cgi/")==-1) return;

		document.getElementById("context-bbs2chreader").hidden = false;
	},

	openThread: function(aNewTab){

		if(!gContextMenu || !gContextMenu.onLink) return;

		var threadURL = "bbs2ch:thread:" + gContextMenu.link.href;
		if(aNewTab){
			var newTab = gBrowser.addTab(threadURL, null);
				// ֤򥢥ƥ֤ˤ뤫
			var tabLoadInForeground = false;
			try{
				tabLoadInForeground = this.prefBranch.getBoolPref(
							"fls.bbs2chreader.tab_load_in_foreground");
			}catch(ex){}
			if(tabLoadInForeground) gBrowser.selectedTab = newTab; 
		}else{
			gBrowser.loadURI(threadURL, null);
		}
	}

}


window.addEventListener("load", Bbs2chBrowserContextMenu.start, false);
window.addEventListener("unload", Bbs2chBrowserContextMenu.stop, false);