/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 * ץʥ֥
 *
 * @requires Bbs2chGlobal
 * @requires Bbs2chHttpRequest
 * @constructor
 *
 * @param aURLSpec string ¸ URL
 * @param aFilePath string ¸եѥ
 */
function Bbs2chDownloader(aURLSpec, aFilePath){
	this._urlSpec = aURLSpec;
	this._filePath = aFilePath;
}

Bbs2chDownloader.prototype = {

	_httpReq: null,
	_loading: false,
	_dataSize: 0,


// ********** *********  ********** **********


	/**
	 *  URL
	 * @return number
	 */
	ERROR_BAD_URL: 1,

	/**
	 * ʥեѥ
	 * @return number
	 */
	ERROR_BAD_FILE_PATH: 2,

	/**
	 * ꥯȤμ
	 * @return number
	 */
	ERROR_FAILURE: 3,

	/**
	 * 󥻥뤵줿
	 * @return number
	 */
	ERROR_ABORT: 4,


// ********** ********* ץѥƥ ********** **********


	/**
	 * URL spec
	 * @return string
	 */
	get urlSpec(){ return this._urlSpec; },

	/**
	 * եѥ
	 * @return string
	 */
	get filePath(){ return this._filePath; },

	/**
	 * 椫ɤ
	 * @return boolean
	 */
	get loading(){ return this._loading; },


// ********** ********* ᥽å ********** **********


	/**
	 * ɤ򳫻Ϥ
	 */
	download: function(){
		this._loading = false;

		try{
			var fromURI = Bbs2chGlobal.ioService.newURI(this._urlSpec, null, null);
		}catch(ex){
			this.onDownloaderError(this.ERROR_BAD_URL);
			return;
		}
	
		try{
			var toFile = Bbs2chGlobal.createLocalFile(this._filePath);
		}catch(ex){
			this.onDownloaderError(this.ERROR_BAD_FILE_PATH);
			return;
		}

		if(this._httpReq) this._httpReq.abort();
		try{
			this._httpReq = new Bbs2chHttpRequest(this._urlSpec, this, null);
			this._httpReq.get();
		}catch(ex){
			this.onDownloaderError(this.ERROR_FAILURE);
			return;
		}
		this._loading = true;
	},

	/**
	 * ɤߤ
	 * @param aSilent boolean ʤ饨顼֤ʤ
	 */
	abort: function(aSilent){
		try{
			this._httpReq.abort();
		}catch(ex){}
		
		if(!aSilent) this.onDownloaderError(this.ERROR_ABORT);
		
		this._loading = false;
	},


// ********** ********* ٥ȥϥɥ ********** **********


	/**
	 * ɤγ
	 */
	onDownloaderStart: function(){
	},


	/**
	 * ɤνλ
	 * @param aStatus number ꥯȤ HTTP ơ
	 */
	onDownloaderStop: function(aStatus){
	},


	/**
	 * ץ쥹ѹ
	 * @param aPercentage number ʹΨ
	 */
	onDownloaderProgressChange: function(aPercentage){
	},


	/**
	 * ɤμ
	 * @param aErrorCode number 顼(ERROR_XXX)
	 */
	onDownloaderError: function(aErrorCode){
	},


// ********** ********* implements Bbs2chHttpRequestListener ********** **********


	onHttpStart: function(){
		this.onDownloaderStart();
	},


	onHttpStop: function(aResponseText, aStatus){
		if(this._httpReq._channel.requestSucceeded){
			Bbs2chGlobal.writeFile(this.filePath, aResponseText);
			this.onDownloaderStop(aStatus);
		}else{
				// ɼ
			this.onDownloaderError(this.ERROR_FAILURE);
		}
			// ɤνλ
		this._loading = false;
	},


	onHttpDataAvailable: function(aAvailableData, aStatus){
		this._dataSize += aAvailableData.length;

		var progress = -1;

		var contentLength = this._httpReq._channel.contentLength;
		if(contentLength > 0){
			progress = Math.floor((this._dataSize * 100.0) / contentLength)
		}

		this.onDownloaderProgressChange(progress);
	},


	onHttpError: function(aErrorCode){
		this.onDownloaderError(this.ERROR_FAILURE);
	}

}