/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 *	Channel ο
 */
function Bbs2chChannel(aURI, aContentType, aContentCharset, aObserver){
	this.URI = aURI;
	this.originalURI = aURI;
	this.contentType = aContentType;
	this.contentCharset = aContentCharset;

	this._observer = aObserver;

	this._isPending = true;

	this._dataSize = 0;
	this._stringStream = Components.classes["@mozilla.org/io/string-input-stream;1"]
							.createInstance(Components.interfaces.nsIStringInputStream);
}

Bbs2chChannel.prototype = {


// ********** ********* implements nsIChannel ********** **********


	owner: null,
	notificationCallbacks: null,
	securityInfo: null,
	contentLength: -1,
	status: Components.results.NS_OK,
	loadGroup: null,
	loadAttributes: null,


	QueryInterface: function(aIID){
		if(aIID.equals(Components.interfaces.nsIChannel))  return this;
		if(aIID.equals(Components.interfaces.nsIRequest))  return this;
		if(aIID.equals(Components.interfaces.nsISupports)) return this;

		throw Components.results.NS_ERROR_NO_INTERFACE;
	},

	open: function(){
		throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
	},
	
	asyncOpen: function(aStreamListener, aContext){
		this._streamListener = aStreamListener;
		this._context = aContext;
		
		if(this.loadGroup) this.loadGroup.addRequest(this, this._context);

			// ƤӽФΥåɽ˥
		var timer = Components.classes["@mozilla.org/timer;1"]
						.createInstance(Components.interfaces.nsITimer);
		var timerCallback = {};
		timerCallback._context = this;
		timerCallback.observe = function(aTimer){
			this._context.asyncOpenDelay();
		}
		timer.init(timerCallback, 0, timer.TYPE_ONE_SHOT);
	},

	isPending: function(){
		return this._isPending;
	},

	cancel: function(aStatus){
		if(this._isPending){
			this._isPending = false;
			
			this._streamListener.onStopRequest(this, this._context, aStatus);
			if(this.loadGroup){
				try{
					this.loadGroup.removeRequest(this, null, aStatus);
				}catch(ex){}
			}
		}
		this.status = aStatus;
	},

	resume: function(){
		throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
	},
	
	suspend: function(){
		throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
	},


// ********** ********* implements Bbs2chChannel ********** **********

	
	/**
	 * ꥯȤΥ
	 */
	asyncOpenDelay: function(){
		this._streamListener.onStartRequest(this, this._context);
			// observer ϡBbs2chThread  Channel 륪֥
		var observer = new this._observer(this);
	},


	/**
	 * ꥯȤ˥ǡ
	 * @param aString string ǡ
	 */
	requestRespond: function(aString){
		aString = aString.toString();
		var strLength = aString.length;
		
		this._stringStream.setData(aString, strLength);
		this._streamListener.onDataAvailable(this, this._context,
					this._stringStream, this._dataSize, strLength);
		this._dataSize += strLength;
	},


	/**
	 * ꥯȤλ
	 */
	requestEnd: function(){
		this._streamListener.onStopRequest(this, this._context, Components.results.NS_OK);
		if(this.loadGroup){
			try{
				this.loadGroup.removeRequest(this, null, Components.results.NS_OK);
			}catch(ex){}
		}
		this._isPending = false;
	}
}