/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




function Bbs2chBoardRss(aBbs2chChannel){
	this._channel = aBbs2chChannel;
	this.init();
}

Bbs2chBoardRss.prototype = {


// ********** ********* vpeB ********** **********


	get channel(){
		return this._channel;
	},

	get boardURL(){
		return this._boardURL;
	},

	get boardItems(){
		return this._boardItems;
	},

	get type(){
		return this._type;
	},


// ********** ********* \bh ********** **********


	init: function(){
		var boardURLSpec = this.channel.URI.spec.replace(/^bbs2ch:board-rss:/, "");
		try{
			this._boardURL = Bbs2chGlobal.ioService.newURI(boardURLSpec, null, null)
								.QueryInterface(Components.interfaces.nsIURL);
		}catch(ex){
			this.requestErrorEnd();
			return;
		}

			// ̃^Cv`FbN
		this._type = Bbs2chGlobal.getBoardType(this._boardURL.spec);

		this._boardItems = new Bbs2chBoardItems(this.boardURL.spec);

			// FoȂ URL
		if(!this.boardItems.validURL){
			this.requestErrorEnd();
			return;
		}

			// ܂wǂĂȂ
		if(!this.boardItems.subjectFile.exists()){
			this.requestErrorEnd();
			return;
		}

		this._subjectDownloader = new Bbs2chDownloader(this.boardItems.subjectURL.spec,
									this.boardItems.subjectFile.path);
		this._subjectDownloader._context = this;

		this._subjectDownloader.onDownloaderStart = function(){};
		this._subjectDownloader.onDownloaderStop = function(aStatus){
			this._context.RespondRSS();
		};
		this._subjectDownloader.onDownloaderProgressChange = function(aPercentage){};
		this._subjectDownloader.onDownloaderError = function(aErrorCode){
			this._context.requestErrorEnd();
		};
		this._subjectDownloader.download();
	},


	/**
	 * NGXg̑M
	 */
	requestRespond: function(aString){
		this.channel.requestRespond(aString);
	},


	/**
	 * NGXg̏I
	 */
	requestEnd: function(){
		this.channel.requestEnd();
	},


	/**
	 *  RSS 𑗐MďI
	 */
	requestErrorEnd: function(){
		this.requestRespond("<rss />");
		this.requestEnd();
	},


	RespondRSS: function(){
		var template = Bbs2chGlobal.readLocalURI("chrome://bbs2chreader/content/res/board-rss.txt");
		var source = template.replace("%BOARDTITLE%", this.boardItems.title + Bbs2chGlobal.SUB_TITLE)
								.replace("%BOARDURL%", this.boardItems.url.spec);

		var itemSource = this.getItemSource();
		if(!itemSource){
			itemSource = "<item><title>NOT MODIFIED</title><link>bbs2ch:void</link></item>\n";
		}

		if(Bbs2chGlobal.getPrefValue("fls.bbs2chreader.livebookmarks_append_board_link")){
			var boardTemplate = "<item>\n\t<title>%BOARDTITLE%</title>\n\t<link>bbs2ch:board:%BOARDURL%</link>\n</item>\n\n";
			var boardSource = boardTemplate
							.replace("%BOARDTITLE%", this.boardItems.title)
							.replace("%BOARDURL%", this.boardItems.url.spec);
			
			itemSource = boardSource + itemSource;
		}

		source = source.replace("%ITEMLIST%", itemSource);

		source = Bbs2chGlobal.toSJIS(source);
		this.requestRespond(source);
		
		this.requestEnd(true);
	},


	getItemSource: function(){
		var resultArray = new Array();
		var template = "<item>\n\t<title>[%UNREAD%] %TITLE%</title>\n\t<link>%URL%</link>\n</item>";
		var minUnread = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.livebookmarks_min_unread");

		if(!this.boardItems.subjectFile.exists()) return "";
		
		this.boardItems.refresh(0, false);
		var items = this.boardItems.items;

		for(var i=0; i<items.length; i++){
			var item = items[i];
			if(minUnread <= item.unread){
				var source = template.replace("%UNREAD%", item.unread)
						.replace("%TITLE%", item.title)
						.replace("%URL%", "bbs2ch:thread:" + item.url + "l50");			
				resultArray.push(source);
			}
		}
		
		return resultArray.join("\n");
	}
	
}