/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




var treeSubject;
var boardItems;
var subjectDownloader;
var settingDownloader;


/**
 * ϻν
 */
function startup(){
	document.title = location.href;
	document.getElementById("lblTitle").setAttribute("value", location.href);

		// chrome ƤФ줿ߤ
	if(location.href.match(/^chrome:/)){
		alert("BAD URL");
		return;
	}

		// İURLμ
	var boardURLSpec = location.href.replace(/^bbs2ch:board:/, "");
	
	boardItems = new Bbs2chBoardItems(boardURLSpec);

		// ǧǤʤ URL
	if(!boardItems.validURL){
		alert("BAD URL");
		return;
	}

	treeSubject = document.getElementById("treeSubject");

	if(Bbs2chGlobal.getPrefValue("fls.bbs2chreader.board_auto_update")){
		subjectUpdate();
	}else if(!boardItems.subjectFile.exists() || boardItems.subjectFile.fileSize==0){
		subjectUpdate();
	}else if(!boardItems.settingFile.exists() || boardItems.settingFile.fileSize==0){
		settingUpdate();
	}else{
		initTreeSubject();
	}
}


/**
 * λν
 */
function shutdown(){
	treeSubject.view = null;

		// checked ͤ˳Ф
	var chkShowDownedLogs = document.getElementById("chkShowDownedLogs");
	if(!chkShowDownedLogs.checked) chkShowDownedLogs.setAttribute("checked", "false");

		// ɤΥ󥻥
	if(subjectDownloader && subjectDownloader.loading)
		subjectDownloader.abort(true);
	if(settingDownloader && settingDownloader.loading)
		settingDownloader.abort(true);

}


/**
 * TreeSubject ν
 */
function initTreeSubject(){
	document.title = boardItems.title + Bbs2chGlobal.SUB_TITLE;
	document.getElementById("lblTitle").setAttribute("value", boardItems.title);

	var aFilterLimit = Number(document.getElementById("mlstFilterLimit").getAttribute("value"));
	var showDownedLogs = document.getElementById("chkShowDownedLogs").getAttribute("checked") == "true";

	boardItems.refresh(aFilterLimit, showDownedLogs);


		// 
	var sortCol = null;
	var sortProperty = "";
	var sortDirection = "natural";
	var colNodes = treeSubject.getElementsByTagName("treecol");
	for(var i=0; i<colNodes.length; i++){
		if(colNodes[i].getAttribute("sortActive") == "true"){
			sortCol = colNodes[i];
			sortProperty = sortCol.getAttribute("property");
			sortDirection = sortCol.getAttribute("sortDirection");
		}
	}
	function sortFunc(aItemA, aItemB){
		return(aItemA[sortProperty] - aItemB[sortProperty]);
	}
	function reverseFunc(aItemA, aItemB){
		return(aItemB[sortProperty] - aItemA[sortProperty]);
	}	
	if(sortCol && sortDirection=="ascending") boardItems.items.sort(sortFunc);
	if(sortCol && sortDirection=="descending") boardItems.items.sort(reverseFunc);


	var boardTreeView = new Bbs2chBoardTreeView(boardItems.items);
	treeSubject.view = boardTreeView;
	
		// ե
	if(treeSubject.treeBoxObject.view.selection){
		treeSubject.focus();
		treeSubject.treeBoxObject.view.selection.select(0);
	}
}


/**
 * ĥ꡼򥯥å˸ƤФ
 * aEvent event åΥ٥ȥ֥
 */
function treeSubjectClick(aEvent){
		// ĥ꡼Υƥʳ򥯥å
	if(getClickItemIndex(aEvent) == -1) return;

	var openAction = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.board_open_action");

	var eButton = aEvent.button;
	var eDetail = aEvent.detail;

	if(eButton==0 && eDetail==1){
			// å
	}else if(eButton==0 && eDetail==2){
			// ֥륯å
		openThread(openAction == 1);
	}else if(eButton==1 && eDetail==1){
			// ۥ륯å
		openThread(openAction == 0);
	}
}


/**
 * ĥ꡼ǥܡɥ
 * aEvent event ܡɥΥ٥ȥ֥
 */
function treeSubjectKeyDown(aEvent){
	if(treeSubject.currentIndex == -1) return;

		// 󥿡ʳʤ齪λ
	if(!(aEvent.keyCode==aEvent.DOM_VK_ENTER || aEvent.keyCode==aEvent.DOM_VK_RETURN))
		return;

	var openAction = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.board_open_action");

	if(aEvent.ctrlKey){
		openThread(openAction == 0);
	}else{
		openThread(openAction == 1);
	}
}


/**
 * Υåɤ֥饦ǳ
 * @param aAddTab boolean true ʤ鿷֤ǳ
 */
function openThread(aAddTab){
	var index = treeSubject.currentIndex;
	if(index == -1) return;

	var url = boardItems.items[index].url;
	url = "bbs2ch:thread:" + url + "l50";
	
	Bbs2chGlobal.openURI(url, null, aAddTab);
}


/**
 * ĥ꡼Υƥȥ˥塼ɽȤ˸ƤФ
 */
function showTreeSubjectContext(aEvent){
		// ĥ꡼Υƥʳ򥯥å
	if(getClickItemIndex(aEvent) == -1) return false;
	
	return true;
}


/**
 * 򥹥åɤ URL 򥯥åץܡɤ˥ԡ
 */
function copyURL(){
	var index = treeSubject.currentIndex;
	if(index == -1) return;

	var url = boardItems.items[index].url;

	Bbs2chGlobal.setClipBoardString(url);
}


/**
 * 򥹥åɤΥȥ URL 򥯥åץܡɤ˥ԡ
 */
function copyTitleAndURL(){
	var index = treeSubject.currentIndex;
	if(index == -1) return;

	var title = boardItems.items[index].title;
	var url = boardItems.items[index].url;

	Bbs2chGlobal.setClipBoardString(title +"\n"+ url);
}


/**
 * 򥹥åɤΥ (ʣ)
 */
function deleteLog(){
	if(treeSubject.currentIndex == -1) return;

	var indices = getSelectionIndices();

	for(var i=0; i<indices.length; i++){
		var datID = boardItems.items[indices[i]].datID;

					// ǥ쥯ȥ .dat ե
		var datFile = Bbs2chGlobal.createLogFile(boardItems.url.resolve(datID + ".dat"));
					// ǥ쥯ȥ .idx ե
		var idxFile = Bbs2chGlobal.createLogFile(boardItems.url.resolve(datID + ".idx"));

		try{
			if(datFile.exists()) datFile.remove(false);
			if(idxFile.exists()) idxFile.remove(false);
		}catch(e){}
	}
	initTreeSubject();
}




/**
 * ΥåɤΥǥåȤ֤
 * @return array
 */
function getSelectionIndices(){
	var resultArray = new Array();

	var rangeCount = treeSubject.treeBoxObject.view.selection.getRangeCount();
	for(var i=0; i<rangeCount; i++){
		var rangeMin = {};
		var rangeMax = {};		

		treeSubject.treeBoxObject.view.selection.getRangeAt(i, rangeMin, rangeMax);
		for (var j=rangeMin.value; j<=rangeMax.value; j++){
			resultArray.push(j);
		}
	}
	return resultArray;
}


/**
 * treeSubject Υå줿ƥΥǥå֤
 * ƥʳ򥯥åȤϡ-1 ֤
 * @param aEvent event onClick Υ٥
 * @return number ƥΥǥå
 */
function getClickItemIndex(aEvent){
	var row = {}
	var obj = {}
	treeSubject.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, {}, obj);
	if(!obj.value) return -1;
	return row.value;
}


/**
 * åɥȥ򸡺ơ̤ĥ꡼ɽ
 * aSearchString ʤĥ꡼򸵤᤹
 * @param aEvent event ٥ȥ֥
 * @param aSearchString string ʸ
 */
function searchTitle(aEvent, aSearchString){
		// keypress ٥Ȼ˥󥿡ʳ줿
	if((aEvent.type == "keypress") &&
		((aEvent.keyCode != KeyEvent.DOM_VK_ENTER) &&
			(aEvent.keyCode != KeyEvent.DOM_VK_RETURN)))
				return;

		// ĥ꡼򸵤᤹
	if (!aSearchString){
		initTreeSubject();
		return;
	}

		// ĥ꡼ɽ
	boardItems.search(aSearchString);
	var boardTreeView = new Bbs2chBoardTreeView(boardItems.items);
	treeSubject.view = boardTreeView;
}


function setStatus(aString){
	document.getElementById("lblStatus").value = aString;
}

/**
 * subject.txt ɤ
 */
function subjectUpdate(){
	subjectDownloader = new Bbs2chDownloader(boardItems.subjectURL.spec,
									boardItems.subjectFile.path);

	subjectDownloader.onDownloaderStart = function(){
		setStatus("start: " + this.urlSpec);
	};
	subjectDownloader.onDownloaderStop = function(aStatus){
		setStatus("");
		if(!boardItems.settingFile.exists() || boardItems.settingFile.fileSize==0){
			settingUpdate();
		}else{
			initTreeSubject();
		}
	};
	subjectDownloader.onDownloaderProgressChange = function(aPercentage){
		setStatus("downloading: " + aPercentage + "%");
	};
	subjectDownloader.onDownloaderError = function(aErrorCode){
		var errorText = "";
		switch(aErrorCode){
			case this.ERROR_BAD_URL:
				errorText = "BAD URL";
				break;
			case this.ERROR_NOT_AVAILABLE:
				errorText = "NOT AVAILABLE";
				break;
			case this.ERROR_FAILURE:
				errorText = "ERROR FAILURE";
				break;
		}
		setStatus("Download Error: " + errorText +" : "+ this.urlSpec);
	};


	subjectDownloader.download();
	setStatus("request: " + subjectDownloader.urlSpec);
}


/**
 * SETTING.TXT ɤ
 */
function settingUpdate(){
	settingDownloader = new Bbs2chDownloader(boardItems.settingURL.spec,
									boardItems.settingFile.path);

	settingDownloader.onDownloaderStart = function(){
		setStatus("start: " + this.urlSpec);
	};
	settingDownloader.onDownloaderStop = function(aStatus){
		setStatus("");
		initTreeSubject();
	};
	settingDownloader.onDownloaderProgressChange = function(aPercentage){
		setStatus("downloading: " + aPercentage + "%");
	};
	settingDownloader.onDownloaderError = function(aErrorCode){
		if(aErrorCode == this.ERROR_NOT_AVAILABLE){
			setStatus("Download Error: NOT AVAILABLE: " + this.urlSpec);
		}else{
			createSettingFile();
			initTreeSubject();
		}
	};


	settingDownloader.download();
	setStatus("request: " + settingDownloader.urlSpec);
}



function createSettingFile(){
		// ̾ɽ
	var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
							.getService(Components.interfaces.nsIPromptService);
	var promptTitle = boardItems.url.spec + Bbs2chGlobal.SUB_TITLE;
	var promptMsg = "Entry This Board Title";
	var promptValue = { value: "" };
	promptService.prompt(window, promptTitle, promptMsg, promptValue, null, {});

	var settingContent = "";
	if(promptValue.value){
		settingContent = "BBS_TITLE=" + promptValue.value + "\n";
		settingContent = Bbs2chGlobal.toType(settingContent, boardItems.type);
	}

	Bbs2chGlobal.writeFile(boardItems.settingFile.path, settingContent);
}


/**
 * ֥åޡɲ
 * @param aLiveBookmark boolean ʤ饤֥֥åޡȤɲ
 */
function addBookmark(aLiveBookmark){
	const ADD_BOOKMARK_URL = "chrome://browser/content/bookmarks/addBookmark2.xul";
	const ADD_BOOKMARK_FLAG = "centerscreen,chrome,dialog,resizable,dependent";

	var name = boardItems.title + Bbs2chGlobal.SUB_TITLE;
	var url = "bbs2ch:board:" + boardItems.url.spec;
	var feedURL = aLiveBookmark ? "bbs2ch:board-rss:" + boardItems.url.spec : null;


		// XXX see [bug:5494]
	if(Bbs2chGlobal.geckoVersionCompare("1.8") <= 0){
		var arg = { name:name, url:url, feedURL: feedURL};
		openDialog(ADD_BOOKMARK_URL, "", ADD_BOOKMARK_FLAG, arg);
	}else{
		openDialog(ADD_BOOKMARK_URL, "", ADD_BOOKMARK_FLAG , 
				name, url, null, null, null, null, false, null, null, null, feedURL);
	}
}


















/**
 * ĥ꡼ӥ塼֥
 * @constructor
 *
 * @param aItems array ĥ꡼ιܤȤɽ륪֥Ȥ
 */
function Bbs2chBoardTreeView(aItems){
	this._items = aItems;
	this._rowCount = aItems.length;
}


Bbs2chBoardTreeView.prototype = {


	/**
	 * nsIScriptableDateFormat ֤
	 * @return nsIScriptableDateFormat;
	 */	 
	get dateFormat(){
		if(!this._dateFormat){
			this._dateFormat = Components.classes["@mozilla.org/intl/scriptabledateformat;1"]
						.getService(Components.interfaces.nsIScriptableDateFormat);
		}
		return this._dateFormat;
	},
	_dateFormat: null,


	/**
	 * Date ֥ȤեޥåȤ줿ʸ(û)֤
	 * @param aDate date Date ֥
	 * @return string
	 */	 
	getFormatedDate: function(aDate){	
		var dateSelector = this.dateFormat.dateFormatYearMonth
										* this.dateFormat.dateFormatWeekday;
		var year = aDate.getFullYear();
		var month = aDate.getMonth()+1;
		var day = aDate.getDate();
	
		return this.dateFormat.FormatDate("", dateSelector, year, month, day);
	},



// ********** ********* implements nsITreeView ********** **********


	get rowCount(){
		return this._rowCount;
	},
	
	selection: null,

	getCellText : function(aRow, aColID){
		if(aColID.id) aColID = aColID.id; // Gecko 1.7/1.8 ߴ

		var property = document.getElementById(aColID).getAttribute("property");
		var isDate = document.getElementById(aColID).getAttribute("isdate") == "true";
		if(isDate) return this.getFormatedDate(new Date(this._items[aRow][property]));

		return this._items[aRow][property];
	},

	setTree: function(aTree){
		this._treeBox = aTree;
	},

	cycleHeader: function(aColID, aElement){
		if(!aElement) aElement = aColID.element; // Gecko 1.7/1.8 ߴ

		var sortActive	  = aElement.getAttribute("sortActive");
		var sortDirection = aElement.getAttribute("sortDirection");
		var property  = aElement.getAttribute("property");
		var treeNode = aElement.parentNode.parentNode;

		switch(sortDirection){
			case "ascending":
				sortDirection = "descending";
				sortActive = "true";
				break;
			case "descending":
				sortDirection = "natural";
				sortActive = "false";
				break;
			default:
				sortDirection = "ascending";
				sortActive = "true";
				break;
		}

		aElement.setAttribute("sortDirection", sortDirection);
		aElement.setAttribute("sortActive", sortActive);
		var colNodes = aElement.parentNode.getElementsByTagName("treecol");
		for(var i=0; i<colNodes.length; i++){
			if(colNodes[i] == aElement) continue;
			colNodes[i].setAttribute("sortDirection", "natural");
			colNodes[i].setAttribute("sortActive", "false");		
		}

		function sortFunc(aItemA, aItemB){
			return(aItemA[property] - aItemB[property]);
		}
		function reverseFunc(aItemA, aItemB){
			return(aItemB[property] - aItemA[property]);
		}

		treeNode.hidden = true;
		if(sortDirection == "ascending") this._items.sort(sortFunc);
		if(sortDirection == "descending") this._items.sort(reverseFunc);
		treeNode.hidden = false;
	},

	getRowProperties: function(aIndex, aProperties){},
	getCellProperties: function(aRow, aColID, aProperties){},
	getColumnProperties: function(aColID, aColElement, aProperties){},
	isContainer: function(aRow){},
	isContainerOpen: function(aRow){},
	isContainerEmpty: function(aRow){},
	isSeparator: function(aRow){},
	isSorted: function(aRow){},
	canDropOn: function(aIndex){},
	canDropBeforeAfter: function(aIndex, aBefore){},
	drop: function(aIndex, aOrientation){},
	getParentIndex: function getParentIndex(aIndex){},
	hasNextSibling: function(aIndex, aAfterIndex){},
 	getLevel: function(aIndex){},
	getImageSrc: function(aRow, aColID){},
	getProgressMode: function(aRow, aColID){},
	getCellValue: function(aRow, aColID){},
	selectionChanged: function(){},
	cycleCell: function(aRow, aColID){},
	isEditable: function(aRow, aColID){},
	setCellText: function(aRow, aColID, aValue){},
	toggleOpenState: function(aIndex){},
	performAction: function(aAction){},
	performActionOnRow: function(aAction, aRow){},
	performActionOnCell: function(aAction, aRow, aColID){}
}
