/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




function Bbs2chBoardItems(aURLSpec){
	this.init(aURLSpec);
}


Bbs2chBoardItems.prototype = {


// ********** ********* vpeB ********** **********


	get items(){
		return this._items;
	},

	get url(){
		return this._url;
	},


	get subjectURL(){
		return this._subjectURL;
	},


	get subjectFile(){
		return this._subjectFile;
	},

	get settingURL(){
		return this._settingURL;
	},


	get settingFile(){
		return this._settingFile;
	},


	get settingContent(){
		if(!this._settingContent && this.settingFile.exists()){
			this._settingContent = Bbs2chGlobal.readFile(this.settingFile.path);
			this._settingContent = Bbs2chGlobal.fromType(this._settingContent, this.type);
		}
		return this._settingContent;
	},
	_settingContent: "",


	get type(){
		return this._type;
	},


	get validURL(){
		return this._validURL;
	},


	get title(){
		return (this.settingContent.match(/^BBS_TITLE=(.+)/m)) ? RegExp.$1 : this.url.spec;
	},


	get logoURL(){
		var logoURL = (this.settingContent.match(/^BBS_TITLE_PICTURE=(.+)/m)) ? RegExp.$1 : "";
		if(logoURL){
			try{
					// ΃N̉
				return Bbs2chGlobal.ioService.newURI(logoURL, null, this.url);
			}catch(ex){
				return Bbs2chGlobal.ioService.newURI(RegExp.$1, null, null);
			}
		}
		return logoURL;
	},


// ********** ********* \bh ********** **********


	init: function(aURLSpec){
		this._validURL = false;
		try{
			this._url = Bbs2chGlobal.ioService.newURI(aURLSpec, null, null)
								.QueryInterface(Components.interfaces.nsIURL);

			this._subjectURL = Bbs2chGlobal.ioService.newURI("subject.txt", null, this.url)
									.QueryInterface(Components.interfaces.nsIURL);
			this._subjectFile = Bbs2chGlobal.createLogFile(this.subjectURL.spec);

			this._settingURL = Bbs2chGlobal.ioService.newURI("SETTING.TXT", null, this.url)
									.QueryInterface(Components.interfaces.nsIURL);
			this._settingFile = Bbs2chGlobal.createLogFile(this.settingURL.spec);
		}catch(ex){
			return;
		}
		
			// ̃^Cv`FbNBTYPE_PAGE  TYPE_2CH ɂ
		this._type = Bbs2chGlobal.getBoardType(this.url.spec);
		if(this._type == Bbs2chGlobal.TYPE_PAGE)
					this._type = Bbs2chGlobal.TYPE_2CH;


		this._items = new Array();
		this._validURL = true;
	},


	refresh: function(aFilterLimit, aShowDownedLogs){
		const NS_BBS2CH = Bbs2chGlobal.NS_BBS2CH;

		this._items = new Array();
		this._lastItems = null;

			// subject.txt Ƃ͏I
		if(!this.subjectFile.exists()) return;

			// subject.txt ǂݍōsƂ̔zɂB
		var subjectLines = Bbs2chGlobal.readFile(this.subjectFile.path);
		subjectLines = Bbs2chGlobal.fromType(subjectLines, this.type);
		subjectLines = subjectLines.split("\n");


			// s̉͂ɎgK\
		var regLine;
		if(this.type==Bbs2chGlobal.TYPE_2CH || this.type==Bbs2chGlobal.TYPE_BE2CH){ // 2ch
			regLine = /^(\d{9,10})\.dat<>(.+) ?\((\d{1,4})\)/;
		}else if(this.type==Bbs2chGlobal.TYPE_JBBS){ // JBBS
			regLine = /^(\d{9,10})\.cgi,(.+) ?\((\d{1,4})\)/;
		}

			// Xbh URL
		var baseUrlSpec;
		var categoryPath;
		var threadUrlSpec;
		if(this.type == Bbs2chGlobal.TYPE_2CH ||
					this.type == Bbs2chGlobal.TYPE_BE2CH){ // 2ch
			baseUrlSpec = this.url.resolve("../");
			categoryPath = this.url.spec.substring(baseUrlSpec.length);
			threadUrlSpec = baseUrlSpec + "test/read.cgi/" + categoryPath;
		}else if(this.type == Bbs2chGlobal.TYPE_JBBS){ // JBBS
			baseUrlSpec = this.url.resolve("../../");
			categoryPath = this.url.spec.substring(baseUrlSpec.length);
			threadUrlSpec = baseUrlSpec + "bbs/read.cgi/" + categoryPath;
		}

		if(aFilterLimit == -1 ) aFilterLimit = subjectLines.length;		
		var logItemHash = this.getLogItemHash(threadUrlSpec);

			// 邮
		for(var i=0; i<subjectLines.length; i++){
			if(!regLine.test(subjectLines[i])) continue;

				// tB^
			if(!logItemHash.hasOwnProperty("item-" + RegExp.$1) && aFilterLimit<=i)
					continue;

			var item = {};
			item.datID = RegExp.$1;
			item.id = "item-" + item.datID;
			item.number = i + 1;
			item.title = RegExp.$2;
			item.count = Number(RegExp.$3);
			item.read = 0;
			item.unread = 0;
			item.force = this.getThreadForce(item.datID, item.count);
			item.makeDate = item.datID * 1000;
			item.url = threadUrlSpec + item.datID + "/";
			
			if(logItemHash.hasOwnProperty("item-" + item.datID)){
				var logItem = logItemHash["item-" + item.datID];
				var unread = item.count - logItem.read;
				
				item.read = logItem.read;
				item.unread = (unread > 0) ? unread : 0;

					// nbV폜Aĉ DAT Ƃ݂Ȃ
				delete logItemHash["item-" + item.datID];
			}

			this._items.push(item);
		}
		
		// DAT 
		if(aShowDownedLogs){
			for(i in logItemHash){
				this._items.push(logItemHash[i]);
			}
		}
			
	},


	/**
	 * OfBNg .idx ǂݍŃOACenbV
	 */
	getLogItemHash: function(aThreadUrlSpec){
		var resultHash = new Array();

		var regIndexName = /(\d{9,10})\.idx$/i;
		var regTitle = /^title=(.+)/m;
		var regLineCount = /^lineCount=(\d{1,4})/m;
	
		var logDir = Bbs2chGlobal.createLogFile(this.url.spec);
		var entries = logDir.directoryEntries;
		while(entries.hasMoreElements()){ 
			var file = entries.getNext().QueryInterface(Components.interfaces.nsILocalFile);
			if(!regIndexName.test(file.leafName)) continue;
			var datID = RegExp.$1;
			
			var indexContent = Bbs2chGlobal.readFile(file.path);
			indexContent = Bbs2chGlobal.fromType(indexContent, this.type);

			var logItem = {};
				logItem.datID = datID;
				logItem.id = "item-" + datID;
				logItem.number = -1;
				logItem.title = regTitle.test(indexContent) ? "X" + RegExp.$1 : "";
				logItem.count = regLineCount.test(indexContent) ? RegExp.$1 : "";
				logItem.read  = logItem.count;
				logItem.unread = 0;
				logItem.force = 0;
				logItem.makeDate = logItem.datID * 1000;
				logItem.url = aThreadUrlSpec + logItem.datID + "/";
			
			resultHash[logItem.id] = logItem;
		}
		return resultHash;
	},


	/**
	 * Xbh̐Ԃ
	 *
	 * @param aDatID number Xbh ID
	 * @param aCount number ܂܂ł̃X
	 * @return number Xbh̕Ϗݐ/
	 */
	getThreadForce: function(aDatID, aCount){
			// Xbh쐬猻݂܂ł̃~
		var progress = new Date().getTime() - aDatID * 1000;
			// 86400000 = /~b (24 * 60 * 60 * 1000)
		progress = progress / 86400000;

		var force = parseInt((aCount / progress));
		if(isNaN(force)) return 0;
		if(force < 0) return 0;
		return force;
	},


	search: function(aSearchString){
		if(!this._lastItems) this._lastItems = this.items.concat();
	
		var resultItems = new Array();
		for(var i=0; i<this._lastItems.length; i++){
			var title = this._lastItems[i].title;
			if(title.match(new RegExp(aSearchString, "i")))
					resultItems.push(this._lastItems[i]);
		}
		return this._items = resultItems;
	}


}