/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 * Υ֥Ȥϸ߻ѤƤʤ
 *  Bbs2chBoardItems Ȥ
 */

function Bbs2chBoardDS(aURLSpec){
	this.init(aURLSpec);
}

Bbs2chBoardDS.prototype = {


// ********** ********* ץѥƥ ********** **********


	/**
	 * İѤ RDF
	 * @return Bbs2chRDF
	 */
	get rdf(){
		return this._rdf;
	},


	/**
	 * İ RDF ǡ
	 * @return nsIRDFDataSource
	 */
	get ds(){
		return this.rdf.ds;
	},


	get url(){
		return this._url;
	},


	get subjectURL(){
		return this._subjectURL;
	},


	get subjectFile(){
		return this._subjectFile;
	},


	get settingURL(){
		return this._settingURL;
	},


	get settingFile(){
		return this._settingFile;
	},


	get title(){
		var result = this.url.spec;
		if(this.settingFile.exists()){
			var settingContent = Bbs2chGlobal.readFile(this.settingFile.path);
			settingContent = Bbs2chGlobal.fromSJIS(settingContent);
			if(settingContent.match(/^BBS_TITLE=(.+)/m)){
				result = RegExp.$1;
			}
		}
		return result;
	},

	get logoURL(){
		var result = null;
		if(this.settingFile.exists()){
			var settingContent = Bbs2chGlobal.readFile(this.settingFile.path);
			settingContent = Bbs2chGlobal.fromSJIS(settingContent);
			if(settingContent.match(/^BBS_TITLE_PICTURE=(.+)/m)){
				try{
						// Х󥯤β
					result = Bbs2chGlobal.ioService.newURI(RegExp.$1, null, this.url);
				}catch(ex){
					result = Bbs2chGlobal.ioService.newURI(RegExp.$1, null, null);
				}
			}
		}
		return result;
	},

	get type(){
		return this._type;
	},


	get validURL(){
		return this._validURL;
	},


// ********** ********* ᥽å ********** **********


	init: function(aURLSpec){
		this._validURL = false;
		try{
			this._url = Bbs2chGlobal.ioService.newURI(aURLSpec, null, null)
								.QueryInterface(Components.interfaces.nsIURL);

			this._subjectURL = Bbs2chGlobal.ioService.newURI("subject.txt", null, this.url)
									.QueryInterface(Components.interfaces.nsIURL);
			this._subjectFile = Bbs2chGlobal.createLogFile(this.subjectURL.spec);

			this._settingURL = Bbs2chGlobal.ioService.newURI("SETTING.TXT", null, this.url)
									.QueryInterface(Components.interfaces.nsIURL);
			this._settingFile = Bbs2chGlobal.createLogFile(this.settingURL.spec);
		}catch(ex){
			return;
		}
		
			// ĤΥפåTYPE_PAGE  TYPE_2CH ˤ
		this._type = Bbs2chGlobal.getBoardType(this.url.spec);
		if(this._type == Bbs2chGlobal.TYPE_PAGE)
					this._type = Bbs2chGlobal.TYPE_2CH;

		this._rdf = new Bbs2chRDF();
		this.rdf.init();
		
		this._validURL = true;
	},
	
	
	initDS: function(aFilterLimit, aShowDownedLogs){
		const NS_BBS2CH = Bbs2chGlobal.NS_BBS2CH;

			// subject.txt ̵ȤϽλ
		if(!this.subjectFile.exists()) return;

			// subject.txt ɤ߹ǹԤȤˤ롣
		var subjectLines = Bbs2chGlobal.readFile(this.subjectFile.path);
		if(this.type == Bbs2chGlobal.TYPE_2CH){
			subjectLines = Bbs2chGlobal.fromSJIS(subjectLines);
		}else if(this.type == Bbs2chGlobal.TYPE_JBBS){
			subjectLines = Bbs2chGlobal.fromEUC(subjectLines);
		}
		subjectLines = subjectLines.split("\n");

			// ԤβϤ˻Ȥɽ
		var regLine;
		if(this.type == Bbs2chGlobal.TYPE_2CH){ // 2ch
			regLine = /^(\d{9,10})\.dat<>(.+) ?\((\d{1,4})\)/;
		}else if(this.type == Bbs2chGlobal.TYPE_JBBS){ // JBBS
			regLine = /^(\d{9,10})\.cgi,(.+) ?\((\d{1,4})\)/;
		}

			// åɤ URL
		var baseUrlSpec;
		var categoryPath;
		var threadUrlSpec;
		if(this.type == Bbs2chGlobal.TYPE_2CH){ // 2ch
			baseUrlSpec = this.url.resolve("../");
			categoryPath = this.url.spec.substring(baseUrlSpec.length);
			threadUrlSpec = baseUrlSpec + "test/read.cgi/" + categoryPath;
		}else if(this.type == Bbs2chGlobal.TYPE_JBBS){ // JBBS
			baseUrlSpec = this.url.resolve("../../");
			categoryPath = this.url.spec.substring(baseUrlSpec.length);
			threadUrlSpec = baseUrlSpec + "bbs/read.cgi/" + categoryPath;
		}

			// 롼ȥƥʤκ
		this.rdf.clearContainer("urn:bbs2ch:board:root");
		var rootContainer = this.rdf.GetContainer("urn:bbs2ch:board:root");

		var logItemHash = this.getLogItemHash();


		if(aFilterLimit == -1 ) aFilterLimit = subjectLines.length;

			// 뤰
		for(var i=0; i<subjectLines.length; i++){
			if(!regLine.test(subjectLines[i])) continue;
			
			var datID = RegExp.$1;
			var title = RegExp.$2;
			var count = RegExp.$3;
			
				// ե륿
			if(!logItemHash.hasOwnProperty("item-" + datID) && aFilterLimit<=i)
				continue;
			
			var resource = this.rdf.GetResource("urn:bbs2ch:board:thread-" + datID);

			this.rdf.setIntProp(resource.Value, NS_BBS2CH + "active", "true");
			this.rdf.setIntProp(resource.Value, NS_BBS2CH + "number", i + 1);
			this.rdf.setLiteralProp(resource.Value, NS_BBS2CH + "datID", datID);
			this.rdf.setIntProp(resource.Value, NS_BBS2CH + "force", this.getThreadForce(datID, count));
			this.rdf.setLiteralProp(resource.Value, NS_BBS2CH + "title", title);
			this.rdf.setIntProp(resource.Value, NS_BBS2CH + "count", count);
			this.rdf.setLiteralProp(resource.Value, NS_BBS2CH + "url",
							threadUrlSpec + datID + "/");

			if(logItemHash.hasOwnProperty("item-" + datID)){
				var logItem = logItemHash["item-" + datID];
				var read = logItem.read;
				var unread = count - read;
				
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "read", read);
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "unread", unread > 0 ? unread : 0);
				
					// ϥå夫ĤäΤ DAT Ȥߤʤ
				delete logItemHash["item-" + datID];
			}else {
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "read", 0);
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "unread", 0);
			}

			rootContainer.AppendElement(resource);
		}
		

		if(aShowDownedLogs){
				// DAT 
			for(i in logItemHash){
				resource = this.rdf.GetResource("urn:bbs2ch:board:thread-" + logItemHash[i].datID);
				datID = logItemHash[i].datID;
				title = logItemHash[i].title;
				read = logItemHash[i].read;
			
				this.rdf.setLiteralProp(resource.Value, NS_BBS2CH + "active", "false");
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "number", 1000);
				this.rdf.setLiteralProp(resource.Value, NS_BBS2CH + "datID", datID);
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "force", 0);
				this.rdf.setLiteralProp(resource.Value, NS_BBS2CH + "title", "X " + title);
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "count", read);
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "read", read);
				this.rdf.setIntProp(resource.Value, NS_BBS2CH + "unread", 0);
				rootContainer.AppendElement(resource);
			}
		}
	},
	
	
	/**
	 * ǥ쥯ȥ .idx ɤ߹ǥƥϥå
	 */
	getLogItemHash: function(){
		var resultHash = new Array();

		var regIndexName = /(\d{9,10})\.idx$/i;
		var regTitle = /^title=(.+)/m;
		var regLineCount = /^lineCount=(\d{1,4})/m;
	
		var logDir = Bbs2chGlobal.createLogFile(this.url.spec);
		var entries = logDir.directoryEntries;
		while(entries.hasMoreElements()){ 
			var file = entries.getNext().QueryInterface(Components.interfaces.nsILocalFile);
			if(!regIndexName.test(file.leafName)) continue;
			var datID = RegExp.$1;
			
			var indexContent = Bbs2chGlobal.readFile(file.path);
			indexContent = Bbs2chGlobal.fromSJIS(indexContent);

			var logItem = {};
				logItem.id = "item-" + datID;
				logItem.datID = datID;
			if(!regTitle.test(indexContent)) continue;
				logItem.title = RegExp.$1;
			if(!regLineCount.test(indexContent)) continue;
				logItem.read = Number(RegExp.$1);
			
			resultHash[logItem.id] = logItem;
		}
		return resultHash;
	},


	/**
	 * åɤ֤
	 *
	 * @param aDatID number åɤ ID
	 * @param aCount number ޤޤǤΥ쥹
	 * @return number åɤ 10ʬ֤ʿѽ񤭹߿
	 */
	getThreadForce: function(aDatID, aCount){
		var nowDate = new Date();
		var createDate = new Date(aDatID * 1000);
		var progress = nowDate.getTime() - createDate.getTime();
		progress = parseInt(progress / (600 * 1000));
	
		var force = parseInt((aCount / progress) * 100);
		if(force < 0) return 0;
		return force;
	},

	/**
	 * aSearchString ȥޥå륿ȥĥ꥽
	 * ƥ urn:bbs2ch:board:search ʲɲä
	 * @param aSearchString string ʸ
	 */
	searchTitle: function(aSearchString){
			// ƥʤκ
		this.rdf.clearContainer("urn:bbs2ch:board:search");
		var searchContainer = this.rdf.GetContainer("urn:bbs2ch:board:search");
		
		var rootContainer = boardDS.rdf.GetContainer("urn:bbs2ch:board:root");

		var elements = rootContainer.GetElements();
		while(elements.hasMoreElements()){
			var element = elements.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
			var title = boardDS.rdf.getLiteralProp(element.Value, Bbs2chGlobal.NS_BBS2CH + "title");
			if(title && title.Value.match(new RegExp(aSearchString, "i")))
				searchContainer.AppendElement(element);
		}
	}

}