/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




var treeBbsMenu;
var bbsmenuDS;
var historyRDF;
var bbsMenuDownloader;

function startup(){
	bbsmenuDS = new Bbs2chBbsMenuDS();

	historyRDF = new Bbs2chRDF();
	historyRDF.initWithDataSource(historyRDF.rdf.GetDataSource("rdf:history"));

	var btnHistory = document.getElementById("btnHistory");
	btnHistory.hidden = !Bbs2chGlobal.getPrefValue("fls.bbs2chreader.bbsmenu_historymenu_show");


	treeBbsMenu = document.getElementById("treeBbsMenu");
	treeBbsMenu.database.AddDataSource(bbsmenuDS.ds);


	if(bbsmenuDS.bbsMenuFile.exists()){
		initTreeBbsMenu();
	}else{	// bbsmenu.html Ƃ͎Ŏ擾
		bbsmenuUpdate();
	}
}

function shutdown(){
	if(bbsMenuDownloader && bbsMenuDownloader.loading)
		bbsMenuDownloader.abort(true);
}


function initTreeBbsMenu(){
	treeBbsMenu.hidden = true;
	bbsmenuDS.initDS();
	treeBbsMenu.builder.rebuild();
	treeBbsMenu.hidden = false;
}


/**
 * I𒆂̔uEUŊJ
 * @param aAddTab boolean true ȂV^uŊJ
 */
function openBoard(aAddTab){
	if(treeBbsMenu.currentIndex == -1) return;
	var resource = treeBbsMenu.view.getResourceAtIndex(treeBbsMenu.currentIndex);

	var boardURL = resource.Value;
	if(boardURL.indexOf("http://")!=0) return;

	var boardType = bbsmenuDS.rdf.getLiteralProp(resource.Value, 
									Bbs2chGlobal.NS_BBS2CH + "type").Value;

	switch(boardType){
		case Bbs2chGlobal.TYPE_2CH:
		case Bbs2chGlobal.TYPE_BE2CH:
		case Bbs2chGlobal.TYPE_JBBS:
			boardURL = "bbs2ch:board:" + boardURL;
			break;
	}		

	Bbs2chGlobal.openURI(boardURL, null, aAddTab);
}


/**
 * c[NbNƂɌĂ΂
 *
 * @param aEvent event
 */
function treeBbsMenuClick(aEvent){
	var row = {}
	var obj = {};
	treeBbsMenu.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, {}, obj);
	if(row.value == -1) return;	// c[̃ACeȊONbN

	var eButton = aEvent.button;
	var eDetail = aEvent.detail;
	var objName = obj.value;
	var isContainer = treeBbsMenu.view.isContainer(row.value);
	
	if(eButton==0 && eDetail==1 && objName=="twisty"){
			// twisty {^gReĩI[v
		closeAllOpendContainers(row.value);
		return;
	}else if(eDetail==2 && objName!="twisty" && isContainer){
			// _uNbNɂReĩI[v
		closeAllOpendContainers(row.value);
		return;
	}
	
	var openAction = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.bbsmenu_open_action");

	if(eButton==0 && eDetail==1 && !isContainer){
			// NbN
	}else if(eButton==0 && eDetail==2 && !isContainer){
			// _uNbN
			openBoard(openAction == 1);
	}else if(eButton==1 && eDetail==1 && !isContainer){
			// ~hNbN
			openBoard(openAction == 0);
	}
	

}


/**
 * c[̃ReLXgj[\ƂɌĂ΂
 */
function showBbsMenuContext(aEvent){
	var row = {}
	var obj = {};
	treeBbsMenu.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, {}, obj);

		// c[̃ACeȊONbN
	if(row.value == -1) return false;

		// Reȉꍇ̓ReLXgj[oȂ
	return !treeBbsMenu.view.isContainer(row.value);
}


/**
 * I𒆂̔ URL Nbv{[hɃRs[
 */
function copyURL(){
	if(treeBbsMenu.currentIndex == -1) return;
	var resource = treeBbsMenu.view.getResourceAtIndex(treeBbsMenu.currentIndex);

	var boardURL = resource.Value;
	if(boardURL.indexOf("http://")!=0) return;

	Bbs2chGlobal.setClipBoardString(boardURL);
}


/**
 * I𒆂̔ URL ƃ^CgNbv{[hɃRs[
 */
function copyTitleAndURL(){
	if(treeBbsMenu.currentIndex == -1) return;
	var resource = treeBbsMenu.view.getResourceAtIndex(treeBbsMenu.currentIndex);

	var title = bbsmenuDS.rdf.getLiteralProp(resource.Value, 
						Bbs2chGlobal.NS_BBS2CH + "title").Value;

	var boardURL = resource.Value;
	if(boardURL.indexOf("http://")!=0) return;

	Bbs2chGlobal.setClipBoardString(title +"\n"+ boardURL);
}


/**
 * OtH_J
 */
function openLogsDir(){
	var logDir = Bbs2chGlobal.getDataDir();
	try{
		logDir.launch();
	}catch(ex){}
}


/**
 * ݒ_CAOJ
 */
function openSettings(){
	var settingDialogURL = "chrome://bbs2chreader/content/settings/settings.xul";
	window.openDialog(settingDialogURL, "_blank", "chrome, modal, resizable");
}


/**
 * GNXeV}l[Wg About ̕\
 */
function openAbout(){
	var ExtensionManager = Components.classes["@mozilla.org/extensions/manager;1"]
								.getService(Components.interfaces.nsIExtensionManager);
	var emDS = ExtensionManager.datasource;
	var ExtensionID = "urn:mozilla:extension:{0B9D558E-6983-486b-9AAD-B6CBCD2FC807}";

	window.openDialog("chrome://mozapps/content/extensions/about.xul", "",
				"chrome, modal", ExtensionID, emDS);
}
/**
 * About _CAOz[y[WJɗp郁\bh
 */
function openURL(aURLSpec){
	Bbs2chGlobal.openURI(aURLSpec, null, true);
}


/**
 * JĂ邷ׂẴc[Rei
 *
 * @aExceptIndex number ȂReĩCfbNX
 */
function closeAllOpendContainers(aExceptIndex){
	if(!treeBbsMenu.view.isContainerOpen(aExceptIndex)) return;

	if(!Bbs2chGlobal.getPrefValue("fls.bbs2chreader.bbsmenu_toggle_open_container")) return;

		// JĂ邷ׂẴRei
	var openedContainers = treeBbsMenu.database.GetSources(
				bbsmenuDS.rdf.GetResource("http://home.netscape.com/NC-rdf#open"),
				bbsmenuDS.rdf.GetLiteral("true"), true);

	while(openedContainers.hasMoreElements()){
		var container = openedContainers.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
		if(container.Value.indexOf("urn:bbs2ch:") == -1) continue;
		var index = treeBbsMenu.builder.getIndexOfResource(container);
		if(index != aExceptIndex && index != -1) treeBbsMenu.view.toggleOpenState(index);
	}
}


/**
 * ǂ History j[XV
 */
function updateHistoryMenu(){
	const NS_NC_NAME = "http://home.netscape.com/NC-rdf#Name";

	var popHistory = document.getElementById("popHistory");
	while(popHistory.hasChildNodes()){
		popHistory.removeChild(popHistory.firstChild);
	}

	var treeHiddenHistory = document.getElementById("treeHiddenHistory");
	if(treeHiddenHistory.hidden){
		treeHiddenHistory.hidden = false;
		treeHiddenHistory.database.AddDataSource(historyRDF.ds);
	}
	
	treeHiddenHistory.ref = "find:datasource=history&match=URL&method=startswith&text=bbs2ch:board:";
	var boardCount = treeHiddenHistory.treeBoxObject.view.rowCount;
	var boardMax = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.bbsmenu_historymenu_board_max");
	if(boardMax > 15) boardMax = 15;
	if(boardCount > boardMax) boardCount = boardMax;
	if(boardCount > 0){
		for(var i=0; i<boardCount; i++){
			try{
				var url = treeHiddenHistory.builder.getResourceAtIndex(i).Value;
				var title = historyRDF.getLiteralProp(url, NS_NC_NAME).Value;
				title = title.replace(Bbs2chGlobal.SUB_TITLE, "");
				var menuNode = document.createElement("menuitem");
				menuNode.setAttribute("label", title);
				menuNode.setAttribute("value", url);
				menuNode.setAttribute("tooltiptext", url);
				popHistory.appendChild(menuNode);
			}catch(ex){}
		}
	}

	treeHiddenHistory.ref = "find:datasource=history&match=URL&method=startswith&text=bbs2ch:thread:";
	var threadCount = treeHiddenHistory.treeBoxObject.view.rowCount;
	var threadMax = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.bbsmenu_historymenu_thread_max");
	if(threadMax > 15) threadMax = 15;
	if(threadCount > threadMax) threadCount = threadMax;
	if(threadCount > 0){
		if(boardCount > 0) popHistory.appendChild(document.createElement("menuseparator"));
		
		for(i=0; i<threadCount; i++){
			try{
				url = treeHiddenHistory.builder.getResourceAtIndex(i).Value;
				title = historyRDF.getLiteralProp(url, NS_NC_NAME).Value;
				title = title.replace(Bbs2chGlobal.SUB_TITLE, "");
				menuNode = document.createElement("menuitem");
				menuNode.setAttribute("label", title);
				menuNode.setAttribute("value", url);
				menuNode.setAttribute("tooltiptext", url);
				popHistory.appendChild(menuNode);
			}catch(ex){}
		}
	}
}


/**
 * History j[ACeNbNƂ̏
 * @param aEvent event CxgIuWFNg
 */
function popHistoryClick(aEvent){
	var target = aEvent.originalTarget;
	if(target.localName != "menuitem" || !(target.value)) return;
	if(aEvent.button == 0){
		Bbs2chGlobal.openURI(target.value, null, false);
	}else if(aEvent.button == 1){
		target.parentNode.hidePopup();
		Bbs2chGlobal.openURI(target.value, null, true);	
	}
}


/**
 * ^CgāAʂc[ɕ\
 * aSearchString Ȃc[ɖ߂
 * @param aEvent event CxgIuWFNg
 * @param aSearchString string 
 */
function searchTitle(aEvent, aSearchString){
		// keypress CxgɃG^[ȊOꂽ
	if((aEvent.type == "keypress") &&
		((aEvent.keyCode != KeyEvent.DOM_VK_ENTER) &&
			(aEvent.keyCode != KeyEvent.DOM_VK_RETURN)))
				return;
	
	if(aSearchString){
		bbsmenuDS.searchTitle(aSearchString);
		treeBbsMenu.ref = "urn:bbs2ch:bbsmenu:search";
	}else{
		treeBbsMenu.ref = "urn:bbs2ch:bbsmenu:root";
	}
}


/**
 * bbsmenu.html _E[hĔꗗXV
 */
function bbsmenuUpdate(){
	var bbsmenuURL = Bbs2chGlobal.getPrefValue("fls.bbs2chreader.bbsmenu_load_url");
	var bbsmenuFilePath = bbsmenuDS.bbsMenuFile.path;	
	bbsMenuDownloader = new Bbs2chDownloader(bbsmenuURL, bbsmenuDS.bbsMenuFile.path);


	bbsMenuDownloader.onDownloaderStart = function(){
		window.status = "start: " + this.urlSpec;
	};
	bbsMenuDownloader.onDownloaderStop = function(aStatus){
		window.status = "";
		initTreeBbsMenu();
	};
	bbsMenuDownloader.onDownloaderProgressChange = function(aPercentage){
		window.status = "downloading: " + aPercentage + "%";
	};
	bbsMenuDownloader.onDownloaderError = function(aErrorCode){
		window.status = "";
		alert("Download Error: " + aErrorCode + "\n" + this.urlSpec);
	};


	bbsMenuDownloader.download();
	window.status = "request: " + bbsMenuDownloader.urlSpec;
}
