/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




function Bbs2chBbsMenuDS(){
	this.init();
}

Bbs2chBbsMenuDS.prototype = {


// ********** ********* ץѥƥ ********** **********


	/**
	 * İѤ RDF
	 * @return Bbs2chRDF
	 */
	get rdf(){
		return this._rdf;
	},


	/**
	 * İ RDF ǡ
	 * @return nsIRDFDataSource
	 */
	get ds(){
		return this.rdf.ds;
	},


	/**
	 * ǡե bbsmenu.html
	 * @return nsILocalFile
	 */
	get bbsMenuFile(){
		return this._bbsMenuFile;
	},


	/**
	 * ǡե outside.txt
	 * @return nsILocalFile
	 */
	get outsideFile(){
		return this._outsideFile;
	},

// ********** ********* ᥽å ********** **********


	init: function(){
		this._rdf = new Bbs2chRDF();
		this.rdf.init();
		
		this._bbsMenuFile = Bbs2chGlobal.getDataDir();
		this._bbsMenuFile.appendRelativePath("bbsmenu.html");
		this._outsideFile = Bbs2chGlobal.getDataDir();
		this._outsideFile.appendRelativePath("outside.txt");
	},

	initDS: function(){
		var categoryReg = /<BR><B>([^<]+)<\/B><BR>/i;
		var threadReg	= /^<A HREF=([^> ]+)>([^<]+)<\/A>/i;
		var threadReg2	= /^<A HREF=([^> ]+) TARGET=_blank>([^<]+)<\/A>/i;

		const NS_BBS2CH = Bbs2chGlobal.NS_BBS2CH;

			// bbsmenu.html ̵ȤϽλ
		if(!this.bbsMenuFile.exists()) return;

			// 롼ȥƥʤκ
		this.rdf.clearContainer("urn:bbs2ch:bbsmenu:root");
		var rootContainer = this.rdf.GetContainer("urn:bbs2ch:bbsmenu:root");


			// ĥƥʤκ
		this.rdf.clearContainer("urn:bbs2ch:bbsmenu:outside-board");
		var outsideContainer = this.rdf.GetContainer("urn:bbs2ch:bbsmenu:outside-board");
		this.rdf.setLiteralProp(outsideContainer.Resource, NS_BBS2CH + "title", "OUTSIDE");
		var regOutsideLine = /^(http:\/\/.*)\t(.+)\t(type-.+)/;
			// ĥꥹȤ¸ߤʤȤϥƥץ졼Ȥ
		if(!this.outsideFile.exists()){
			var templateContent = Bbs2chGlobal.readLocalURI(
						"chrome://bbs2chreader/content/res/outside.txt");
			Bbs2chGlobal.writeFile(this.outsideFile.path, templateContent);
		}
		var outsideLines = Bbs2chGlobal.readFile(this.outsideFile.path);
		outsideLines = Bbs2chGlobal.fromSJIS(outsideLines).split("\n");
		for(var i=0; i<outsideLines.length; i++){
			var line = outsideLines[i];
			if(regOutsideLine.test(line)){
				var board = this.rdf.GetResource(RegExp.$1);
				this.rdf.setLiteralProp(board, NS_BBS2CH + "title", RegExp.$2);
				this.rdf.setLiteralProp(board, NS_BBS2CH + "type", RegExp.$3);
				outsideContainer.AppendElement(board);
			}
		}
		rootContainer.AppendElement(outsideContainer.Resource);


			// bbsmenu.html ɤ߹ǡԤ˳Ǽ
		var content = Bbs2chGlobal.readFile(this.bbsMenuFile.path);
		content = Bbs2chGlobal.fromSJIS(content);
			// ԰֤ʬν
		content = content.replace(/<\/B><BR><A HREF/igm, "</B><BR>\n<A HREF")
		var contentLines = content.split("\n");
		content = null;
		
		var currentCategory;
			// 뤰
		for(i=0; i<contentLines.length; i++){
			line = contentLines[i];

			if(categoryReg.test(line)){
					// ƥΥƥʤ
				currentCategory = this.rdf.GetContainer("urn:bbs2ch:bbsmenu:category-" + i);
				this.rdf.setLiteralProp(currentCategory.Resource, 
											NS_BBS2CH + "title", RegExp.$1);
				rootContainer.AppendElement(currentCategory.Resource);
			}else if((threadReg.test(line) || threadReg2.test(line)) && currentCategory){
					// İΥ꥽
				board = this.rdf.GetResource(RegExp.$1);
				
				this.rdf.setLiteralProp(board, NS_BBS2CH + "title", RegExp.$2);
				this.rdf.setLiteralProp(board, NS_BBS2CH + "type",
											Bbs2chGlobal.getBoardType(RegExp.$1));
				currentCategory.AppendElement(board);
			}
		}
	},


	/**
	 * aSearchString ȥޥå륿ȥĥ꥽
	 * ƥ urn:bbs2ch:bbsmenu:search ʲɲä
	 * @param aSearchString string ʸ
	 */
	searchTitle: function(aSearchString){
			// ƥʤκ
		this.rdf.clearContainer("urn:bbs2ch:bbsmenu:search");
		var searchContainer = this.rdf.GetContainer("urn:bbs2ch:bbsmenu:search");
		
		var resources = this.ds.GetAllResources();
		while(resources.hasMoreElements()){
			var resource = resources.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
			var title = this.rdf.getLiteralProp(resource.Value, Bbs2chGlobal.NS_BBS2CH + "title");
			if(title && (title.Value.toUpperCase().indexOf(aSearchString.toUpperCase()) != -1))
				searchContainer.AppendElement(resource);
		}
	}
}