/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




function Bbs2chAbone(){
	this.init();
	this.refresh();
}


Bbs2chAbone.prototype = {

	get ngNames(){
		return this._ngNames;
	},
	get ngAddrs(){
		return this._ngAddrs;
	},
	get ngId(){
		return this._ngId;
	},
	get ngWords(){
		return this._ngWords;
	},


	/**
	 *	
	 */
	init: function(){
		this._ngNamesFile = Bbs2chGlobal.getDataDir();
		this._ngNamesFile.appendRelativePath("NGnames.txt");

		this._ngAddrsFile = Bbs2chGlobal.getDataDir();
		this._ngAddrsFile.appendRelativePath("NGaddrs.txt");

		this._ngIdFile = Bbs2chGlobal.getDataDir();
		this._ngIdFile.appendRelativePath("NGid.txt");

		this._ngWordsFile = Bbs2chGlobal.getDataDir();
		this._ngWordsFile.appendRelativePath("NGwords.txt");

		this._ngNames = new Array();
		this._ngAddrs = new Array();
		this._ngId	  = new Array();
		this._ngWords = new Array();
		
		this._enabled = false;
	},


	/**
	 *	NG[ht@Cǂݍ
	 */
	refresh: function(){
		function loadNgFile(aLocalFile){
			if(!aLocalFile.exists()) return new Array();
			var contentLine = Bbs2chGlobal.fromSJIS(Bbs2chGlobal.readFile(aLocalFile.path)).split("\n");
			var resultArray = new Array();
				// 󔒍s͓ǂݍ܂Ȃ
			for(var i=0; i<contentLine.length; i++){
				if(contentLine[i]) resultArray.push(contentLine[i]);
			}
			return resultArray;
		}
		this._ngNames = loadNgFile(this._ngNamesFile);
		this._ngAddrs = loadNgFile(this._ngAddrsFile);
		this._ngId	  = loadNgFile(this._ngIdFile);
		this._ngWords = loadNgFile(this._ngWordsFile);
		
		this._enabled = this.ngNames.length+this.ngAddrs.length+this.ngId.length+this.ngWords.length != 0
	},


	/**
	 *	NG[ht@Cɕۑ
	 */
	save: function(){
		function saveNgFile(aNgArray, aLocalFile){
			var content = Bbs2chGlobal.toSJIS(aNgArray.join("\n"));
			Bbs2chGlobal.writeFile(aLocalFile.path, content);
		}
		saveNgFile(this._ngNames, this._ngNamesFile);
		saveNgFile(this._ngAddrs, this._ngAddrsFile);
		saveNgFile(this._ngId, this._ngIdFile);
		saveNgFile(this._ngWords, this._ngWordsFile);
	},


	/**
	 * NG[hz NG[ho^
	 * @param aNgType string NG [hz̃^Cv "names" "addrs" "id" "words"
	 * @param aWord o^ NG[h
	 */
	appendNgWord: function(aNgType, aWord){
		var aNgArray;
		switch(aNgType){
			case "names": aNgArray = this._ngNames; break;
			case "addrs": aNgArray = this._ngAddrs; break;
			case "id":	  aNgArray = this._ngId;	break;
			case "words": aNgArray = this._ngWords; break;
		}
			// do^̋֎~
		for(var i=0; i<aNgArray.length; i++){
			if(aNgArray[i] == aWord) return;
		}
		aNgArray.push(aWord);
	},


	/**
	 * NG[hz񂩂 NG[h폜
	 * @param aNgType string NG [hz̃^Cv "names" "addrs" "id" "words"
	 * @param aWord 폜 NG[h
	 */
	removeNgWord: function(aNgType, aWord){
		var aNgArray;
		switch(aNgType){
			case "names": aNgArray = this._ngNames; break;
			case "addrs": aNgArray = this._ngAddrs; break;
			case "id":	  aNgArray = this._ngId;	break;
			case "words": aNgArray = this._ngWords; break;
		}
		for(var i=0; i<aNgArray.length; i++){
			if(aNgArray[i] == aWord) aNgArray.splice(i, 1);
		}
	},


	/**
	 * XANG[hɊY^ԂB(Bbs2chThread ŗp)
	 *  SJIS ő邱
	 * @param aName string O
	 * @param aMail string [AhX
	 * @param aID string ID
	 * @param aMsg string X{
	 * @return boolean Y^
	 */
	shouldAbone: function(aName, aMail, aID, aMsg){
		if(!this._enabled) return false;
	
		function checkAbone(aNgArray, aCheckString){
			aCheckString = Bbs2chGlobal.fromSJIS(aCheckString);
			for(var i=0; i<aNgArray.length; i++){
				if(aNgArray[i] && aCheckString.match(aNgArray[i]))
					return true;
			}
			return false;
		}

		if(checkAbone(this.ngNames, aName)) return true;
		if(checkAbone(this.ngAddrs, aMail)) return true;
		if(checkAbone(this.ngId, aID)) return true;
		if(checkAbone(this.ngWords, aMsg)) return true;
		return false;
	}
}
