const APP_DISPLAY_NAME = "Amazon.com Sidebar";
const APP_NAME = "amazoncomsearch";
const APP_PACKAGE = "www.edazzle.net/amazon/sidebar/";
const APP_VERSION = "1.0";

const APP_JAR_FILE = APP_NAME + ".jar";
const APP_CONTENT_FOLDER = "content/";

const APP_SUCCESS_MESSAGE = "You have successfully installed the Amazon sidebar search\n\n";

initInstall(APP_NAME, APP_PACKAGE, APP_VERSION);

var chromef;
var instFlags = 0;

if(confirm("Install this into the application directory?  (Cancel will install into your profile directory)")) {
	chromef = getFolder("Chrome");
	instFlags = DELAYED_CHROME;
}
else {
	chromef = getFolder("Profile", "chrome");
	instFlags = PROFILE_CHROME;
}

var err = addFile(APP_PACKAGE, APP_VERSION, "chrome/" + APP_JAR_FILE, chromef, null);
if(err == SUCCESS) { 
	var jar = getFolder(chromef, APP_JAR_FILE);
	registerChrome(CONTENT | instFlags, jar, APP_CONTENT_FOLDER);
		
	err = performInstall();
	if(err == SUCCESS) {
		alert(APP_DISPLAY_NAME + " " + APP_VERSION + " has been succesfully installed.\n"
			+ APP_SUCCESS_MESSAGE
			+ "Please restart your browser before continuing.");
	}
	else { 
		alert("Install failed. Error code:" + err);
		cancelInstall(err);
	}
}
else { 
	alert("Failed to create " + APP_JAR_FILE +"\n"
		+"You probably don't have appropriate permissions \n"
		+"(write access to mozilla/chrome directory). \n"
		+"_____________________________\nError code:" + err);
	cancelInstall(err);
}
