*
      SUBROUTINE MATVEC( ALPHA, X, BETA, Y )
*
*     This MatVec routine assumes the matrix is in dense format,
*     and uses the BLAS SGEMV.
*
*     .. Scalar Arguments ..
      REAL               ALPHA, BETA
*     ..
*     .. Array Arguments ..
      REAL               X( * ), Y( * )
*     ..
*     .. Common Blocks ..
*     MAXDIM2 = MAXDIM*MAXDIM.
*
      INTEGER             MAXDIM, MAXDIM2
      PARAMETER         ( MAXDIM = 200, MAXDIM2 = 40000 )
*
      INTEGER             N, LDA
      REAL                A, M
*
      COMMON            / SYSTEM / A( MAXDIM2 ), M( MAXDIM )
      COMMON            / MATDIM / N, LDA
*     ..
      EXTERNAL           SGEMV
*
      CALL SGEMV( 'NOTRANSPOSE', N, N, ALPHA, A, LDA, X, 1, BETA, Y, 1 )
*
      RETURN
*
      END
*
*     =================================================
      SUBROUTINE MATVECTRANS( ALPHA, X, BETA, Y )
*
*     This MatVec routine assumes the matrix is in dense format,
*     and uses the BLAS SGEMV.
*
*     .. Scalar Arguments ..
      REAL               ALPHA, BETA
*     ..
*     .. Array Arguments ..
      REAL               X( * ), Y( * )
*     ..
*     .. Common Blocks ..
*     MAXDIM2 = MAXDIM*MAXDIM.
*
      INTEGER             MAXDIM, MAXDIM2
      PARAMETER         ( MAXDIM = 200, MAXDIM2 = 40000 )
*
      INTEGER             N, LDA
      REAL                A, M
*
      COMMON            / SYSTEM / A( MAXDIM2 ), M( MAXDIM )
      COMMON            / MATDIM / N, LDA
*     ..
      EXTERNAL           SGEMV
*
      CALL SGEMV( 'TRANSPOSE', N, N, ALPHA, A, LDA, X, 1, BETA, Y, 1 )
*
      RETURN
*
      END
