/* QMR.f -- translated by f2c (version of 20 August 1993  13:15:44).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static real c_b5 = (float)-1.;
static real c_b6 = (float)1.;
static real c_b45 = (float)0.;


/* Subroutine */ int qmr_(n, b, x, work, ldw, iter, resid, matvec, 
	matvectrans, psolveq, psolvetransq, info)
integer *n;
real *b, *x, *work;
integer *ldw, *iter;
real *resid;
/* Subroutine */ int (*matvec) (), (*matvectrans) (), (*psolveq) (), (*
	psolvetransq) ();
integer *info;
{
    /* System generated locals */
    integer work_dim1, work_offset;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static real beta;
    static integer ptld;
    extern doublereal getbreak_();
    static integer vtld, wtld;
    extern doublereal sdot_();
    static integer ytld, ztld;
    static real gammatol, deltatol, bnrm2;
    extern doublereal snrm2_();
    static integer d, p, q, r, s;
    static real gamma;
    static integer v, w, y, z;
    static real delta, theta;
    extern /* Subroutine */ int sscal_();
    static integer maxit;
    static real c1;
    extern /* Subroutine */ int scopy_();
    static real xitol, gamma1;
    extern /* Subroutine */ int saxpy_();
    static real theta1, xi, epstol, rhotol, eta, eps, rho, tol, betatol, rho1;



/*  -- Iterative template routine -- */
/*     Univ. of Tennessee and Oak Ridge National Laboratory */
/*     October 1, 1993 */
/*     Details of this algorithm are described in "Templates for the */
/*     Solution of Linear Systems: Building Blocks for Iterative */
/*     Methods", Barrett, Berry, Chan, Demmel, Donato, Dongarra, */
/*     Eijkhout, Pozo, Romine, and van der Vorst, SIAM Publications, */
/*     1993. (ftp netlib2.cs.utk.edu; cd linalg; get templates.ps). */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */
/*     .. Function Arguments .. */

/*  Purpose */
/*  ======= */

/*  QMR Method solves the linear system Ax = b using the */
/*  Quasi-Minimal Residual iterative method with preconditioning. */

/*  Convergence test: ( norm( b - A*x ) / norm( b ) ) < TOL. */
/*  For other measures, see the above reference. */

/*  Arguments */
/*  ========= */

/*  N       (input) INTEGER. */
/*          On entry, the dimension of the matrix. */
/*          Unchanged on exit. */

/*  B       (input) REAL array, dimension N. */
/*          On entry, right hand side vector B. */
/*          Unchanged on exit. */

/*  X      (input/output) REAL array, dimension N. */
/*          On input, the initial guess; on exit, the iterated solution. 
*/


/*  WORK    (workspace) REAL array, dimension (LDW,11). */
/*          Workspace for residual, direction vector, etc. */
/*          Note that W and WTLD, Y and YTLD, and Z and ZTLD share */
/*          workspace. */

/*  LDW     (input) INTEGER */
/*          The leading dimension of the array WORK. LDW >= max(1,N). */

/*  ITER    (input/output) INTEGER */
/*          On input, the maximum iterations to be performed. */
/*          On output, actual number of iterations performed. */

/*  RESID   (input/output) REAL */
/*          On input, the allowable convergence measure for */
/*          norm( b - A*x ) / norm( b ). */
/*          On output, the final value of this measure. */

/*  MATVEC  (external subroutine) */
/*          The user must provide a subroutine to perform the */
/*          matrix-vector product */

/*               y := alpha*A*x + beta*y, */

/*          where alpha and beta are scalars, x and y are vectors, */
/*          and A is a matrix. Vector x must remain unchanged. */
/*          The solution is over-written on vector y. */

/*          The call is: */

/*             CALL MATVEC( ALPHA, X, BETA, Y ) */

/*          The matrix is passed into the routine in a common block. */

/*  MATVECTRANS  (external subroutine) */
/*          The user must provide a subroutine to perform the */
/*          matrix-vector product */

/*               y := alpha*A'*x + beta*y, */

/*          where alpha and beta are scalars, x and y are vectors, */
/*          and A' is the tranpose of a matrix A. Vector x must remain */
/*          unchanged. */
/*          The solution is over-written on vector y. */

/*          The call is: */

/*             CALL MATVECTRANS( ALPHA, X, BETA, Y ) */

/*          The matrix is passed into the routine in a common block. */

/*  PSOLVEQ  (external subroutine) */
/*          The user must provide a subroutine to perform the */
/*          preconditioner solve routine for the linear system */

/*               M*x = b, */

/*          where x and b are vectors, and M a matrix. As QMR uses left */
/*          and right preconditioning and the preconditioners are in */
/*          common, we must specify in the call which to use. Vector b */
/*          must remain unchanged. */
/*          The solution is over-written on vector x. */

/*          The call is: */

/*             CALL PSOLVEQ( X, B, 'LEFT' ) */

/*         The preconditioner is passed into the routine in a common block
.*/

/*  PSOLVETRANSQ  (external subroutine) */
/*          The user must provide a subroutine to perform the */
/*          preconditioner solve routine for the linear system */

/*               M'*x = b, */

/*          where x and y are vectors, and M' is the tranpose of a */
/*          matrix M. As QMR uses left and right preconditioning and */
/*          the preconditioners are in common, we must specify in the */
/*          call which to use. Vector b must remain unchanged. */
/*          The solution is over-written on vector x. */

/*          The call is: */

/*             CALL PSOLVETRANSQ( X, B, 'LEFT' ) */

/*         The preconditioner is passed into the routine in a common block
.*/

/*  INFO    (output) INTEGER */

/*          =  0: Successful exit. Iterated approximate solution returned.
 */

/*          >  0: Convergence to tolerance not achieved. This will be */
/*                set to the number of iterations performed. */

/*          <  0: Illegal input parameter, or breakdown occurred */
/*                during iteration. */

/*                Illegal parameter: */

/*                   -1: matrix dimension N < 0 */
/*                   -2: LDW < N */
/*                   -3: Maximum number of iterations ITER <= 0. */

/*                BREAKDOWN: If parameters RHO or OMEGA become smaller */
/*                   than some tolerance, the program will terminate. */
/*                   Here we check against tolerance BREAKTOL. */

/*                  -10: RHO   < BREAKTOL: RHO and RTLD have become */
/*                                         orthogonal. */
/*                 -11: BETA  < BREAKTOL: EPS too small in relation to DEL
TA.*/
/*                                         Convergence has stalled. */
/*                  -12: GAMMA < BREAKTOL: THETA too large. */
/*                                         Convergence has stalled. */
/*                  -13: DELTA < BREAKTOL: Y and Z have become */
/*                                         orthogonal. */
/*                  -14: EPS   < BREAKTOL: Q and PTLD have become */
/*                                         orthogonal. */
/*                 -15: XI    < BREAKTOL: Z too small. Convergence has sta
lled.*/

/*                  BREAKTOL is set in function GETBREAK. */

/*  BLAS CALLS:   SAXPY, SCOPY, SDOT, SNRM2, SSCAL */
/*  ============================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Routines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    work_dim1 = *ldw;
    work_offset = work_dim1 + 1;
    work -= work_offset;
    --x;
    --b;

    /* Function Body */
    *info = 0;

/*     Test the input parameters. */

    if (*n < 0) {
	*info = -1;
    } else if (*ldw < max(1,*n)) {
	*info = -2;
    } else if (*iter <= 0) {
	*info = -3;
    }
    if (*info != 0) {
	return 0;
    }

    maxit = *iter;
    tol = *resid;

/*     Alias workspace columns. */

    r = 1;
    d = 2;
    p = 3;
    ptld = 4;
    q = 5;
    s = 6;
    v = 7;
    vtld = 8;
    w = 9;
    wtld = 9;
    y = 10;
    ytld = 10;
    z = 11;
    ztld = 11;

/*     Set breakdown tolerances. */

    rhotol = getbreak_();
    betatol = getbreak_();
    gammatol = getbreak_();
    deltatol = getbreak_();
    epstol = getbreak_();
    xitol = getbreak_();

/*     Set initial residual. */

    scopy_(n, &b[1], &c__1, &work[r * work_dim1 + 1], &c__1);
    if (snrm2_(n, &x[1], &c__1) != (float)0.) {
	(*matvec)(&c_b5, &x[1], &c_b6, &work[r * work_dim1 + 1]);
	if (snrm2_(n, &work[r * work_dim1 + 1], &c__1) < tol) {
	    goto L30;
	}
    }

    bnrm2 = snrm2_(n, &b[1], &c__1);
    if (bnrm2 == (float)0.) {
	bnrm2 = (float)1.;
    }

    scopy_(n, &work[r * work_dim1 + 1], &c__1, &work[vtld * work_dim1 + 1], &
	    c__1);
    (*psolveq)(&work[y * work_dim1 + 1], &work[vtld * work_dim1 + 1], "LEFT", 
	    4L);
    rho = snrm2_(n, &work[y * work_dim1 + 1], &c__1);

    scopy_(n, &work[r * work_dim1 + 1], &c__1, &work[wtld * work_dim1 + 1], &
	    c__1);
    (*psolvetransq)(&work[z * work_dim1 + 1], &work[wtld * work_dim1 + 1], 
	    "RIGHT", 5L);
    xi = snrm2_(n, &work[z * work_dim1 + 1], &c__1);

    gamma = (float)1.;
    eta = (float)-1.;
    theta = (float)0.;

    *iter = 0;

L10:

/*     Perform Preconditioned QMR iteration. */

    ++(*iter);

    if (dabs(rho) < rhotol || dabs(xi) < xitol) {
	goto L25;
    }

    scopy_(n, &work[vtld * work_dim1 + 1], &c__1, &work[v * work_dim1 + 1], &
	    c__1);
    r__1 = (float)1. / rho;
    sscal_(n, &r__1, &work[v * work_dim1 + 1], &c__1);
    r__1 = (float)1. / rho;
    sscal_(n, &r__1, &work[y * work_dim1 + 1], &c__1);

    scopy_(n, &work[wtld * work_dim1 + 1], &c__1, &work[w * work_dim1 + 1], &
	    c__1);
    r__1 = (float)1. / xi;
    sscal_(n, &r__1, &work[w * work_dim1 + 1], &c__1);
    r__1 = (float)1. / xi;
    sscal_(n, &r__1, &work[z * work_dim1 + 1], &c__1);

    delta = sdot_(n, &work[z * work_dim1 + 1], &c__1, &work[y * work_dim1 + 1]
	    , &c__1);
    if (dabs(delta) < deltatol) {
	goto L25;
    }

    (*psolveq)(&work[ytld * work_dim1 + 1], &work[y * work_dim1 + 1], "RIGHT",
	     5L);
    (*psolvetransq)(&work[ztld * work_dim1 + 1], &work[z * work_dim1 + 1], 
	    "LEFT", 4L);

    if (*iter > 1) {
	c1 = -(doublereal)(xi * delta / eps);
	saxpy_(n, &c1, &work[p * work_dim1 + 1], &c__1, &work[ytld * 
		work_dim1 + 1], &c__1);
	scopy_(n, &work[ytld * work_dim1 + 1], &c__1, &work[p * work_dim1 + 1]
		, &c__1);
	r__1 = -(doublereal)(rho * delta / eps);
	saxpy_(n, &r__1, &work[q * work_dim1 + 1], &c__1, &work[ztld * 
		work_dim1 + 1], &c__1);
	scopy_(n, &work[ztld * work_dim1 + 1], &c__1, &work[q * work_dim1 + 1]
		, &c__1);
    } else {
	scopy_(n, &work[ytld * work_dim1 + 1], &c__1, &work[p * work_dim1 + 1]
		, &c__1);
	scopy_(n, &work[ztld * work_dim1 + 1], &c__1, &work[q * work_dim1 + 1]
		, &c__1);
    }

    (*matvec)(&c_b6, &work[p * work_dim1 + 1], &c_b45, &work[ptld * work_dim1 
	    + 1]);

    eps = sdot_(n, &work[q * work_dim1 + 1], &c__1, &work[ptld * work_dim1 + 
	    1], &c__1);
    if (dabs(eps) < epstol) {
	goto L25;
    }

    beta = eps / delta;
    if (dabs(beta) < betatol) {
	goto L25;
    }

    scopy_(n, &work[ptld * work_dim1 + 1], &c__1, &work[vtld * work_dim1 + 1],
	     &c__1);
    r__1 = -(doublereal)beta;
    saxpy_(n, &r__1, &work[v * work_dim1 + 1], &c__1, &work[vtld * work_dim1 
	    + 1], &c__1);
    (*psolveq)(&work[y * work_dim1 + 1], &work[vtld * work_dim1 + 1], "LEFT", 
	    4L);

    rho1 = rho;
    rho = snrm2_(n, &work[y * work_dim1 + 1], &c__1);

    scopy_(n, &work[w * work_dim1 + 1], &c__1, &work[wtld * work_dim1 + 1], &
	    c__1);
    r__1 = -(doublereal)beta;
    (*matvectrans)(&c_b6, &work[q * work_dim1 + 1], &r__1, &work[wtld * 
	    work_dim1 + 1]);
    (*psolvetransq)(&work[z * work_dim1 + 1], &work[wtld * work_dim1 + 1], 
	    "RIGHT", 5L);

    xi = snrm2_(n, &work[z * work_dim1 + 1], &c__1);

    gamma1 = gamma;
    theta1 = theta;

    theta = rho / (gamma1 * dabs(beta));
/* Computing 2nd power */
    r__1 = theta;
    gamma = (float)1. / sqrt(r__1 * r__1 + (float)1.);
    if (dabs(gamma) < gammatol) {
	goto L25;
    }

/* Computing 2nd power */
    r__1 = gamma;
/* Computing 2nd power */
    r__2 = gamma1;
    eta = -(doublereal)eta * rho1 * (r__1 * r__1) / (beta * (r__2 * r__2));

    if (*iter > 1) {
/* Computing 2nd power */
	r__2 = theta1 * gamma;
	r__1 = r__2 * r__2;
	sscal_(n, &r__1, &work[d * work_dim1 + 1], &c__1);
	saxpy_(n, &eta, &work[p * work_dim1 + 1], &c__1, &work[d * work_dim1 
		+ 1], &c__1);
/* Computing 2nd power */
	r__2 = theta1 * gamma;
	r__1 = r__2 * r__2;
	sscal_(n, &r__1, &work[s * work_dim1 + 1], &c__1);
	saxpy_(n, &eta, &work[ptld * work_dim1 + 1], &c__1, &work[s * 
		work_dim1 + 1], &c__1);
    } else {
	scopy_(n, &work[p * work_dim1 + 1], &c__1, &work[d * work_dim1 + 1], &
		c__1);
	sscal_(n, &eta, &work[d * work_dim1 + 1], &c__1);
	scopy_(n, &work[ptld * work_dim1 + 1], &c__1, &work[s * work_dim1 + 1]
		, &c__1);
	sscal_(n, &eta, &work[s * work_dim1 + 1], &c__1);
    }

/*        Compute current solution vector x. */

    saxpy_(n, &c_b6, &work[d * work_dim1 + 1], &c__1, &x[1], &c__1);

/*        Compute residual vector rk, find norm, */
/*        then check for tolerance. */

    saxpy_(n, &c_b5, &work[s * work_dim1 + 1], &c__1, &work[r * work_dim1 + 1]
	    , &c__1);
    *resid = snrm2_(n, &work[r * work_dim1 + 1], &c__1) / bnrm2;
    if (*resid <= tol) {
	goto L30;
    }
    if (*iter == maxit) {
	goto L20;
    }

    goto L10;

L20:

/*     Iteration fails. */

    *info = 1;
    return 0;

L25:

/*     Method breakdown. */

    if (dabs(rho) < rhotol) {
	*info = -10;
    } else if (dabs(beta) < betatol) {
	*info = -11;
    } else if (dabs(gamma) < gammatol) {
	*info = -12;
    } else if (dabs(delta) < deltatol) {
	*info = -13;
    } else if (dabs(eps) < epstol) {
	*info = -14;
    } else if (dabs(xi) < xitol) {
	*info = -15;
    }

    return 0;

L30:

/*     Iteration successful; return. */

    return 0;

/*     End of QMR */

} /* qmr_ */

