
/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/
/* PROGRAM to build files for sltc doc retrieval */
/* data structs for slatec documentation */

#include "sldoc.h"

/* read lines from ascii files */
char **
rdphrases(char *f,char *errstr,int elsz,void (*storeit)(),int *nstord)
{
    int i,n,c;
    char buf[BFSZ];  /* BFSZ > KEYLN */
    FILE *fp;
    char **stored;

    fp= fopen( f,"r");
    if( !fp )
     {
	 bzero( buf,BFSZ );
	 sprintf( buf,"rdphrases %s %s",errstr,f );
	 perror(buf);
	 exit(-1);
     }
/* count number of lines */
     i= 0;
     while ( (c= getc(fp)) != EOF ) if( c=='\n' ) i++;
     stored= (char **)calloc( i+1, elsz);
     fseek( fp,0,0 );

/* store away data */
    for( i=0; fgets(buf,BFSZ, fp) ; i++ ) 
    {
        n= strlen(buf);
	buf[n-1]='\0';
	(*storeit)(stored,i,buf,n);
    }
    *nstord= i;
    fclose(fp);
    return(stored);
}

stowkey( char **stored, int i, char *buf, int n )
{
   stored[i]= malloc(n);
   bcopy( buf,stored[i],n);
}

stowgam( char **stored, int i, char *buf, int n )
{
    int lim, j,d;
    struct gams *g;

        g= (struct gams *) stored;
/* stow gams number */
	if( n > GAMLN +2 ) lim= GAMLN +2;
	else lim= n;
	for( j=0; j< lim; j++) if( buf[j] == '.') break;
        bcopy( buf, g[i].gam, j);

/* stow gams descrition */
	switch(j){
	  case 1:
	    d= 3; break;
	  case 2:
	    d= 2; break;
	  default:
	    d= 1; break;
	  };
	 
        g[i].describe= malloc(n-j-d+1);
	bcopy( buf+j+d, g[i].describe, n-j-d+1 );
}

int compar(s1,s2)
short *s1,*s2;
{
    return(*s1 - *s2);
}

int scompar(s1,s2)
struct routine *s1,*s2;
{
    return(strncmp(s1->name, s2->name,RTNLN));
}

sortnames( short *bf, int n )
{
    int ncompar();

    qsort( bf, n, sizeof(short), ncompar);
}

/* read binary file */
rd_binfl(char *fn, int **rr, int entrysize)
{
     int f,n;
     struct stat stb;
     char buf[128];
      
     f= open( fn,O_RDONLY,0 );
     if( f <0)
     {
	 bzero( buf,128 );
	 sprintf( buf,"rd_binfl %s",fn );
	 perror(buf);
	 exit(-1);
     }
     fstat(f,&stb);
     n= stb.st_size;
     *rr= (int *)calloc( n, 1);

     read(f,*rr, n );
     close(f);
     return( n/entrysize);
}

wr_binfl(int j, int *rr, char *fn, int entrysize)
{
    int f,n,m;

    f= open( fn,O_CREAT | O_WRONLY,0622 );
    n=  j* entrysize;
printf("%d %d\n",j,n);

     if( n != (m= write(f,rr,n)))
	 perror("wr_binfl");
     close(f);

printf("%d %d\n",m,n);
}
