/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/
/* for xgen */

#include "sldoc.h"

char **keys;
struct gams *gamlist;

extern struct routine *r;
extern unsigned short *Indices;

int Nrtn, Ndx, Nkeys, Ngams; /* number of routines in library */
int totcalls= 0;

main(int argc,char **argv)
{
    char *fn, **rdphrases();
    FILE *fp;
    char buf[BFSZ];
    void stowkey(), stowgam();

    fn= DAF;
    fp= fopen(fn,"r");
    if( !fp )
    {
	 bzero( buf,BFSZ );
	 sprintf( buf,"fopen %s",fn );
	 perror(buf);
	 exit(-1);
    }
    Nrtn= rd_binfl(RTBL,&r,sizeof(struct routine));
    Ndx= rd_binfl(NDX,&Indices,sizeof(short));
    switch(argv[1][0]){
        case 'C':		/* category */
	    gamlist= (struct gams *)rdphrases(GAMS,"gams",
			  sizeof(struct gams),stowgam,&Ngams);
	    getcat_x(argv[1]+1);
	    break;
        case 'D':		/* directory --package */
        case 'F':		/* file -- package */
	    if( !argv[1][1] ) 
	    {
		printf("No routine specified\n");
                exit(0);
	    }
	    getpk(fp,argv[1]+1,argv[2],argv[1][0]);
	    break;
        case 'K':
	    getkey(argv[1]+1);
	    break;
        case 'L':
	    gamlist= (struct gams *)rdphrases(GAMS,"gams",
			  sizeof(struct gams),stowgam,&Ngams);
	    listcat(argv[1]+1,0,0);
	    break;
        case 'X':
        case 'N':
        case 'R':  /* retrieve whole routine */
	    if( !argv[1][1] ) 
	    {
		printf("No routine specified\n");
		if(argv[1][0]=='N')
		{
                  printf("\nCLOSE Window to Return.");
                  getchar();
		}
                exit(0);
	    }
	    getroutine(fp,argv[1]+1,argv[1][0],(FILE *)0);
	    break;
        case 'S':
	    showroutines(argv[1]+1);
	    break;
        case 'Y':
	    keys= rdphrases(KYWDS,"keys",sizeof(char *),stowkey,&Nkeys);
	    showkeys();
	    break;
        default:
	    break;
     };
     exit(0);
}
