
/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/
#include "sldoc.h"
extern struct routine *r;
static FILE *FPs;
static char *Tdir;
static char *Tmp;
extern int Nrtn;

/*  Simple functions for getting all slatec routines used directly
    or indirectly by a specified slatec routine 
*/


getpk(FILE *fpS, char *rtn, char *tdir, char file)
{
    int i;
/*
    rtn-- top routine in tree
    tdir-- directory routines should be written to
*/
    if( !tdir ) tdir= ".";
    if( file=='D' && access(tdir,W_ACC) )
    {
	    printf("ERROR:Cannot write to directory\n");
	    return(-1);
    }

    i= rtntoi( rtn );
    FPs= fpS;
    Tdir= tdir;
    wr_routine(i);

    if( file=='D' )  /* recursive fdcalls */
    {
         Tmp= calloc(Nrtn,1);
         Tmp[i]= 1;   /* flagged written */
	 fdcalls(i);
         free(Tmp);
    }
    return(0);
}

wr_routine(int j)
{
    char lc[12], buf[128], *p, c;
    int i,numlines;
    FILE *fpout;

     bzero( buf,128 );
     bzero( lc,12 );
     p= r[j].name;
     for(i=0; i<RTNLN && p[i]; i++) lc[i] = tolower(p[i]);

    if(r[j].c.type ==1) c='F';
    else c='f';
    sprintf(buf,"%s/%s.%c",Tdir,lc,c);
    fpout= fopen( buf,"w");

    bzero( buf,128 );
    numlines=   r[j].k.srclines + r[j].g.doclines;
    SEEKRTN( FPs,j )
    for(i=0; i< numlines ; i++)
    {
       fgets(buf,CDLN+8,FPs);
       fputs(buf,fpout);
    }
    fclose(fpout);
}

fdcalls(int i)
{
    int k,j;

    j= 0;
    while( (k= fetcher(r[i].c.n,r[i].c.start,&j)) != -1)
    {
	if( Tmp[k] != 1) wr_routine(k);
	Tmp[k]= 1;
        fdcalls(k);
    }
    return;
}
