#ifndef STDINC_H

#define STDINC_H

#if (IDEBUG == 0)
#undef NO_PROFILE
#define NO_PROFILE 1
#undef NODEBUG
#define NODEBUG  1
#endif

#include "dtypes.h"

#define stderr 6

#define TRUE	.true.
#define FALSE	.false.
#define STRING  character*80
#define VSTRING character*(*)
#define CHAR	character
#define real8	double precision
#define REAL8	real8

#define ERROR(message,param) \
		write(*,*) message,param ; \
		 stop ' ** ERROR ** '

#define WARNING(message,param) \
		write(*,*) message,param 

#ifdef NODEBUG 
#define ASSERT( condition,message,param)  {}
#else /* NODEBUG */



#ifdef USE_INLINE

#define ASSERT(condition,message,param )  { \
	if (!(condition)) { \
		write(*,*) message, param; \
		}; \
	}


#else /* USE_INLINE */

#define ASSERT( condition, message, param) \
	{ call assert( condition, message, param ); }
#endif /* USE_INLINE */


#endif /* NODEBUG */





#define doloop(i,istrt,iend) do i=istrt,iend
#define doloop4(i,istrt,iend,inc) do i=istrt,iend,inc


#if RX || PGON || PARAGON || NX
#define FORFLUSH(iounit)  call forflush(iounit)

#define FLUSHPIPE() { call flushpipe(); }
#else
#define FORFLUSH(iounit)
#define FLUSHPIPE()

#endif



#ifndef NO_PROFILE

#define PROFSTART( routine ) 	{ call profstart( routine ); }
#define PROFEND( routine ) 	{ call profend( routine ); }
#define PROFINIT() 		{  call profinit(); }
#define PROFSTAT() 		{ call profstat(); }

#else

#define PROFSTART( routine )
#define PROFEND( routine )
#define PROFINIT()
#define PROFSTAT()

#endif



#endif

