      SUBROUTINE PZLACPT( UPLO, N, A, IA, JA, DESCA, B, IB, JB, DESCB )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*  Purpose
*  =======
*
*  Copy triangular matrix A(ia:(ia+m-1),ja:(ja+n-1)) in
*  full storage to triangular matrix B(ib:(ib+m-1),jb:(jb+m-1))
*  in packed storage form.
*
*
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_
      PARAMETER          ( CTXT_ = 2 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IB, JA, JB, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * )
      COMPLEX*16         A( * ), B( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISUPPER, ISVALID
      INTEGER            IASTART, IBSTART, IIB, INCA, INCB, J, JASTART,
     $                   JBSTART, JJB, LOFFSET, MM
*     ..
*     .. Local Arrays ..
      INTEGER            DESCNEW( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           DESCINITT, PXERBLA, PZCOPY
*     ..
*     .. Executable Statements ..
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISVALID = ( ISLOWER .OR. ISUPPER )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PxLACPT', 1 )
         RETURN
      ENDIF
      DO 10 J = 1, N
         JBSTART = ( JB-1 ) + J
         JASTART = ( JA-1 ) + J
         IF( ISLOWER ) THEN
            IBSTART = ( IB-1 ) + J
            IASTART = ( IA-1 ) + J
            MM = N - J + 1
         ELSE
            IBSTART = ( IB-1 ) + 1
            IASTART = ( IA-1 ) + 1
            MM = J
         ENDIF
         CALL DESCINITT( UPLO, IBSTART, JBSTART, DESCB, IIB, JJB,
     $                   LOFFSET, DESCNEW )
         INCA = 1
         INCB = 1
         CALL PZCOPY( MM, A, IASTART, JASTART, DESCA, INCA,
     $                B( LOFFSET ), IIB, JJB, DESCNEW, INCB )
   10 CONTINUE
   20 CONTINUE
      RETURN
      END
