/* ---------------------------------------------------------------------
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     November 17, 1996
*
*  ---------------------------------------------------------------------
*/

/*
* This file includes the standard C libraries, as well as system
* dependent include files.  
*/

#include "pblas.h"


#if( _F2C_CALL_ == _F2C_ADD_ )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in).
* No redefinition necessary to have following FORTRAN to C interface:
*           FORTRAN CALL               C DECLARATION
*           call pdgemm(...)           void pdgemm_(...)
*
* This is the default.
*/

#endif



#if( _F2C_CALL_ == _F2C_UPCASE )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in)
* following FORTRAN to C interface:
*           FORTRAN CALL               C DECLARATION
*           call pdgemm(...)           void PDGEMM(...)
*/

#define pdtpmm_   PDTPMM
#define pstpmm_   PSTPMM
#define pctpmm_   PCTPMM
#define pztpmm_   PZTPMM

#define pdlamvt_  PDLAMVT
#define pdpptrf_  PDPPTRF
#define pdspmv_  PDSPMV
#define pdspr2k_  PDSPR2K
#define pdsprk_  PDSPRK
#define pslamvt_  PSLAMVT
#define pspptrf_  PSPPTRF
#define psspmv_  PSSPMV
#define psspr2k_  PSSPR2K
#define pssprk_  PSSPRK



#define pchpmv_ PCHPMV
#define pchpr2k_ PCHPR2K
#define pchprk_ PCHPRK
#define pchptrf_ PCHPTRF
#define pclamvt_ PCLAMVT
#define pcspr2k_ PCSPR2K
#define pcsprk_ PCSPRK
#define pzhpmv_ PZHPMV
#define pzhpr2k_ PZHPR2K
#define pzhprk_ PZHPRK
#define pzhptrf_ PZHPTRF
#define pzlamvt_ PZLAMVT
#define pzspr2k_ PZSPR2K
#define pzsprk_ PZSPRK


#endif



#if( _F2C_CALL_ == _F2C_NOCHANGE )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in)
* for following FORTRAN to C interface:
*           FORTRAN CALL               C DECLARATION
*           call pdgemm(...)           void pdgemm(...)
*/
#define pdtpmm_   pdtpmm
#define pstpmm_   pstpmm
#define pctpmm_   pctpmm
#define pztpmm_   pztpmm



#define pdlamvt_  pdlamvt
#define pdpptrf_  pdpptrf
#define pdspmv_  pdspmv
#define pdspr2k_  pdspr2k
#define pdsprk_  pdsprk
#define pslamvt_  pslamvt
#define pspptrf_  pspptrf
#define psspmv_  psspmv
#define psspr2k_  psspr2k
#define pssprk_  pssprk



#define pchpmv_ pchpmv
#define pchpr2k_ pchpr2k
#define pchprk_ pchprk
#define pchptrf_ pchptrf
#define pclamvt_ pclamvt
#define pcspr2k_ pcspr2k
#define pcsprk_ pcsprk
#define pzhpmv_ pzhpmv
#define pzhpr2k_ pzhpr2k
#define pzhprk_ pzhprk
#define pzhptrf_ pzhptrf
#define pzlamvt_ pzlamvt
#define pzspr2k_ pzspr2k
#define pzsprk_ pzsprk

#endif


#if( _F2C_CALL_ == _F2C_F77ISF2C )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in)
* for systems where the fortran "compiler" is actually f2c (a Fortran
* to C conversion utility).
*/
#endif
