      SUBROUTINE PDLASCALET( UPLO, BETA, M, N, C, IC, JC, DESCC, INFO )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose:
* ========
*
* PLASCALET multiplies the M-by-N distributed matrix sub(C)
* denoting C(IC:IC+M-1,JC:JC+N-1) by the scalar beta.
*
* Matrix C is stored in packed storage
*
* Notes
* =====
*
* Each global data object is described by an associated description
* vector.  This vector stores the information required to establish
* the mapping between an object element and its corresponding process
* and memory location.
*
* Let A be a generic term for any 2D block cyclicly distributed array.
* Such a global array has an associated description vector DESCA.
* In the following comments, the character _ should be read as
* "of the global array".
*
* NOTATION        STORED IN      EXPLANATION
* --------------- -------------- --------------------------------------
* DTYPE_C(global) DESCC( DTYPE_ )The descriptor type.  In this case,
*                                DTYPE_C = 1.
* CTXT_C (global) DESCC( CTXT_ ) The BLACS context handle, indicating
*                                the BLACS process grid A is distribu-
*                                ted over. The context itself is glo-
*                                bal, but the handle (the integer
*                                value) may vary.
* M_C    (global) DESCC( M_ )    The number of rows in the global
*                                array A.
* N_C    (global) DESCC( N_ )    The number of columns in the global
*                                array A.
* MB_C   (global) DESCC( MB_ )   The blocking factor used to distribute
*                                the rows of the array.
* NB_C   (global) DESCC( NB_ )   The blocking factor used to distribute
*                                the columns of the array.
* RSRC_C (global) DESCC( RSRC_ ) The process row over which the first
*                                row of the array A is distributed.
* CSRC_C (global) DESCC( CSRC_ ) The process column over which the
*                                first column of the array A is
*                                distributed.
* LLD_C  (local)  DESCC( LLD_ )  The leading dimension of the local
*                                array.  LLD_C >= MAX(1,LOCr(M_C)).
*
* Let K be the number of rows or columns of a distributed matrix,
* and assume that its process grid has dimension p x q.
* LOCr( K ) denotes the number of elements of K that a process
* would receive if K were distributed over the p processes of its
* process column.
* Similarly, LOCc( K ) denotes the number of elements of K that a
* process would receive if K were distributed over the q processes of
* its process row.
* The values of LOCr() and LOCc() may be determined via a call to the
* ScaLAPACK tool function, NUMROC:
*         LOCr( M ) = NUMROC( M, MB_C, MYROW, RSRC_C, NPROW ),
*         LOCc( N ) = NUMROC( N, NB_C, MYCOL, CSRC_C, NPCOL ).
* An upper bound for these quantities may be computed by:
*         LOCr( M ) <= ceil( ceil(M/MB_C)/NPROW )*MB_C
*         LOCc( N ) <= ceil( ceil(N/NB_C)/NPCOL )*NB_C
*
* Arguments
* =========
*
* UPLO    (global input) CHARACTER
*         = 'U':  Upper triangle of C(IC:IC+M-1,JC:JC+N-1)
*         = 'L':  Lower triangle of C(IC:IC+M-1,JC:JC+N-1)
*
*
* BETA    The distributed matrix sub( C ) is multiplied by BETA.
*
* M       (global input) INTEGER
*         The number of rows to be operated on i.e the number of rows
*         of the distributed submatrix sub( C ). M >= 0.
*
* N       (global input) INTEGER
*         The number of columns to be operated on i.e the number of
*         columns of the distributed submatrix sub( C ). N >= 0.
*
* C       (local input/local output)
*         an array of dimension (LLD_C,LOCc(JC+N-1)).
*         This array contains the local pieces of the distributed
*         matrix sub( C ). On exit, this array contains the local
*         pieces of the distributed matrix multiplied by CTO/CFROM.
*
* IC      (global input) INTEGER
*         The row index in the global array C indicating the first
*         row of sub( C ).
*
* JC      (global input) INTEGER
*         The column index in the global array C indicating the
*         first column of sub( C ).
*
* DESCC   (global and local input) INTEGER array of dimension DLEN_.
*         The array descriptor for the distributed matrix C.
*
* INFO    (local output) INTEGER
*         = 0:  successful exit
*         < 0:  If the i-th argument is an array and the j-entry had
*               an illegal value, then INFO = -(i*100+j), if the i-th
*               argument is a scalar and had an illegal value, then
*               INFO = -i.
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_, LLD_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IC, INFO, JC, M, N
      DOUBLE PRECISION   BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCC( * )
      DOUBLE PRECISION   C( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISMYCOL, ISMYROW, ISUPPER, ISVALID
      INTEGER            CONTXT, CPROC, CSRC, IAEND, IASIZE, IASTART,
     $                   ICDIAG, ICFIRST, IDX, IDX_INC, IIC, INC, ISIZE,
     $                   J, JCDIAG, JEND, JJC, JSIZE, JSTART, LCINDX,
     $                   LLD, LOFFSET, LRINDX, MB, MYPCOL, MYPROW, NB,
     $                   NPCOL, NPROW, RPROC, RSRC
      DOUBLE PRECISION   ONE, ZERO
*     ..
*     .. Local Arrays ..
      INTEGER            DESC1( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXFIRST, INDXG2P, NUMROC2
      EXTERNAL           LSAME, INDXFIRST, INDXG2P, NUMROC2
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DCOPY, DESCINITT, DSCAL,
     $                   INFOG2L, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MIN, MOD
*     ..
*     .. Executable Statements ..
      INFO = 0
      ONE = DBLE( 1 )
      ZERO = DBLE( 0 )
      IF( ( BETA.EQ.ONE ) .OR. ( M.LE.0 ) .OR. ( N.LE.0 ) ) THEN
         RETURN
      ENDIF
      CONTXT = DESCC( CTXT_ )
      MB = DESCC( MB_ )
      NB = DESCC( NB_ )
      RSRC = DESCC( RSRC_ )
      CSRC = DESCC( CSRC_ )
      CALL BLACS_GRIDINFO( CONTXT, NPROW, NPCOL, MYPROW, MYPCOL )
      ISUPPER = LSAME( UPLO, 'U' )
      ISLOWER = LSAME( UPLO, 'L' )
      ISVALID = ( ISUPPER .OR. ISLOWER )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASCALET', 1 )
         INFO = -1
         RETURN
      ENDIF
      JSTART = JC
   10 CONTINUE
      IF( JSTART.LE.JC+N-1 ) THEN
         JEND = JSTART - MOD( NB+( JSTART-1 ), NB ) + ( NB-1 )
         JEND = MIN( JEND, JC+N-1 )
         JSIZE = JEND - JSTART + 1
         ISMYCOL = ( MYPCOL.EQ.INDXG2P( JSTART, NB, MYPCOL, CSRC,
     $             NPCOL ) )
         IF( ISMYCOL ) THEN
            JCDIAG = JSTART
            ICDIAG = IC + ( JCDIAG-JC )
            ISMYROW = ( MYPROW.EQ.INDXG2P( ICDIAG, MB, MYPROW, RSRC,
     $                NPROW ) )
*
*                Handle diagonal block.
*
            IF( ISMYROW ) THEN
               CALL DESCINITT( UPLO, ICDIAG, JCDIAG, DESCC, IIC, JJC,
     $                         LOFFSET, DESC1 )
               LLD = DESC1( LLD_ )
               CALL INFOG2L( IIC, JJC, DESC1, NPROW, NPCOL, MYPROW,
     $                       MYPCOL, LRINDX, LCINDX, RPROC, CPROC )
               ISVALID = ( CPROC.EQ.MYPCOL )
               ISVALID = ( RPROC.EQ.MYPROW )
               IDX = ( LOFFSET-1 ) + LRINDX + ( LCINDX-1 )*LLD
               IF( ISUPPER ) THEN
                  INC = 1
                  ISIZE = 1
                  IDX_INC = LLD
               ELSE
                  INC = -1
                  ISIZE = JSIZE
                  IDX_INC = LLD + 1
               ENDIF
               DO 20 J = 1, JSIZE
                  IF( BETA.EQ.ZERO ) THEN
                     CALL DCOPY( ISIZE, ZERO, 0, C( IDX ), 1 )
                  ELSE
                     IF( BETA.NE.ONE ) THEN
                        CALL DSCAL( ISIZE, BETA, C( IDX ), 1 )
                     ENDIF
                  ENDIF
                  IDX = IDX + IDX_INC
                  ISIZE = ISIZE + INC
   20          CONTINUE
   30          CONTINUE
            ENDIF
* end if (ismyrow)
*
*                Handle off-diagonal part.
*
            IF( ISUPPER ) THEN
               IASTART = IC
               IAEND = ICDIAG - 1
            ELSE
               IASTART = ICDIAG + JSIZE
               IAEND = IC + M - 1
            ENDIF
            IASIZE = IAEND - IASTART + 1
            IF( IASIZE.GE.1 ) THEN
               ISIZE = NUMROC2( IASIZE, IASTART, MB, MYPROW, RSRC,
     $                 NPROW )
            ELSE
               ISIZE = 0
            ENDIF
            IF( ISIZE.GE.1 ) THEN
               ICFIRST = INDXFIRST( IASIZE, IASTART, MB, MYPROW, RSRC,
     $                   NPROW )
               CALL DESCINITT( UPLO, ICFIRST, JSTART, DESCC, IIC, JJC,
     $                         LOFFSET, DESC1 )
               LLD = DESC1( LLD_ )
               CALL INFOG2L( IIC, JJC, DESC1, NPROW, NPCOL, MYPROW,
     $                       MYPCOL, LRINDX, LCINDX, RPROC, CPROC )
               ISVALID = ( CPROC.EQ.MYPCOL )
               ISVALID = ( RPROC.EQ.MYPROW )
               IDX = ( LOFFSET-1 ) + LRINDX + ( LCINDX-1 )*LLD
               DO 40 J = 1, JSIZE
                  IF( BETA.EQ.ZERO ) THEN
                     CALL DCOPY( ISIZE, ZERO, 0, C( IDX ), 1 )
                  ELSE
                     IF( BETA.NE.ONE ) THEN
                        CALL DSCAL( ISIZE, BETA, C( IDX ), 1 )
                     ENDIF
                  ENDIF
                  IDX = IDX + LLD
   40          CONTINUE
   50          CONTINUE
            ENDIF
         ENDIF
* end if (ismycol)
         JSTART = JEND + 1
         GOTO 10
      ENDIF
   60 CONTINUE
      RETURN
      END
