      SUBROUTINE PDLAMVT2( UPLO, TRANS, M, N, ALPHA, W, IW, JW, DESCW,
     $                     A, IA, JA, DESCA, INCA, BETA, B, IB, JB,
     $                     DESCB, INCB )
*
*    Purpose
*    =======
*
*    Perform    sub(B) <- alpha*sub(W)*sub(A) + beta*sub(B)
*
*    where
*       mrow = m if (trans == 'N')
*            = n if (trans == 'T')
*       ncol = n if (trans == 'N')
*            = m if (trans == 'T')
*
*       sub(B) = B(ib:ib+mrow-1,jb)  if (incB == 1)
*              = B(ib,jb:jb+mrow-1)  if (incB == descB(M_))
*
*       sub(W) = W(iw:iw+m-1,jw:jw+n-1) if (trans = 'N')
*
*       sub(A) = A(ia:ia+ncol-1,ja) if (incA == 1)
*              = A(ia,ja:ja+ncol-1) if (incA == descA(M_))
*
*    Here A is stored in packed storage.
*
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, M_, N_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, NB_ = 6 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          TRANS, UPLO
      INTEGER            IA, IB, INCA, INCB, IW, JA, JB, JW, M, N
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * ), DESCW( * )
      DOUBLE PRECISION   A( * ), B( * ), W( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISTRANS, ISVALID, NOTRANS
      INTEGER            IIA, IIB, IIW, JEND, JFINAL, JJA, JJB, JJW,
     $                   JSIZE, JSTART, LOFFSET, MROW, NB, NCOL
      DOUBLE PRECISION   BBETA, ONE
*     ..
*     .. Local Arrays ..
      INTEGER            DESCNEW( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           DESCINITT, PDGEMV, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MIN, MOD
*     ..
*     .. Executable Statements ..
      ONE = DBLE( 1 )
      IF( ( M.LE.0 ) .OR. ( N.LE.0 ) ) THEN
         RETURN
      ENDIF
      ISTRANS = LSAME( TRANS, 'T' ) .OR. LSAME( TRANS, 'C' )
      NOTRANS = LSAME( TRANS, 'N' )
      ISVALID = ( ISTRANS .OR. NOTRANS )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 2 )
         RETURN
      ENDIF
      IF( NOTRANS ) THEN
         MROW = M
         NCOL = N
      ELSE
         MROW = N
         NCOL = M
      ENDIF
      ISVALID = ( INCA.EQ.1 ) .OR. ( INCA.EQ.DESCA( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 14 )
         RETURN
      ENDIF
      IF( INCA.EQ.1 ) THEN
         ISVALID = ( 1.LE.IA ) .AND. ( IA+NCOL-1.LE.DESCA( M_ ) )
      ELSE
         ISVALID = ( 1.LE.IA ) .AND. ( IA.LE.DESCA( M_ ) )
      ENDIF
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 11 )
         RETURN
      ENDIF
      IF( INCA.EQ.1 ) THEN
         ISVALID = ( 1.LE.JA ) .AND. ( JA.LE.DESCA( N_ ) )
      ELSE
         ISVALID = ( 1.LE.JA ) .AND. ( JA+NCOL-1.LE.DESCA( N_ ) )
      ENDIF
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 12 )
         RETURN
      ENDIF
      ISVALID = ( INCB.EQ.1 ) .OR. ( INCB.EQ.DESCB( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 20 )
         RETURN
      ENDIF
      IF( INCB.EQ.1 ) THEN
         ISVALID = ( 1.LE.IB ) .AND. ( IB+MROW-1.LE.DESCB( M_ ) )
      ELSE
         ISVALID = ( 1.LE.IB ) .AND. ( IB.LE.DESCB( M_ ) )
      ENDIF
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 17 )
         RETURN
      ENDIF
      IF( INCB.EQ.1 ) THEN
         ISVALID = ( 1.LE.JB ) .AND. ( JB.LE.DESCB( N_ ) )
      ELSE
         ISVALID = ( 1.LE.JB ) .AND. ( JB+MROW-1.LE.DESCB( N_ ) )
      ENDIF
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'PLAMVT2', 18 )
         RETURN
      ENDIF
      IF( INCA.EQ.1 ) THEN
*
*           Access compressed triangular matrix A in column order.
*
         CALL DESCINITT( UPLO, IA, JA, DESCA, IIA, JJA, LOFFSET,
     $                   DESCNEW )
         CALL PDGEMV( TRANS, M, N, ALPHA, W, IW, JW, DESCW,
     $                A( LOFFSET ), IIA, JJA, DESCNEW, INCA, BETA, B,
     $                IB, JB, DESCB, INCB )
      ELSE
*
*         Access compressed triangular matrix A in row order.
*
         JSTART = JA
         JFINAL = JA + NCOL - 1
         IIW = IW
         JJW = JW
         IIB = IB
         JJB = JB
         BBETA = BETA
         NB = DESCA( NB_ )
   10    CONTINUE
         IF( JSTART.LE.JFINAL ) THEN
            JEND = MIN( JFINAL, JSTART-MOD( NB+JSTART-1, NB )+( NB-1 ) )
            JSIZE = JEND - JSTART + 1
            CALL DESCINITT( UPLO, IA, JSTART, DESCA, IIA, JJA, LOFFSET,
     $                      DESCNEW )
            IF( NOTRANS ) THEN
               CALL PDGEMV( TRANS, M, JSIZE, ALPHA, W, IIW, JJW, DESCW,
     $                      A( LOFFSET ), IIA, JJA, DESCNEW,
     $                      DESCNEW( M_ ), BBETA, B, IIB, JJB, DESCB,
     $                      INCB )
               JJW = JJW + JSIZE
            ELSE
               CALL PDGEMV( TRANS, JSIZE, N, ALPHA, W, IIW, JJW, DESCW,
     $                      A( LOFFSET ), IIA, JJA, DESCNEW,
     $                      DESCNEW( M_ ), BBETA, B, IIB, JJB, DESCB,
     $                      INCB )
               IIW = IIW + JSIZE
            ENDIF
*
*           Use beta to be 1  after the first call.
*
            BBETA = ONE
            JSTART = JEND + 1
            GOTO 10
         ENDIF
   20    CONTINUE
      ENDIF
      RETURN
      END
