      SUBROUTINE PCPPTRFF( UPLO, N, A, IA, JA, DESCA, WORK, LWORK,
     $                     INFO )
*
*  -- ScaLAPACK routine (version 1.6 ALPHA) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, INFO, JA, LWORK, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      COMPLEX            A( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PCPPTRFF computes the Cholesky factorization of an N-by-N complex
*  hermitian positive definite distributed matrix sub( A ) denoting
*  A(IA:IA+N-1, JA:JA+N-1).
*
*  The factorization has the form
*
*            sub( A ) = U' * U ,  if UPLO = 'U', or
*
*            sub( A ) = L  * L',  if UPLO = 'L',
*
*  where U is an upper triangular matrix and L is lower triangular.
*
*  Matrix A is stored in packed storage.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  This routine requires square block decomposition ( MB_A = NB_A ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          = 'U':  Upper triangle of sub( A ) is stored;
*          = 'L':  Lower triangle of sub( A ) is stored.
*
*  N       (global input) INTEGER
*          The number of rows and columns to be operated on, i.e. the
*          order of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) COMPLEX pointer into the
*          local memory to an array of dimension (LLD_A, LOCc(JA+N-1)).
*          On entry, this array contains the local pieces of the
*          N-by-N Hermitian distributed matrix sub( A ) to be factored.
*          If UPLO = 'U', the leading N-by-N upper triangular part of
*          sub( A ) contains the upper triangular part of the matrix,
*          and its strictly lower triangular part is not referenced.
*          If UPLO = 'L', the leading N-by-N lower triangular part of
*          sub( A ) contains the lower triangular part of the distribu-
*          ted matrix, and its strictly upper triangular part is not
*          referenced. On exit, if UPLO = 'U', the upper triangular
*          part of the distributed matrix contains the Cholesky factor
*          U, if UPLO = 'L', the lower triangular part of the distribu-
*          ted matrix contains the Cholesky factor L.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  WORK    (local workspace/local output) COMPLEX array
*
*  LWORK   (global and local input) INTEGER
*          The dimension of the array WORK.
*
*          only WORK(1) is untouched if UPLO .eq. 'L'
*
*          LWORK >= NB_A*LOCQ
*
*          where
*          COFF = mod( JA-1, NB_A)
*          NN = (JA+N-1) - (JA - COFF) + 1
*          LOCQ = NUMROC( NN,NB,MYCOL,MYCOL, NPCOL )
*
*
*
*  INFO    (global output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*          > 0:  If INFO = K, the leading minor of order K,
*                A(IA:IA+K-1,JA:JA+K-1) is not positive definite, and
*                the factorization could not be completed.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            DLEN_, CTXT_, MB_, NB_, RSRC_, CSRC_
      PARAMETER          ( DLEN_ = 9, CTXT_ = 2, MB_ = 5, NB_ = 6,
     $                   RSRC_ = 7, CSRC_ = 8 )
      REAL               ONE
      PARAMETER          ( ONE = 1.0E+0 )
      COMPLEX            CONE
      PARAMETER          ( CONE = ( 1.0E+0, 0.0E+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            UPPER
      CHARACTER          COLBTOP, CTRANS, ROWBTOP
      INTEGER            COFF, CPROC, I, IA1, IA2, ICOFF, ICTXT, II,
     $                   IINFO, INEED, IROFF, J, JA1, JA2, JB, JJ, JN,
     $                   LDWORK, LOCQ, LOFFSET1, LOFFSET2, MYCOL, MYROW,
     $                   NN, NPCOL, NPROW, RPROC
*     ..
*     .. Local Arrays ..
      INTEGER            DESC1( DLEN_ ), DESC2( DLEN_ ),
     $                   DESCWORK( DLEN_ ), IDUM1( 1 ), IDUM2( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, DESCINIT, DESCINITT,
     $                   PCHK1MAT, PCHPRK, PCLACPT2, PCLACPT3, PCPOTF2,
     $                   PCTPSM, PTOPGET, PTOPSET, PXERBLA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           LSAME, ICEIL, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ICHAR, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      CTRANS = 'C'
      INEED = 1
      WORK( 1 ) = INEED
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -( 600+CTXT_ )
      ELSE
         CALL CHK1MAT( N, 2, N, 2, IA, JA, DESCA, 6, INFO )
         UPPER = LSAME( UPLO, 'U' )
         IF( INFO.EQ.0 ) THEN
            IROFF = MOD( IA-1, DESCA( MB_ ) )
            ICOFF = MOD( JA-1, DESCA( NB_ ) )
            IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
               INFO = -1
            ELSEIF( IROFF.NE.0 ) THEN
               INFO = -4
            ELSEIF( ICOFF.NE.0 ) THEN
               INFO = -5
            ELSEIF( DESCA( MB_ ).NE.DESCA( NB_ ) ) THEN
               INFO = -( 600+NB_ )
            ENDIF
         ENDIF
         IF( UPPER ) THEN
            IDUM1( 1 ) = ICHAR( 'U' )
         ELSE
            IDUM1( 1 ) = ICHAR( 'L' )
         ENDIF
         IDUM2( 1 ) = 1
         CALL PCHK1MAT( N, 2, N, 2, IA, JA, DESCA, 6, 1, IDUM1, IDUM2,
     $                  INFO )
      ENDIF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PCPPTRFF', -INFO )
         RETURN
      ENDIF
*
*     Quick return if possible
*
      IF( N.EQ.0 ) THEN
         WORK( 1 ) = INEED
         RETURN
      ENDIF
*
      CALL PTOPGET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
*
*
*        CHECK STORAGE REQUIREMENT
*
      IF( UPPER ) THEN
         COFF = MOD( JA-1+DESCA( NB_ ), DESCA( NB_ ) )
         NN = ( JA+N-1 ) - ( JA-COFF ) + 1
         INEED = DESCA( NB_ )*NUMROC( NN, DESCA( NB_ ), MYCOL, MYCOL,
     $           NPCOL )
*
      ELSE
         INEED = 1
      ENDIF
      INEED = MAX( INEED, 1 )
      IF( LWORK.LT.INEED ) THEN
         WORK( 1 ) = INEED
         INFO = 8
         IF( LWORK.NE.-1 ) THEN
            CALL PXERBLA( ICTXT, 'PCPPTRFF', -INFO )
         ENDIF
         RETURN
      ENDIF
*
      IF( UPPER ) THEN
*
*        Split-ring topology for the communication along process
*        columns, 1-tree topology along process rows.
*
         CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', ' ' )
         CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', 'S-ring' )
*
*        A is upper triangular, compute Cholesky factorization A = U'*U.
*
*        Handle the first block of columns separately
*
         JN = MIN( ICEIL( JA, DESCA( NB_ ) )*DESCA( NB_ ), JA+N-1 )
         JB = JN - JA + 1
*
*        Perform unblocked Cholesky factorization on JB block
*
         CALL DESCINITT( UPLO, IA, JA, DESCA, IA1, JA1, LOFFSET1,
     $                   DESC1 )
         CALL PCPOTF2( UPLO, JB, A( LOFFSET1 ), IA1, JA1, DESC1, INFO )
         IF( INFO.NE.0 )
     $      GOTO 30
*
         IF( JB+1.LE.N ) THEN
*
*           Form the row panel of U using the triangular solver
*
            II = IA
            JJ = JA + JB
            NN = N - JB
            RPROC = INDXG2P( II, DESCA( MB_ ), MYROW, DESCA( RSRC_ ),
     $              NPROW )
            CPROC = INDXG2P( JJ, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ),
     $              NPCOL )
*
            LOCQ = NUMROC( NN+COFF, DESCA( NB_ ), MYCOL, CPROC, NPCOL )
            LDWORK = MAX( 1, JB )
            CALL DESCINIT( DESCWORK, JB, NN, DESCA( MB_ ), DESCA( NB_ ),
     $                     RPROC, CPROC, DESCA( CTXT_ ), LDWORK, IINFO )
            IF( LDWORK*LOCQ.GT.LWORK ) THEN
               STOP '** INVALID LWORK '
            ENDIF
            CALL PCLACPT2( UPLO, JB, NN, A, II, JJ, DESCA, WORK, 1,
     $                     1+COFF, DESCWORK )
            CALL PCTPSM( 'Left', UPLO, CTRANS, 'Non-unit', JB, NN, CONE,
     $                   A, IA, JA, DESCA, WORK, 1, 1+COFF, DESCWORK )
            CALL PCLACPT3( UPLO, JB, NN, WORK, 1, 1+COFF, DESCWORK, A,
     $                     II, JJ, DESCA )
*
*           Update the trailing matrix, A = A - U'*U
*
            CALL PCHPRK( UPLO, CTRANS, NN, JB, -ONE, WORK, 1, 1+COFF,
     $                   DESCWORK, ONE, A, IA+JB, JA+JB, DESCA )
         ENDIF
*
*        Loop over remaining block of columns
*
         DO 10 J = JN + 1, JA + N - 1, DESCA( NB_ )
            JB = MIN( N-J+JA, DESCA( NB_ ) )
            I = IA + J - JA
*
*           Perform unblocked Cholesky factorization on JB block
*
            CALL DESCINITT( UPLO, I, J, DESCA, IA1, JA1, LOFFSET1,
     $                      DESC1 )
            CALL PCPOTF2( UPLO, JB, A( LOFFSET1 ), IA1, JA1, DESC1,
     $                    INFO )
            IF( INFO.NE.0 ) THEN
               INFO = INFO + J - JA
               GOTO 30
            ENDIF
*
            IF( J-JA+JB+1.LE.N ) THEN
*
*              Form the row panel of U using the triangular solver
*
               II = I
               JJ = J + JB
               COFF = MOD( JJ-1+DESCA( NB_ ), DESCA( NB_ ) )
               NN = N - J - JB + JA
               RPROC = INDXG2P( II, DESCA( MB_ ), MYROW, DESCA( RSRC_ ),
     $                 NPROW )
               CPROC = INDXG2P( JJ, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ),
     $                 NPCOL )
*
               LOCQ = NUMROC( NN+COFF, DESCA( NB_ ), MYCOL, CPROC,
     $                NPCOL )
               LDWORK = MAX( 1, JB )
               CALL DESCINIT( DESCWORK, JB, NN, DESCA( MB_ ),
     $                        DESCA( NB_ ), RPROC, CPROC,
     $                        DESCA( CTXT_ ), LDWORK, IINFO )
               IF( LDWORK*LOCQ.GT.LWORK ) THEN
                  STOP '** INVALID LWORK '
               ENDIF
               CALL PCLACPT2( UPLO, JB, NN, A, II, JJ, DESCA, WORK, 1,
     $                        1+COFF, DESCWORK )
               CALL PCTPSM( 'Left', UPLO, CTRANS, 'Non-unit', JB, NN,
     $                      CONE, A, I, J, DESCA, WORK, 1, 1+COFF,
     $                      DESCWORK )
               CALL PCLACPT3( UPLO, JB, NN, WORK, 1, 1+COFF, DESCWORK,
     $                        A, II, JJ, DESCA )
*
*              Update the trailing matrix, A = A - U'*U
*
               CALL PCHPRK( UPLO, CTRANS, NN, JB, -ONE, WORK, 1, 1+COFF,
     $                      DESCWORK, ONE, A, I+JB, J+JB, DESCA )
            ENDIF
   10    CONTINUE
*
         WORK( 1 ) = INEED
*
      ELSE
*
*        1-tree topology for the communication along process columns,
*        Split-ring topology along process rows.
*
         CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', 'S-ring' )
         CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', ' ' )
*
*        A is lower triangular, compute Cholesky factorization A = L*L'
*        (right-looking)
*
*        Handle the first block of columns separately
*
         JN = MIN( ICEIL( JA, DESCA( NB_ ) )*DESCA( NB_ ), JA+N-1 )
         JB = JN - JA + 1
*
*        Perform unblocked Cholesky factorization on JB block
*
         CALL DESCINITT( UPLO, IA, JA, DESCA, IA1, JA1, LOFFSET1,
     $                   DESC1 )
         CALL PCPOTF2( UPLO, JB, A( LOFFSET1 ), IA1, JA1, DESC1, INFO )
         IF( INFO.NE.0 )
     $      GOTO 30
*
         IF( JB+1.LE.N ) THEN
*
*           Form the column panel of L using the triangular solver
*
            CALL DESCINITT( UPLO, IA, JA, DESCA, IA1, JA1, LOFFSET1,
     $                      DESC1 )
            CALL DESCINITT( UPLO, IA+JB, JA, DESCA, IA2, JA2, LOFFSET2,
     $                      DESC2 )
            CALL PCTPSM( 'Right', UPLO, CTRANS, 'Non-Unit', N-JB, JB,
     $                   CONE, A, IA, JA, DESCA, A( LOFFSET2 ), IA2,
     $                   JA2, DESC2 )
*
*           Update the trailing matrix, A = A - L*L'
*
            CALL DESCINITT( UPLO, IA+JB, JA, DESCA, IA1, JA1, LOFFSET1,
     $                      DESC1 )
            CALL DESCINITT( UPLO, IA+JB, JA+JB, DESCA, IA2, JA2,
     $                      LOFFSET2, DESC2 )
            CALL PCHPRK( UPLO, 'No Transpose', N-JB, JB, -ONE,
     $                   A( LOFFSET1 ), IA1, JA1, DESC1, ONE, A, IA+JB,
     $                   JA+JB, DESCA )
*
         ENDIF
*
         DO 20 J = JN + 1, JA + N - 1, DESCA( NB_ )
            JB = MIN( N-J+JA, DESCA( NB_ ) )
            I = IA + J - JA
*
*           Perform unblocked Cholesky factorization on JB block
*
            CALL DESCINITT( UPLO, I, J, DESCA, IA1, JA1, LOFFSET1,
     $                      DESC1 )
            CALL PCPOTF2( UPLO, JB, A( LOFFSET1 ), IA1, JA1, DESC1,
     $                    INFO )
            IF( INFO.NE.0 ) THEN
               INFO = INFO + J - JA
               GOTO 30
            ENDIF
*
            IF( J-JA+JB+1.LE.N ) THEN
*
*              Form the column panel of L using the triangular solver
*
               CALL DESCINITT( UPLO, I, J, DESCA, IA1, JA1, LOFFSET1,
     $                         DESC1 )
               CALL DESCINITT( UPLO, I+JB, J, DESCA, IA2, JA2, LOFFSET2,
     $                         DESC2 )
               CALL PCTPSM( 'Right', UPLO, CTRANS, 'Non-Unit',
     $                      N-J-JB+JA, JB, CONE, A, I, J, DESCA,
     $                      A( LOFFSET2 ), IA2, JA2, DESC2 )
*
*              Update the trailing matrix, A = A - L*L'
*
               CALL DESCINITT( UPLO, I+JB, J, DESCA, IA1, JA1, LOFFSET1,
     $                         DESC1 )
               CALL DESCINITT( UPLO, I+JB, J+JB, DESCA, IA2, JA2,
     $                         LOFFSET2, DESC2 )
               CALL PCHPRK( UPLO, 'No Transpose', N-J-JB+JA, JB, -ONE,
     $                      A( LOFFSET1 ), IA1, JA1, DESC1, ONE, A,
     $                      I+JB, J+JB, DESCA )
*
            ENDIF
   20    CONTINUE
*
      ENDIF
*
   30 CONTINUE
*
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
*
      WORK( 1 ) = INEED
      RETURN
*
*     End of PCPPTRFF
*
      END
