      SUBROUTINE PCLACPT2( UPLO, M, N, A, IA, JA, DESCA, B, IB, JB,
     $                     DESCB )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*    Purpose
*    =======
*
*    Copy a vector from a packed storage
*    sub(A) into sub(B)
*    where
*
*    sub(A) = A(ia:ia+m-1,ja:ja+n-1)
*    sub(B) = B(ib:ib+m-1,jb:jb+n-1)
*
*
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_, LLD_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IB, JA, JB, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * )
      COMPLEX            A( * ), B( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ALL_LOCAL, HASWORK
      INTEGER            COFFA, COFFB, CPROC, CSRC, IAEND, IAROW,
     $                   IASTART, IBROW, IDXA, IDXB, IIA, ISIZE, J,
     $                   JACOL, JBCOL, JEND, JJA, JJB, JSIZE, JSTART,
     $                   LCINDX, LDA, LDB, LOFFSET, LRINDX, MB, MYPCOL,
     $                   MYPROW, NB, NPCOL, NPROW, ROFFA, ROFFB, RSRC
*     ..
*     .. Local Arrays ..
      INTEGER            DESCNEW( DLEN_ )
*     ..
*     .. External Functions ..
      INTEGER            INDXFIRST, INDXG2P, NUMROC2
      EXTERNAL           INDXFIRST, INDXG2P, NUMROC2
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CCOPY, DESCINITT, INFOG2L,
     $                   PCCOPY
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
      NB = DESCA( NB_ )
      MB = DESCA( MB_ )
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYPROW,
     $                     MYPCOL )
*
*  Check for special case.
*
      ALL_LOCAL = .false.
      IF( DESCA( CTXT_ ).EQ.DESCB( CTXT_ ) ) THEN
         ROFFA = MOD( IA-1, DESCA( MB_ ) )
         COFFA = MOD( JA-1, DESCA( NB_ ) )
         ROFFB = MOD( IB-1, DESCB( MB_ ) )
         COFFB = MOD( JB-1, DESCB( NB_ ) )
         IAROW = INDXG2P( IA, DESCA( MB_ ), MYPROW, DESCA( RSRC_ ),
     $           NPROW )
         JACOL = INDXG2P( JA, DESCA( NB_ ), MYPCOL, DESCA( CSRC_ ),
     $           NPCOL )
         IBROW = INDXG2P( IB, DESCB( MB_ ), MYPROW, DESCB( RSRC_ ),
     $           NPROW )
         JBCOL = INDXG2P( JB, DESCB( NB_ ), MYPCOL, DESCB( CSRC_ ),
     $           NPCOL )
         ALL_LOCAL = ( DESCA( MB_ ).EQ.DESCB( MB_ ) ) .AND.
     $               ( DESCA( NB_ ).EQ.DESCB( NB_ ) ) .AND.
     $               ( IAROW.EQ.IBROW ) .AND. ( JACOL.EQ.JBCOL ) .AND.
     $               ( ROFFA.EQ.ROFFB ) .AND. ( COFFA.EQ.COFFB )
      ENDIF
      IF( ALL_LOCAL ) THEN
         JSTART = INDXFIRST( N, JA, NB, MYPCOL, DESCA( CSRC_ ), NPCOL )
         HASWORK = ( JA.LE.JSTART ) .AND. ( JSTART.LE.JA+N-1 )
         IF( HASWORK ) THEN
   10       CONTINUE
            IF( JSTART.LE.JA+N-1 ) THEN
               JEND = JSTART - MOD( JSTART-1+NB, NB ) + ( NB-1 )
               JEND = MIN( JA+N-1, JEND )
               JSIZE = JEND - JSTART + 1
               CPROC = INDXG2P( JSTART, NB, MYPCOL, DESCA( CSRC_ ),
     $                 NPCOL )
               ISIZE = 0
               IAEND = IA + M - 1
               IASTART = INDXFIRST( M, IA, MB, MYPROW, DESCA( RSRC_ ),
     $                   NPROW )
               IF( ( IA.LE.IASTART ) .AND. ( IASTART.LE.IAEND ) ) THEN
                  ISIZE = NUMROC2( IAEND-IASTART+1, IASTART, MB, MYPROW,
     $                    DESCA( RSRC_ ), NPROW )
               ENDIF
               IF( ISIZE.GE.1 ) THEN
                  CALL DESCINITT( UPLO, IASTART, JSTART, DESCA, IIA,
     $                            JJA, LOFFSET, DESCNEW )
                  CALL INFOG2L( IIA, JJA, DESCNEW, NPROW, NPCOL, MYPROW,
     $                          MYPCOL, LRINDX, LCINDX, RSRC, CSRC )
                  LDA = DESCNEW( LLD_ )
                  IDXA = ( LOFFSET-1 ) + LRINDX + ( LCINDX-1 )*LDA
                  CALL INFOG2L( IB, JB+( JSTART-JA ), DESCB, NPROW,
     $                          NPCOL, MYPROW, MYPCOL, LRINDX, LCINDX,
     $                          RSRC, CSRC )
                  LDB = DESCB( LLD_ )
                  IDXB = LRINDX + ( LCINDX-1 )*LDB
                  DO 20 J = 1, JSIZE
                     CALL CCOPY( ISIZE, A( IDXA ), 1, B( IDXB ), 1 )
                     IDXA = IDXA + LDA
                     IDXB = IDXB + LDB
   20             CONTINUE
   30             CONTINUE
               ENDIF
* end if (isize >= 1)
               JSTART = MAX( JEND+1, JEND-( NB-1 )+NB*NPCOL )
               GOTO 10
            ENDIF
   40       CONTINUE
* end while
         ENDIF
* end if (haswork)
      ELSE
*
*    Less efficient.
*
         DO 50 JSTART = JA, JA + N - 1
            CALL DESCINITT( UPLO, IA, JSTART, DESCA, IIA, JJA, LOFFSET,
     $                      DESCNEW )
            JJB = JB + ( JSTART-JA )
            CALL PCCOPY( M, A( LOFFSET ), IIA, JJA, DESCNEW, 1, B, IB,
     $                   JJB, DESCB, 1 )
   50    CONTINUE
   60    CONTINUE
      ENDIF
      RETURN
      END
