      PROGRAM PCHPEVXDRIVER
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* PSPEVXDRIVER is the main test program for the symmetric eigen
* solvers with packed storage. This test driver computes the
* eigenvalues and optionally eigenvectors
*
*
*
* The program must be drive by a short data file. An annotated
*
* example of a data file can be obtained by deleting the first 3
* characters from the following 18 lines:
* 'ScaLAPACK LLt factorization input file'
* 'Intel iPSC/860 hypercube, gamma model.'
* 'SPEVX.out'            output file name (if any)
*  6                    device out
* 'U'                  define Lower or Upper
* 'V'                  'V' to compute eigenvectors
*  1                    number of problems sizes
*  31 100 200           values of N
*  1                    number of NBs
*  2 10 24              values of NB
*  1                    number of process grids (ordered pairs of P & Q)
*  2                    values of P
*  2                    values of Q
*  1.0                  threshold value for determining failure
*
*
* Internal Parameters
* ===================
*
* TOTMEM   INTEGER, default = 2000000
*          TOTMEM is a machine-specific parameter indicating the
*          maximum amount of available memory in bytes.
*          The user should customize TOTMEM to his platform.  Remember
*          to leave room in memory for the operating system, the BLACS
*          buffer, etc.  For example, on a system with 8 MB of memory
*          per process (e.g., one processor on an Intel iPSC/860), the
*          parameters we use are TOTMEM=6200000 (leaving 1.8 MB for OS,
*          code, BLACS buffer, etc).  However, for PVM, we usually set
*          TOTMEM = 2000000.  Some experimenting with the maximum value
*          of TOTMEM may be required.
*
* INTGSZ   INTEGER, default = 4 bytes.
* DBLESZ   INTEGER, default = 8 bytes.
*          INTGSZ and DBLESZ indicate the length in bytes on the
*          given platform for an integer and a double precision real.
* MEM      DOUBLE PRECISION array, dimension ( TOTMEM / DBLESZ )
*
*          All arrays used by SCALAPACK routines are allocated from
*          this array and referenced by pointers.  The integer IPA,
*          for example, is a pointer to the starting element of MEM for
*          the matrix A.
*
* =====================================================================
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, M_, N_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_, LLD_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      INTEGER            DBLESZ, TOTMEM
      PARAMETER          ( DBLESZ = 8, TOTMEM = 2*1024*1024 )
      INTEGER            MEMSIZ
      PARAMETER          ( MEMSIZ = TOTMEM / DBLESZ )
      INTEGER            MAXCASES
      PARAMETER          ( MAXCASES = 80 )
      INTEGER            LDNBVAL
      PARAMETER          ( LDNBVAL = MAXCASES )
      INTEGER            LDNVAL, LDPQVAL
      PARAMETER          ( LDNVAL = MAXCASES, LDPQVAL = MAXCASES )
      INTEGER            NIN
      PARAMETER          ( NIN = 5 )
      INTEGER            MAXNPROCS
      PARAMETER          ( MAXNPROCS = 4*1024 )
      INTEGER            MAXN
      PARAMETER          ( MAXN = 50*1000 )
      INTEGER            LIWORK
      PARAMETER          ( LIWORK = 6*MAXN )
      INTEGER            LRWORK
      PARAMETER          ( LRWORK = MAXN*10 )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISMYCOL
      CHARACTER          JOBZ, UPLO
      CHARACTER*3        RANGE
      CHARACTER*6        PASSED
      CHARACTER*80       SUMMRY, USRINFO
      INTEGER            CA, CDEST, CSRC, I, IAM, IASEED, IBSEED, ICNUM,
     $                   ICOFF, ICTXT, IERR, IFREE, II, IL, INFO, IPA,
     $                   IPAP, IPROC, IPWORK, IPZ, IPZP, IRNUM, IROFF,
     $                   IU, IVALUE, J, K, KFAIL, KPASS, KSKIP, LDA,
     $                   LWORK, M, MYCOL, MYPCOL, MYPROW, MYROW, N, NB,
     $                   NFREE, NGRIDS, NMAT, NNB, NOUT, NP, NPCOL,
     $                   NPROCS, NPROW, NQ, NZ, RA, RCFLAG, RDEST, RSRC
      REAL               ABSERR, ABSTOL, ABSW, ABSWP, ANORM, ANORMP,
     $                   DMACHEPS, DNORM2, DTHRESH, DZERO, EIGMAX,
     $                   MACHEPS, ORFAC, RELERR, RESID2, THRESH, TOL,
     $                   VL, VU
      COMPLEX            ALPHA, BETA, ONE, ZERO
*     ..
*     .. Local Arrays ..
      INTEGER            DESCA( DLEN_ ), DESCAP( DLEN_ ),
     $                   DESCWORK( DLEN_ ), DESCZ( DLEN_ ),
     $                   DESCZP( DLEN_ ), ICLUSTR( MAXN ),
     $                   IFAIL( MAXN ), IWORK( LIWORK ),
     $                   NBVAL( LDNBVAL ), NVAL( LDNVAL ),
     $                   PVAL( LDPQVAL ), QVAL( LDPQVAL )
      REAL               GAP( MAXNPROCS ), RWORK( LRWORK ), W( MAXN ),
     $                   WP( MAXN )
      COMPLEX            MEM( MEMSIZ )
      DOUBLE PRECISION   CTIME( 64 ), WTIME( 64 )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXG2P, INFOMEM, INFOMEMT, NUMROC
      REAL               PCLANHE, PCLANHP, PSLAMCH
      EXTERNAL           LSAME, INDXG2P, INFOMEM, INFOMEMT, NUMROC,
     $                   PCLANHE, PCLANHP, PSLAMCH
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_BARRIER, BLACS_GET,
     $                   BLACS_GRIDEXIT, BLACS_GRIDINFO, BLACS_GRIDINIT,
     $                   BLACS_PINFO, BLACS_SETUP, DESCINIT, ICOPY,
     $                   IGEBR2D, IGEBS2D, IGSUM2D, PCCOPY, PCHEEVX,
     $                   PCHEMV, PCHPEVX, PCLACPT, PCLASET, PCMATGEN,
     $                   PCSCAL, PSCNRM2, SGAMX2D, SGEBR2D, SGEBS2D,
     $                   SLBOOT, SLCOMBINE, SLTIMER
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, CHAR, CMPLX, DBLE, ICHAR, MAX, REAL
*     ..
*     .. Executable Statements ..
      JOBZ = 'N'
      UPLO = 'L'
      ONE = CMPLX( REAL( 1 ) )
      ZERO = CMPLX( REAL( 0 ) )
      DO 10 I = 1, LRWORK
         RWORK( I ) = REAL( 0 )
   10 CONTINUE
   20 CONTINUE
      DO 30 I = 1, LIWORK
         IWORK( I ) = 0
   30 CONTINUE
   40 CONTINUE
      CALL BLACS_PINFO( IAM, NPROCS )
      IASEED = 100
      IBSEED = 200
      KSKIP = 0
      KPASS = 0
      KFAIL = 0
      DZERO = REAL( 0 )
      DO 50 I = 1, LRWORK
         RWORK( I ) = DZERO
   50 CONTINUE
   60 CONTINUE
      DO 70 I = 1, LIWORK
         IWORK( I ) = 0
   70 CONTINUE
   80 CONTINUE
*
*   Read in information.
*
*
*      Process 0 reads the input data, broadcasts to other processes and
*      writes needed information to NOUT
*
      IF( IAM.EQ.0 ) THEN
         OPEN( NIN, FILE = 'SPEVX.dat', STATUS = 'old' )
         REWIND ( NIN )
         READ( NIN, FMT = '(A)' )SUMMRY
         SUMMRY = ' '
         READ( NIN, FMT = '(A)' )USRINFO
*
*       Read name and unit number for summary output file
*
         READ( NIN, FMT = * )SUMMRY
         READ( NIN, FMT = * )NOUT
         IF( ( NOUT.NE.0 ) .AND. ( NOUT.NE.6 ) ) THEN
            OPEN( NOUT, FILE = SUMMRY, STATUS = 'unknown' )
            REWIND ( NOUT )
         ENDIF
*
*       Read and check the parameter values for the tests.
*
         READ( NIN, FMT = * )UPLO
         READ( NIN, FMT = * )JOBZ
         READ( NIN, FMT = * )NMAT
         IF( ( NMAT.LT.1 ) .OR. ( NMAT.GT.LDNVAL ) ) THEN
            WRITE( NOUT, FMT = 9987 )'n', LDNVAL
            GOTO 260
         ENDIF
         READ( NIN, FMT = * )( NVAL( I ), I = 1, NMAT )
*
*       Get values of nb.
*
         READ( NIN, FMT = * )NNB
         IF( ( NNB.LT.1 ) .OR. ( NMAT.GT.LDNBVAL ) ) THEN
            WRITE( NOUT, FMT = 9987 )'nb', LDNBVAL
            GOTO 260
         ENDIF
         READ( NIN, FMT = * )( NBVAL( I ), I = 1, NNB )
*
*       Get number of grids.
*
         READ( NIN, FMT = * )NGRIDS
         IF( ( NGRIDS.LT.1 ) .OR. ( NGRIDS.GT.LDPQVAL ) ) THEN
            WRITE( NOUT, FMT = 9987 )'ngrids', LDPQVAL
            GOTO 260
         ENDIF
         READ( NIN, FMT = * )( PVAL( I ), I = 1, NGRIDS )
         READ( NIN, FMT = * )( QVAL( I ), I = 1, NGRIDS )
         READ( NIN, FMT = * )THRESH
         DTHRESH = REAL( THRESH )
         CLOSE ( NIN )
*
**
**        For pvm only: if virtual machine not set up, allocate it and
**        spawn the correct number of processes.
**
*
         IF( NPROCS.LT.1 ) THEN
            NPROCS = 0
            DO 90 I = 1, NGRIDS
               NPROCS = MAX( NPROCS, PVAL( I )*QVAL( I ) )
   90       CONTINUE
  100       CONTINUE
            CALL BLACS_SETUP( IAM, NPROCS )
         ENDIF
*
**
**        Temporarily define blacs grid to include all processes so
**        information can be broadcast to all processes.
**
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*       Perform broadcast.
*
         DMACHEPS = PSLAMCH( ICTXT, 'Epsilon' )
         MACHEPS = REAL( DMACHEPS )
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, MACHEPS, 1 )
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NMAT, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NNB, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NGRIDS, 1 )
         IVALUE = ICHAR( UPLO )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, IVALUE, 1 )
         IVALUE = ICHAR( JOBZ )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, IVALUE, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NMAT, NVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NNB, NBVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NGRIDS, PVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NGRIDS, QVAL, 1 )
*
*       write out information about this run.
*
         WRITE( NOUT, FMT = 9999 )
         WRITE( NOUT, FMT = 9998 )
 9999    FORMAT( 'ScaLAPACK symmetric packed eigensolver',
     $         / 'Computes the eigenvalues and eigenvectors (option)',
     $         / 'The matrix A is randomly generated for each test. ',
     $         / 'The residual (R) for each eigen pair is computed as ',
     $         / ' R = || A*v - lam*v ||/( epsilon*||A||)   ',
     $         / ' An eigen pair is acceptable if R <= thresh ' )
 9998    FORMAT( 1X,
     $         'An explanation of the input/output parameters follows:',
     $         / ' ', /
     $         'uplo:     whether the data is stored in upper or lower '
     $         , / '          portion of array A',
     $         / 'jobz:     whether to compute eigenvectors too ',
     $         / 'n:        the number of rows and columns',
     $         / 'nb:       the size of square blocks A is split into',
     $         / 'p,q:      the number of process rows and columns.', /
     $      'PxHEEVX: solution time in seconds to complete computations'
     $         , /
     $      'PxHPEVX: solution time in seconds to complete computations'
     $         , / )
         WRITE( NOUT, FMT = '(A)' )
     $      'The following parameter values will be used'
         WRITE( NOUT, FMT = 9996 )'uplo: ', UPLO
         WRITE( NOUT, FMT = 9997 )'n: ', ( NVAL( I ), I = 1, NMAT )
         WRITE( NOUT, FMT = 9997 )'p: ', ( PVAL( I ), I = 1, NGRIDS )
         WRITE( NOUT, FMT = 9997 )'q: ', ( QVAL( I ), I = 1, NGRIDS )
         WRITE( NOUT, FMT = 9995 )'thresh: ', THRESH
 9997    FORMAT( 2X, A10, ( 10I6 ), / ( 12X, ( 10I6 ) ) )
 9996    FORMAT( 2X, A10, A )
 9995    FORMAT( 2X, A10, 1X, 1P, E14.4 )
      ELSE
*
**
**        If in pvm, must participate setting up virtual machine
**
*
         IF( NPROCS.LT.1 ) THEN
            CALL BLACS_SETUP( IAM, NPROCS )
         ENDIF
*
**
**        Temporarily define blacs grid to include all processes so
**        all processes have needed startup information
**
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*       Receive broadcast.
*
         DMACHEPS = PSLAMCH( ICTXT, 'Epsilon' )
         MACHEPS = REAL( DMACHEPS )
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, MACHEPS, 1, 0, 0 )
         DMACHEPS = REAL( MACHEPS )
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1, 0, 0 )
         DTHRESH = THRESH
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NMAT, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NNB, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NGRIDS, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, IVALUE, 1, 0, 0 )
         UPLO = CHAR( IVALUE )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, IVALUE, 1, 0, 0 )
         JOBZ = CHAR( IVALUE )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NMAT, NVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NNB, NBVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NGRIDS, PVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NGRIDS, QVAL, 1, 0, 0 )
      ENDIF
*
* Start of main loop.
*
      IF( IAM.EQ.0 ) THEN
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9994 )
         WRITE( NOUT, FMT = 9993 )
         WRITE( NOUT, FMT = * )
 9994    FORMAT( 1X,
     $' TIME     UPLO    JOBZ      N    NB    P   Q     PxHEEVX    PxHPE
     $VX  CHECK' )
 9993    FORMAT( 1X,
     $' ----     ----    ----      -    --    -   -     ------    ------
     $  -----' )
 9992    FORMAT( 1X, A4, 7X, A1, 1X, 7X, A1, 1X, I5, 1X, I5, 1X, I5, 1X,
     $         I5, F10.2, 1X, F10.2, 1X, A6 )
      ENDIF
      DO 240 I = 1, NGRIDS
         NPROW = PVAL( I )
         NPCOL = QVAL( I )
         IERR = 0
         IF( .NOT.( ( NPROW.GE.1 ) ) ) THEN
            IERR = 1
         ENDIF
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
         IF( IERR.GT.0 ) THEN
            IF( IAM.EQ.0 ) THEN
               WRITE( NOUT, FMT = 9986 )'nprow'
            ENDIF
            KSKIP = KSKIP + 1
            GOTO 240
         ENDIF
         IERR = 0
         IF( .NOT.( ( NPCOL.GE.1 ) ) ) THEN
            IERR = 1
         ENDIF
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
         IF( IERR.GT.0 ) THEN
            IF( IAM.EQ.0 ) THEN
               WRITE( NOUT, FMT = 9986 )'npcol'
            ENDIF
            KSKIP = KSKIP + 1
            GOTO 240
         ENDIF
*
*       define process grid.
*
         CALL BLACS_GRIDEXIT( ICTXT )
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', NPROW, NPCOL )
         CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
         MYPROW = MYROW
         MYPCOL = MYCOL
         IF( ( MYROW.GE.NPROW ) .OR. ( MYCOL.GE.NPCOL ) ) THEN
*
*               process grid does not use this processor.
*
            GOTO 240
         ENDIF
         DO 220 J = 1, NMAT
            N = NVAL( J )
            IERR = 0
            IF( .NOT.( N.GE.1 ) ) THEN
               IERR = 1
            ENDIF
            CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
            IF( IERR.GT.0 ) THEN
               IF( IAM.EQ.0 ) THEN
                  WRITE( NOUT, FMT = 9986 )'n'
               ENDIF
               KSKIP = KSKIP + 1
               GOTO 220
            ENDIF
            DO 200 K = 1, NNB
               NB = NBVAL( K )
               IERR = 0
               IF( .NOT.( NB.GE.1 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = 9986 )'nb'
                  ENDIF
                  KSKIP = KSKIP + 1
                  GOTO 200
               ENDIF
               KFAIL = 0
*
*               Initialize the array descriptor for the matrix A.
*
               RSRC = 0
               CSRC = 0
               NP = NUMROC( N, NB, MYROW, RSRC, NPROW )
               NQ = NUMROC( N, NB, MYCOL, CSRC, NPCOL )
               LDA = MAX( 1, NP )
               CALL DESCINIT( DESCA, N, N, NB, NB, RSRC, CSRC, ICTXT,
     $                        LDA, INFO )
               IERR = 0
               IF( .NOT.( INFO.EQ.0 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = 9986 )'descriptor'
                  ENDIF
                  KSKIP = KSKIP + 1
                  GOTO 200
               ENDIF
               CALL ICOPY( DLEN_, DESCA, 1, DESCAP, 1 )
*
*               allocate storage for matrix.
*
               IFREE = 1
               IPA = IFREE
               IFREE = IFREE + INFOMEM( DESCA )
               IPAP = IFREE
               IFREE = IFREE + INFOMEMT( UPLO, DESCAP )
               CALL ICOPY( DLEN_, DESCA, 1, DESCZ, 1 )
               CALL ICOPY( DLEN_, DESCZ, 1, DESCZP, 1 )
               IF( LSAME( JOBZ, 'V' ) ) THEN
*
*               Need eigenvectors as well.
*
                  IPZ = IFREE
                  IFREE = IFREE + INFOMEM( DESCZ )
                  IPZP = IFREE
                  IFREE = IFREE + INFOMEM( DESCZP )
               ELSE
                  IPZ = IFREE
                  IFREE = IFREE + 1
                  IPZP = IFREE
                  IFREE = IFREE + 1
               ENDIF
               IERR = 0
               IF( .NOT.( IFREE.LE.MEMSIZ ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = 9986 )'memsiz'
                  ENDIF
                  KSKIP = KSKIP + 1
                  GOTO 200
               ENDIF
*
*                  Initialize Z.
*
               ALPHA = ZERO
               BETA = ONE
               CALL PCLASET( 'All', N, N, ALPHA, BETA, MEM( IPZ ), 1, 1,
     $                       DESCZ )
               CALL PCLASET( 'All', N, N, ALPHA, BETA, MEM( IPZP ), 1,
     $                       1, DESCZP )
*
*       Generate matrices.
*
               IROFF = 0
               ICOFF = 0
               IRNUM = NUMROC( DESCA( M_ ), DESCA( MB_ ), MYROW,
     $                 DESCA( RSRC_ ), NPROW )
               ICNUM = NUMROC( DESCA( N_ ), DESCA( NB_ ), MYCOL,
     $                 DESCA( CSRC_ ), NPCOL )
               CALL PCMATGEN( ICTXT, 'Hermitian', 'DDominant',
     $                        DESCA( M_ ), DESCA( N_ ), DESCA( MB_ ),
     $                        DESCA( NB_ ), MEM( IPA ), DESCA( LLD_ ),
     $                        DESCA( RSRC_ ), DESCA( CSRC_ ), IASEED,
     $                        IROFF, IRNUM, ICOFF, ICNUM, MYROW, MYCOL,
     $                        NPROW, NPCOL )
               ANORM = PCLANHE( 'M', UPLO, N, MEM( IPA ), 1, 1, DESCA,
     $                 RWORK )
*
*               copy matrix into packed storage.
*
               CALL PCLACPT( UPLO, N, MEM( IPA ), 1, 1, DESCA,
     $                       MEM( IPAP ), 1, 1, DESCAP )
               ANORMP = PCLANHP( 'M', UPLO, N, MEM( IPAP ), 1, 1,
     $                  DESCAP, RWORK )
               CALL SLBOOT
               CALL BLACS_BARRIER( ICTXT, 'All' )
*
*               Perform computation.
*
               IPWORK = IFREE
               NFREE = MEMSIZ - IFREE + 1
               LWORK = NFREE
               CALL BLACS_BARRIER( ICTXT, 'All' )
               CALL SLTIMER( 1 )
               RANGE = 'All'
               VL = -ANORM
               VU = ANORM
               IL = 1
               IU = N
               ABSTOL = REAL( 0 )
               ORFAC = REAL( 1.0d-3 )
               CALL PCHEEVX( JOBZ, RANGE, UPLO, N, MEM( IPA ), 1, 1,
     $                       DESCA, VL, VU, IL, IU, ABSTOL, M, NZ,
     $                       W( 1 ), ORFAC, MEM( IPZ ), 1, 1, DESCZ,
     $                       MEM( IPWORK ), LWORK, RWORK, LRWORK, IWORK,
     $                       LIWORK, IFAIL, ICLUSTR, GAP, INFO )
               CALL SLTIMER( 1 )
               IERR = 0
               IF( .NOT.( INFO.EQ.0 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = * )'PxSYEVX info = ', INFO
                  ENDIF
                  KFAIL = KFAIL + 1
                  GOTO 190
               ENDIF
*
*               Perform computation for packed storage.
*
               IPWORK = IFREE
               NFREE = MEMSIZ - IFREE + 1
               LWORK = NFREE
               CALL BLACS_BARRIER( ICTXT, 'All' )
               CALL SLTIMER( 2 )
               RANGE = 'All'
               VL = -ANORM
               VU = ANORM
               IL = 1
               IU = N
               ABSTOL = REAL( 0 )
               ORFAC = REAL( 1.0d-3 )
               CALL PCHPEVX( JOBZ, RANGE, UPLO, N, MEM( IPAP ), 1, 1,
     $                       DESCAP, VL, VU, IL, IU, ABSTOL, M, NZ,
     $                       WP( 1 ), ORFAC, MEM( IPZP ), 1, 1, DESCZP,
     $                       MEM( IPWORK ), LWORK, RWORK, LRWORK, IWORK,
     $                       LIWORK, IFAIL, ICLUSTR, GAP, INFO )
               CALL SLTIMER( 2 )
               IERR = 0
               IF( .NOT.( INFO.EQ.0 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = * )'PxSPEVX info = ', INFO
                  ENDIF
                  KFAIL = KFAIL + 1
                  GOTO 190
               ENDIF
*
*                Check eigenvalues.
*
               EIGMAX = ABS( WP( 1 ) )
               DO 110 II = 1, N
                  EIGMAX = MAX( EIGMAX, ABS( WP( II ) ) )
                  EIGMAX = MAX( EIGMAX, ABS( W( II ) ) )
  110          CONTINUE
  120          CONTINUE
               ABSERR = 0
               RELERR = 0
               TOL = REAL( N )*DTHRESH*DMACHEPS
               DO 130 II = 1, N
                  ABSERR = MAX( ABSERR, ABS( W( II )-WP( II ) ) )
                  ABSW = ABS( W( II ) )
                  ABSWP = ABS( WP( II ) )
                  RELERR = MAX( RELERR, ABSERR / MAX( ABSW, ANORM ) )
                  IF( RELERR.GT.TOL ) THEN
                     KFAIL = KFAIL + 1
                     IF( IAM.EQ.0 ) THEN
                        WRITE( NOUT, FMT = 9991 )RELERR, II,
     $                     DTHRESH*DMACHEPS
 9991                   FORMAT( 1X, 'rel error ', 1P, E12.2, ' for ',
     $                        I5, '-th  eigenvalue ',
     $                        ' is greater than n*thresh*macheps ', 1P,
     $                        E12.2 )
                     ENDIF
                  ENDIF
  130          CONTINUE
  140          CONTINUE
* end do ii
               IF( IAM.EQ.0 ) THEN
                  WRITE( NOUT, FMT = 9990 )ABSERR, RELERR
 9990             FORMAT( 2X,
     $                  'largest absolute deviation in eigenvalues', 1X,
     $                  1P, E14.2, / 2X,
     $                  'largest relative deviation in eigenvalues', 1X,
     $                  1P, E14.2 )
               ENDIF
*
*            Find largest eigenvalue.
*
               IF( ( KFAIL.EQ.0 ) .AND. ( LSAME( JOBZ, 'V' ) ) ) THEN
*
*               Check eigenvectors by
*               computing || A*v - lambda*v ||/(epsilon*||A||)
*
                  DO 150 II = 1, N
*
*                  normalize eigenvectors
*
                     IPROC = INDXG2P( II, DESCZ( NB_ ), MYCOL,
     $                       DESCZ( CSRC_ ), NPCOL )
                     ISMYCOL = ( IPROC.EQ.MYCOL )
                     IF( ISMYCOL ) THEN
                        CALL PSCNRM2( N, DNORM2, MEM( IPZP ), 1, II,
     $                                DESCZP, 1 )
                        ALPHA = ONE / CMPLX( REAL( DNORM2 ) )
                        CALL PCSCAL( N, ALPHA, MEM( IPZP ), 1, II,
     $                               DESCZP, 1 )
                        CALL PSCNRM2( N, DNORM2, MEM( IPZ ), 1, II,
     $                                DESCZ, 1 )
                        ALPHA = ONE / CMPLX( REAL( DNORM2 ) )
                        CALL PCSCAL( N, ALPHA, MEM( IPZ ), 1, II, DESCZ,
     $                               1 )
                     ENDIF
  150             CONTINUE
  160             CONTINUE
                  CALL ICOPY( DLEN_, DESCAP, 1, DESCWORK, 1 )
                  DESCWORK( N_ ) = 1
                  IPWORK = IFREE
                  LWORK = INFOMEM( DESCWORK )
                  NFREE = MEMSIZ - IFREE + 1
                  IERR = 0
                  IF( .NOT.( NFREE.GE.LWORK ) ) THEN
                     IERR = 1
                  ENDIF
                  CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1,
     $                          -1 )
                  IF( IERR.GT.0 ) THEN
                     IF( IAM.EQ.0 ) THEN
                        WRITE( NOUT, FMT = 9986 )'memsiz'
                     ENDIF
                     KSKIP = KSKIP + 1
                     GOTO 200
                  ENDIF
                  ANORMP = EIGMAX
*
*                 Regenerate original matrix.
*
                  IROFF = 0
                  ICOFF = 0
                  IRNUM = NUMROC( DESCA( M_ ), DESCA( MB_ ), MYROW,
     $                    DESCA( RSRC_ ), NPROW )
                  ICNUM = NUMROC( DESCA( N_ ), DESCA( NB_ ), MYCOL,
     $                    DESCA( CSRC_ ), NPCOL )
                  CALL PCMATGEN( ICTXT, 'Hermitian', 'DDominant',
     $                           DESCA( M_ ), DESCA( N_ ), DESCA( MB_ ),
     $                           DESCA( NB_ ), MEM( IPA ),
     $                           DESCA( LLD_ ), DESCA( RSRC_ ),
     $                           DESCA( CSRC_ ), IASEED, IROFF, IRNUM,
     $                           ICOFF, ICNUM, MYROW, MYCOL, NPROW,
     $                           NPCOL )
                  DO 170 II = 1, N
                     CALL PCCOPY( N, MEM( IPZP ), 1, II, DESCZP, 1,
     $                            MEM( IPWORK ), 1, 1, DESCWORK, 1 )
                     ALPHA = ONE
                     BETA = -W( II )
                     CALL PCHEMV( UPLO, N, ALPHA, MEM( IPA ), 1, 1,
     $                            DESCA, MEM( IPZP ), 1, II, DESCZP, 1,
     $                            BETA, MEM( IPWORK ), 1, 1, DESCWORK,
     $                            1 )
                     DNORM2 = REAL( 0 )
                     CALL PSCNRM2( N, DNORM2, MEM( IPWORK ), 1, 1,
     $                             DESCWORK, 1 )
                     RA = -1
                     CA = -1
                     RCFLAG = -1
                     RDEST = -1
                     CDEST = -1
                     CALL SGAMX2D( DESCA( CTXT_ ), 'All', ' ', 1, 1,
     $                             DNORM2, 1, RA, CA, RCFLAG, RDEST,
     $                             CDEST )
                     RESID2 = DNORM2 / ( REAL( N )*DMACHEPS*ANORMP )
                     IF( RESID2.GT.DTHRESH ) THEN
                        KFAIL = KFAIL + 1
                        IF( IAM.EQ.0 ) THEN
                           WRITE( NOUT, FMT = 9989 )II, RESID2, THRESH
 9989                      FORMAT( 'Residual for ', I6,
     $                           'th eigenvector ', ' is ', 1P, E14.3,
     $                           ' which exceeds the ',
     $                           ' threshold of ', 1P, E14.3 )
                        ENDIF
                     ENDIF
  170             CONTINUE
  180             CONTINUE
* end do ii
               ENDIF
* end if jobz
*
**
**                    Gather maximum of all CPU and WALL clock timings
**
*
  190          CONTINUE
               IF( KFAIL.EQ.0 ) THEN
                  PASSED = 'PASSED'
               ELSE
                  PASSED = 'FAILED'
               ENDIF
               CALL SLCOMBINE( ICTXT, 'All', '>', 'Wall-clock', 2, 1,
     $                         WTIME )
               CALL SLCOMBINE( ICTXT, 'All', '>', 'Cpu-clock', 2, 1,
     $                         CTIME )
               IF( IAM.EQ.0 ) THEN
                  IF( ( WTIME( 1 )+WTIME( 2 ) ).GT.DBLE( 0 ) ) THEN
                     WRITE( NOUT, FMT = 9992 )'Wall ', UPLO, JOBZ, N,
     $                  NB, NPROW, NPCOL, WTIME( 1 ), WTIME( 2 ), PASSED
                  ENDIF
                  IF( ( CTIME( 1 )+CTIME( 2 ) ).GT.DBLE( 0 ) ) THEN
                     WRITE( NOUT, FMT = 9992 )'Cpu ', UPLO, JOBZ, N, NB,
     $                  NPROW, NPCOL, CTIME( 1 ), CTIME( 2 ), PASSED
                  ENDIF
               ENDIF
  200       CONTINUE
  210       CONTINUE
* end do k
  220    CONTINUE
  230    CONTINUE
* end do j
  240 CONTINUE
  250 CONTINUE
* end do i
*
*   All done.
*
      IF( IAM.EQ.0 ) THEN
         CLOSE ( NOUT )
      ENDIF
      CALL BLACS_GRIDEXIT( ICTXT )
      STOP '** all done ** '
  260 CONTINUE
      WRITE( NOUT, FMT = 9988 )
      CLOSE ( NIN )
      IF( ( NOUT.NE.0 ) .AND. ( NOUT.NE.6 ) ) THEN
         CLOSE ( NOUT )
      ENDIF
      CALL BLACS_ABORT( ICTXT, 1 )
      STOP '** stop with error ** '
 9988 FORMAT( ' Illegal input in file ', 40A, '.  Aborting run.' )
 9987 FORMAT( ' Number of values of ', 5A,
     $      ' is less than 1 or greater ', 'than ', I2 )
 9986 FORMAT( 'Bad ', A6, ' parameters: going on to next test case.' )
      END
