      INTEGER          FUNCTION INFOMEMT( UPLO, DESCA )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* infomem() returns the number of entries on the current processor
* that correspond to descriptor 'descA' in packed storage.
*
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, N_, NB_
      PARAMETER          ( CTXT_ = 2, N_ = 4, NB_ = 6 )
      INTEGER            CSRC_
      PARAMETER          ( CSRC_ = 8 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISMYCOL, ISUPPER
      INTEGER            IA, IIA, IPROC, JA, JJA, LOFFSET, MYPCOL,
     $                   MYPROW, NPCOL, NPROW, TOTMEM
*     ..
*     .. Local Arrays ..
      INTEGER            DESCNEW( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXG2P, INFOMEM
      EXTERNAL           LSAME, INDXG2P, INFOMEM
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCINITT, PXERBLA
*     ..
*     .. Executable Statements ..
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      IF( ( .NOT.ISLOWER ) .AND. ( .NOT.ISUPPER ) ) THEN
         CALL PXERBLA( DESCA( CTXT_ ), 'infomemt', 1 )
         INFOMEMT = ( -1 )
         RETURN
      ENDIF
*
* sum contributions from each block column.
*
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYPROW,
     $                     MYPCOL )
      TOTMEM = 0
      DO 10 JA = 1, DESCA( N_ ), DESCA( NB_ )
*
*    select diagonal entry.
*
         IPROC = INDXG2P( JA, DESCA( NB_ ), MYPCOL, DESCA( CSRC_ ),
     $           NPCOL )
         ISMYCOL = ( MYPCOL.EQ.IPROC )
         IF( ISMYCOL ) THEN
            IA = JA
            CALL DESCINITT( UPLO, IA, JA, DESCA, IIA, JJA, LOFFSET,
     $                      DESCNEW )
            TOTMEM = TOTMEM + INFOMEM( DESCNEW )
         ENDIF
   10 CONTINUE
   20 CONTINUE
      INFOMEMT = ( TOTMEM )
      RETURN
      END
