      INTEGER          FUNCTION INFOMEM( DESCA )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* infomem() returns the number of entries on the current processor
* that correspond to descriptor 'descA'.
*
*
*     .. Parameters ..
      INTEGER            CTXT_, M_, N_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_, LLD_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
*     ..
*     .. Local Scalars ..
      INTEGER            MYPCOL, MYPROW, NCOL, NPCOL, NPROW, NROW
*     ..
*     .. External Functions ..
      INTEGER            NUMROC
      EXTERNAL           NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO
*     ..
*     .. Executable Statements ..
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYPROW,
     $                     MYPCOL )
      NROW = NUMROC( DESCA( M_ ), DESCA( MB_ ), MYPROW, DESCA( RSRC_ ),
     $       NPROW )
      NCOL = NUMROC( DESCA( N_ ), DESCA( NB_ ), MYPCOL, DESCA( CSRC_ ),
     $       NPCOL )
      IF( ( NROW.EQ.0 ) .OR. ( NCOL.EQ.0 ) ) THEN
         INFOMEM = ( 0 )
         RETURN
      ELSE
         INFOMEM = ( DESCA( LLD_ )*NCOL )
         RETURN
      ENDIF
      END
