      SUBROUTINE INFOG2LT( UPLO, GRINDX, GCINDX, DESC, NPROW, NPCOL,
     $                     MYROW, MYCOL, LOFFSET, RSRC, CSRC )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*
*
*  Purpose
*  =======
*
*  INFOG2LT computes the starting local indexes LOFFSET corres-
*  ponding to the distributed submatrix starting globally at the entry
*  pointed by GRINDX, GCINDX. This routine returns the coordinates in
*  the grid of the process owning the matrix entry of global indexes
*  GRINDX, GCINDX, namely RSRC and CSRC.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          Specifies the part of the matrix A to be copied to B.
*          = 'U':      Upper triangular part
*          = 'L':      Lower triangular part
*          Otherwise:  All of the matrix A
*  GRINDX    (global input) INTEGER
*            The global row starting index of the submatrix.
*
*  GCINDX    (global input) INTEGER
*            The global column starting index of the submatrix.
*
*  DESC      (input) INTEGER array of dimension DLEN_.
*            The array descriptor for the underlying distributed matrix.
*
*  NPROW     (global input) INTEGER
*            The total number of process rows over which the distributed
*            matrix is distributed.
*
*  NPCOL     (global input) INTEGER
*            The total number of process columns over which the
*            distributed matrix is distributed.
*  MYROW     (local input) INTEGER
*            The row coordinate of the process calling this routine.
*
*  MYCOL     (local input) INTEGER
*            The column coordinate of the process calling this routine.
*
*  LOFFSET   (local output) INTEGER
*            The local starting index of the submatrix.
*
*  RSRC      (global output) INTEGER
*            The row coordinate of the process that possesses the first
*            row and column of the submatrix.
*
*  CSRC      (global output) INTEGER
*            The column coordinate of the process that possesses the
*            first row and column of the submatrix.
*
*
*     .. Parameters ..
      INTEGER            CTXT_, M_, N_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            CSRC, GCINDX, GRINDX, LOFFSET, MYCOL, MYROW,
     $                   NPCOL, NPROW, RSRC
*     ..
*     .. Array Arguments ..
      INTEGER            DESC( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            FOUND, ISBLKBNDRY, ISLOWER, ISSAMECOL, ISUPPER,
     $                   ISVALID
      INTEGER            IA, IAEND, IASTART, IDEBUG, IEND, IFIRST, IIA,
     $                   ISIZE, JA, JAEND, JASTART, JEND, JFIRST, JINC,
     $                   JINIT, JJA, JSIZE, JSTART, LOCP, LOCQ, M, MB,
     $                   MSIZE, N, NB, NNB, NSIZE
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXFIRST, INDXG2P, NUMROC2
      EXTERNAL           LSAME, INDXFIRST, INDXG2P, NUMROC2
*     ..
*     .. External Subroutines ..
      EXTERNAL           INFOT, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
      IDEBUG = 1
      IA = GRINDX
      JA = GCINDX
      MB = DESC( MB_ )
      NB = DESC( NB_ )
      M = DESC( M_ )
      N = DESC( N_ )
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISVALID = ( ISLOWER .OR. ISUPPER )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'infog2lT', 1 )
         RETURN
      ENDIF
      ISVALID = ( 1.LE.IA ) .AND. ( IA.LE.DESC( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'infog2lT', 2 )
         RETURN
      ENDIF
      ISVALID = ( 1.LE.JA ) .AND. ( JA.LE.DESC( N_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'infog2lT', 3 )
         RETURN
      ENDIF
      LOFFSET = 0
*
*       Determine the processor that owns this entry (rsrc,csrc)
*
      RSRC = INDXG2P( IA, MB, MYROW, DESC( RSRC_ ), NPROW )
      CSRC = INDXG2P( JA, NB, MYCOL, DESC( CSRC_ ), NPCOL )
      CALL INFOT( UPLO, IA, JA, DESC, IASTART, JASTART, IAEND, JAEND )
*
*    Determine first column that belongs to (rsrc,csrc)
*
      JINIT = INDXFIRST( N, 1, NB, CSRC, DESC( CSRC_ ), NPCOL )
      FOUND = ( 1.LE.JINIT ) .AND. ( JINIT.LE.N )
      IF( IDEBUG.GE.2 ) THEN
         WRITE( *, FMT = * )'found,jinit, jastart,jaend, ia,ja ', FOUND,
     $      JINIT, JASTART, JAEND, IA, JA
      ENDIF
      IF( FOUND ) THEN
         ISBLKBNDRY = ( MOD( JINIT-1, NB ).EQ.0 )
         ISSAMECOL = ( CSRC.EQ.INDXG2P( JINIT, NB, MYCOL, DESC( CSRC_ ),
     $               NPCOL ) )
         LOFFSET = 0
         JINC = NPCOL*NB
         DO 10 JSTART = JINIT, JA, JINC
*
*         Use diagonal entry, valid for both upper and lower part.
*
            IIA = JSTART
            JJA = JSTART
            NNB = NB
            JFIRST = JJA - MOD( NNB+JJA-1, NNB )
            JEND = MIN( N, JFIRST+( NNB-1 ) )
            IF( ISLOWER ) THEN
               IFIRST = MIN( JFIRST, M )
               IEND = M
            ELSE
               IFIRST = 1
               IEND = MIN( JEND, M )
            ENDIF
            ISVALID = ( IFIRST.LE.IIA ) .AND. ( IIA.LE.IEND )
            ISVALID = ( JFIRST.LE.JJA ) .AND. ( JJA.LE.JEND )
            MSIZE = IEND - IFIRST + 1
            NSIZE = JEND - JFIRST + 1
            LOCP = NUMROC2( MSIZE, IFIRST, MB, RSRC, DESC( RSRC_ ),
     $             NPROW )
            LOCQ = NUMROC2( NSIZE, JFIRST, NB, CSRC, DESC( CSRC_ ),
     $             NPCOL )
            IF( JEND.LT.JA ) THEN
*
*            Take the whole slab.
*
               LOFFSET = LOFFSET + LOCP*LOCQ
            ELSE
               ISVALID = ( JFIRST.LE.JA ) .AND. ( JA.LE.JEND )
               ISIZE = NUMROC2( IA-IFIRST+1, IFIRST, MB, RSRC,
     $                 DESC( RSRC_ ), NPROW )
               JSIZE = NUMROC2( ( JA-1 )-JFIRST+1, JFIRST, NB, CSRC,
     $                 DESC( CSRC_ ), NPCOL )
               LOFFSET = LOFFSET + LOCP*JSIZE + ( ISIZE-1 )
            ENDIF
            IF( IDEBUG.GE.2 ) THEN
               WRITE( *, FMT = * )'jstart ', JSTART
               WRITE( *, FMT = * )'ifirst,jfirst,iend,jend ', IFIRST,
     $            JFIRST, IEND, JEND
               WRITE( *, FMT = * )'Locp,Locq,loffset ', LOCP, LOCQ,
     $            LOFFSET
            ENDIF
   10    CONTINUE
   20    CONTINUE
* end loop
      ENDIF
      LOFFSET = LOFFSET + 1
      RETURN
      END
