      INTEGER          FUNCTION INDXLAST( N, IA, NB, IPROC, ISRCPROC,
     $                 NPROCS )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*  Purpose
*  =======
*
*  INDXlast  computes the last index in ia:(ia+n-1) that
*  is on processor iproc.
*
*  returns ia -1 if not found
*
*
*     .. Scalar Arguments ..
      INTEGER            IA, IPROC, ISRCPROC, N, NB, NPROCS
*     ..
*     .. Local Scalars ..
      LOGICAL            FOUND
      INTEGER            GIDX, ILAST
*     ..
*     .. External Functions ..
      INTEGER            INDXG2P
      EXTERNAL           INDXG2P
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
*        The answer is either ia +n-1 or at end of a block boundary.
*
      FOUND = .false.
      ILAST = IA - 1
      GIDX = IA + N - 1
   10 CONTINUE
      IF( GIDX.GE.IA ) THEN
         FOUND = ( IPROC.EQ.INDXG2P( GIDX, NB, IPROC, ISRCPROC,
     $           NPROCS ) )
         IF( FOUND ) THEN
            ILAST = GIDX
            GOTO 20
         ENDIF
         GIDX = ( GIDX-MOD( GIDX-1, NB ) ) - 1
         GOTO 10
      ENDIF
   20 CONTINUE
      IF( .NOT.FOUND ) THEN
         ILAST = IA - 1
      ENDIF
      INDXLAST = ( ILAST )
      RETURN
      END
