      SUBROUTINE DESCINITT( UPLO, IA, JA, DESC, IIA, JJA, LOFFSET,
     $                      DESCNEW )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*  Purpose
*  =======
*
*  Auxiliary routine to manipulate packed storage.
*
*  Give global indices (ia,ja) and descriptor for full matrix
*  generate a new (fake) descriptor and new global indices (iia,jja)
*  and offset for COLUMN operations on calls to PBLAS or other
*  SCALAPACK  dense matrix routines.
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, M_, N_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IIA, JA, JJA, LOFFSET
*     ..
*     .. Array Arguments ..
      INTEGER            DESC( DLEN_ ), DESCNEW( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            HASOVERLAP, ISLOWER, ISUPPER, ISVALID
      INTEGER            COLSTART, CSRC, IEND, IFIRST, INFO, JEND,
     $                   JFIRST, LLD, LOCP, LOCQ, M, MB, MM, MYCOL,
     $                   MYIFIRST, MYJFIRST, MYROW, N, NB, NN, NPCOL,
     $                   NPROW, P0, Q0, ROWSTART, RSRC
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXFIRST, NUMROC2
      EXTERNAL           LSAME, INDXFIRST, NUMROC2
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, INFOG2LT, INFOT,
     $                   PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MOD
*     ..
*     .. Executable Statements ..
      CALL BLACS_GRIDINFO( DESC( CTXT_ ), NPROW, NPCOL, MYROW, MYCOL )
      MB = DESC( MB_ )
      NB = DESC( NB_ )
      M = DESC( M_ )
      N = DESC( N_ )
      ISUPPER = LSAME( UPLO, 'U' )
      ISLOWER = LSAME( UPLO, 'L' )
      ISVALID = ( ISLOWER .OR. ISUPPER )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'descinitt', 1 )
         RETURN
      ENDIF
      ISVALID = ( 1.LE.IA ) .AND. ( IA.LE.DESC( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'descinitt', 2 )
         RETURN
      ENDIF
      ISVALID = ( 1.LE.JA ) .AND. ( JA.LE.DESC( N_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'descinitt', 3 )
         RETURN
      ENDIF
      ISVALID = ( ISLOWER .AND. ( IA.GE.JA ) ) .OR.
     $          ( ISUPPER .AND. ( JA.GE.IA ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( DESC( CTXT_ ), 'descinitt', 2 )
         RETURN
      ENDIF
      CALL INFOT( UPLO, IA, JA, DESC, IFIRST, JFIRST, IEND, JEND )
      IIA = IA - IFIRST + 1
      JJA = JA - JFIRST + 1
      MM = IEND - IFIRST + 1
      NN = JEND - JFIRST + 1
      LOCQ = NUMROC2( NN, JFIRST, NB, MYCOL, DESC( CSRC_ ), NPCOL )
      LOCP = NUMROC2( MM, IFIRST, MB, MYROW, DESC( RSRC_ ), NPROW )
      LLD = MAX( 1, LOCP )
      ROWSTART = MOD( DESC( RSRC_ )+( IFIRST-1 ) / MB, NPROW )
      COLSTART = MOD( DESC( CSRC_ )+( JFIRST-1 ) / NB, NPCOL )
      INFO = 0
      CALL DESCSET( DESCNEW, MM, NN, MB, NB, ROWSTART, COLSTART,
     $              DESC( CTXT_ ), LLD )
      HASOVERLAP = ( LOCP.GE.1 ) .AND. ( LOCQ.GE.1 )
      IF( HASOVERLAP ) THEN
         P0 = DESC( RSRC_ )
         Q0 = DESC( CSRC_ )
         MYIFIRST = INDXFIRST( MM, IFIRST, MB, MYROW, P0, NPROW )
         MYJFIRST = INDXFIRST( NN, JFIRST, NB, MYCOL, Q0, NPCOL )
         ISVALID = ( IFIRST.LE.MYIFIRST ) .AND.
     $             ( MYIFIRST.LE.IFIRST+MM-1 )
         ISVALID = ( JFIRST.LE.MYJFIRST ) .AND.
     $             ( MYJFIRST.LE.JFIRST+NN-1 )
         CALL INFOG2LT( UPLO, MYIFIRST, MYJFIRST, DESC, NPROW, NPCOL,
     $                  MYROW, MYCOL, LOFFSET, RSRC, CSRC )
         ISVALID = ( RSRC.EQ.MYROW )
         ISVALID = ( CSRC.EQ.MYCOL )
         ISVALID = ( LOFFSET.GE.1 )
      ELSE
*
*                I don't own anything in this block column,
*                set loffset to 1 to be extra safe.
*
         LOFFSET = 1
      ENDIF
      RETURN
      END
