#################################
#
# double precision
#
####################################
PDB_COBJS = \
	pdsprk_.o \
	pdspr2k_.o \
	pdspmv_.o \
	pdtpmm_.o \
	

PDB_FOBJS = \
	pdsprkf.o \
	pdspr2kf.o \
	pdtpsm.o \
	pdspmvf.o \
	pdtpmmf.o \


PD_COBJS = \
	pdpptrf_.o  \
	pdlamvt_.o \

PD_FOBJS = \
	pdspev.o \
	pdspevx.o \
	pdopmtr.o \
	pdopmqr.o pdopmql.o \
	pdsptrd.o \
	pdpptrs.o \
	pdpptrff.o  \
	pdlacpt.o \
	pdlacpt2.o \
	pdlacpt3.o \
	pdlansp.o \
	pdlascalet.o \
	pdlasclt.o \
	pdlasett.o \
	pdmatgen.o pdbmatgen.o \
	pdlaschk.o \
	pdelgett.o \
	pdelsett.o \
	pdlatrdt.o \
	pdlamvtf.o \
	pdlamvt2.o \
	pdorm2l.o \
	pdspgvx.o \
	pdspgst.o \



PD_OBJS = \
	$(PD_COBJS) $(PD_FOBJS) \
	$(PDB_COBJS) $(PDB_FOBJS) \

####################################
#
# single precision
#
####################################
PSB_COBJS = \
	psspmv_.o \
	pssprk_.o \
	psspr2k_.o \
	pstpmm_.o \

PSB_FOBJS = \
	psspmvf.o \
	pssprkf.o \
	psspr2kf.o \
	pstpsm.o \
	pstpmmf.o \

PS_COBJS = \
	pspptrf_.o \
	pslamvt_.o \

PS_FOBJS = \
	psspev.o \
	psspevx.o \
	psopmtr.o \
	psopmqr.o psopmql.o \
	pssptrd.o \
	pspptrs.o  \
	pspptrff.o \
	pslacpt.o \
	pslacpt2.o \
	pslacpt3.o \
	pslansp.o \
	pslascalet.o \
	pslasclt.o \
	pslasett.o \
	psmatgen.o psbmatgen.o \
	pslaschk.o \
	pselgett.o \
	pselsett.o \
	pslatrdt.o \
	pslamvtf.o \
	pslamvt2.o \
	psorm2l.o \
	psspgvx.o \
	psspgst.o \



PDT_FOBJS = \
	psppdriver.o \

PS_OBJS = \
	$(PS_COBJS) $(PS_FOBJS) \
	$(PSB_COBJS) $(PSB_FOBJS) \

####################################
#
# complex precision
#
####################################
PC_COBJS = \
	pcpptrf_.o \
	pclamvt_.o \

PC_FOBJS = \
	pclaschk.o \
	pchptrd.o \
	pcpptrs.o \
	pcpptrff.o \
	pclacpt.o \
	pclacpt2.o \
	pclacpt3.o \
	pclanhp.o \
	pclascalet.o \
	pclasclt.o \
	pclasett.o \
	pcmatgen.o pcbmatgen.o \
	pcelgett.o \
	pcelsett.o \
	pclatrdt.o \
	pclamvtf.o \
	pclamvt2.o \
	pchpevx.o \
	pcupmtr.o \
	pcupmqr.o \
	pcupmql.o \
	pcunm2l.o \
	pchpgvx.o \
	pchpgst.o \
	pcheev.o \
	pchpev.o \
	csteqr2.o \



PCB_COBJS = \
	pchpmv_.o \
	pchprk_.o \
	pchpr2k_.o \
	pctpmm_.o \

PCB_FOBJS = \
	pchpmvf.o \
	pchprkf.o \
	pchpr2kf.o \
	pctpsm.o \
	pctpmmf.o \
	



PC_OBJS = \
	$(PC_COBJS) $(PC_FOBJS) \
	$(PCB_COBJS) $(PCB_FOBJS)

####################################
#
# double complex precision
#
####################################
PZ_COBJS = \
	pzpptrf_.o \
	pzlamvt_.o \

PZ_FOBJS = \
	pzlaschk.o \
	pzhptrd.o \
	pzpptrs.o \
	pzpptrff.o \
	pzlacpt.o \
	pzlacpt2.o \
	pzlacpt3.o \
	pzlanhp.o \
	pzlascalet.o \
	pzlasclt.o \
	pzlasett.o \
	pzmatgen.o pzbmatgen.o \
	pzelgett.o \
	pzelsett.o \
	pzlatrdt.o \
	pzlamvtf.o \
	pzlamvt2.o \
	pzhpevx.o \
	pzupmtr.o \
	pzupmqr.o \
	pzupmql.o \
	pzunm2l.o \
	pzhpgvx.o \
	pzhpgst.o \
	pzheev.o \
	pzhpev.o \
	zsteqr2.o \



PZB_COBJS = \
	pzhpmv_.o \
	pzhprk_.o \
	pzhpr2k_.o \
	pztpmm_.o \

PZB_FOBJS = \
	pzhpmvf.o \
	pzhprkf.o \
	pzhpr2kf.o \
	pztpsm.o \
	pztpmmf.o \


PZ_OBJS = \
	$(PZ_COBJS) $(PZ_FOBJS) \
	$(PZB_COBJS) $(PZB_FOBJS)

####################################
#
# Auxiliary helper
#
####################################
AUX_COBJS = \

AUX_FOBJS = \
	descinitt.o \
	infog2lt.o \
	numroc2.o \
	indxfirst.o \
	indxlast.o \
	infot.o \
	infomem.o \
	infomemt.o \
	pmatgeninc.o \
	

DEBUG_FOBJS = \
	assert.o \
	profinit.o \
	pfclaprnt2.o   \
	pclaprntt.o \
	pfdlaprnt2.o   \
	pdlaprnt.o \
	pdlaprntt.o \



AUX_OBJS = \
	$(AUX_COBJS) \
	$(AUX_FOBJS) \


####################################
#
# source files
#
####################################

PD_CSRC = $(PD_COBJS:.o=.c)
PD_FSRC = $(PD_FOBJS:.o=.f)
PDB_CSRC = $(PDB_COBJS:.o=.c)
PDB_FSRC = $(PDB_FOBJS:.o=.f)
PDT_FSRC = $(PDT_FOBJS:.o=.f)
PD_SRC = $(PD_CSRC) $(PD_FSRC) $(PDB_CSRC) $(PDB_FSRC) 


PS_CSRC = $(PS_COBJS:.o=.c)
PS_FSRC = $(PS_FOBJS:.o=.f)
PSB_CSRC = $(PSB_COBJS:.o=.c)
PSB_FSRC = $(PSB_FOBJS:.o=.f)
PDT_FSRC = $(PDT_FOBJS:.o=.f)
PS_SRC = $(PS_CSRC) $(PS_FSRC) $(PSB_CSRC) $(PSB_FSRC) 

PC_CSRC = $(PC_COBJS:.o=.c)
PC_FSRC = $(PC_FOBJS:.o=.f)
PCB_CSRC = $(PCB_COBJS:.o=.c)
PCB_FSRC = $(PCB_FOBJS:.o=.f)
PC_SRC = $(PC_CSRC) $(PC_FSRC) $(PCB_CSRC) $(PCB_FSRC)

PZ_CSRC = $(PZ_COBJS:.o=.c)
PZ_FSRC = $(PZ_FOBJS:.o=.f)
PZB_CSRC = $(PZB_COBJS:.o=.c)
PZB_FSRC = $(PZB_FOBJS:.o=.f)
PZ_SRC = $(PZ_CSRC) $(PZ_FSRC) $(PZB_CSRC) $(PZB_FSRC)

AUX_FSRC=$(AUX_FOBJS:.o=.f)
AUX_CSRC= $(AUX_COBJS:.o=.c)

AUX_SRC = \
	$(AUX_FSRC) \
	$(AUX_CSRC) 


ALL_CSRC = \
	$(AUX_CSRC) \
	$(PZ_CSRC) $(PZB_CSRC) \
	$(PC_CSRC) $(PCB_CSRC) \
	$(PD_CSRC) $(PDB_CSRC) \
	$(PS_CSRC) $(PSB_CSRC) \


DRIVER_FOBJS = \
	pdppdriver.o \
	psppdriver.o \
	pcppdriver.o \
	pzppdriver.o \
	\
	pdspevdriver.o \
	psspevdriver.o \
	pchpevdriver.o \
	pzhpevdriver.o \
	\
	pdspevxdriver.o \
	psspevxdriver.o \
	pchpevxdriver.o \
	pzhpevxdriver.o \
	\
	pzhpgvxdriver.o \
	pchpgvxdriver.o \
	pdspgvxdriver.o \
	psspgvxdriver.o \



DRIVER_FSRC=$(DRIVER_FOBJS:.o=.f)

ALL_FSRC= \
	$(AUX_FSRC) \
	$(PZ_FSRC) $(PZB_FSRC) \
	$(PC_FSRC) $(PCB_FSRC) \
	$(PD_FSRC) $(PDB_FSRC) \
	$(PS_FSRC) $(PSB_FSRC) \
	$(DRIVER_FSRC)



single:  $(AUX_OBJS) $(PS_OBJS)
	$(ARCH) $(ARCHFLAGS) \
		libpack.a \
		$(AUX_OBJS) $(PS_OBJS)
	$(RANLIB) libpack.a

double:  $(AUX_OBJS) $(PD_OBJS)
	$(ARCH) $(ARCHFLAGS) \
		libpack.a \
		$(AUX_OBJS) $(PD_OBJS)
	$(RANLIB) libpack.a

complex:  $(AUX_OBJS) $(PC_OBJS)
	$(ARCH) $(ARCHFLAGS) \
		libpack.a \
		$(AUX_OBJS) $(PC_OBJS)
	$(RANLIB) libpack.a

zcomplex:  $(AUX_OBJS) $(PZ_OBJS)
	$(ARCH) $(ARCHFLAGS) \
		libpack.a \
		$(AUX_OBJS) $(PZ_OBJS)
	$(RANLIB) libpack.a


all: $(AUX_OBJS) $(PS_OBJS) $(PD_OBJS) $(PC_OBJS) $(PZ_OBJS)
	$(ARCH) $(ARCHFLAGS)   \
		libpack.a \
		$(AUX_OBJS) $(PS_OBJS) $(PD_OBJS) $(PC_OBJS) $(PZ_OBJS)
	$(RANLIB) libpack.a



pzppdriver: pzppdriver.o libpack.a
	$(F77) -o pzppdriver $(FFLAGS) pzppdriver.o \
		libpack.a \
		$(LIBS)


pcppdriver: pcppdriver.o libpack.a
	$(F77) -o pcppdriver $(FFLAGS) pcppdriver.o \
		libpack.a \
		$(LIBS)

pdppdriver: pdppdriver.o libpack.a 
	$(F77)  -o pdppdriver $(FFLAGS) pdppdriver.o \
		libpack.a \
		$(LIBS)

psppdriver: psppdriver.o libpack.a
	$(F77) -o psppdriver $(FFLAGS) psppdriver.o \
		libpack.a \
		$(LIBS)

pdspevdriver: pdspevdriver.o libpack.a
	$(F77) -o pdspevdriver \
		pdspevdriver.o \
		libpack.a \
		$(LIBS)

psspevdriver: psspevdriver.o libpack.a
	$(F77) -o psspevdriver \
		psspevdriver.o \
		libpack.a \
		$(LIBS)

pchpevdriver: pchpevdriver.o libpack.a
	$(F77) -o pchpevdriver \
		pchpevdriver.o \
		libpack.a \
		$(LIBS)

pzhpevdriver: pzhpevdriver.o libpack.a
	$(F77) -o pzhpevdriver \
		pzhpevdriver.o \
		libpack.a \
		$(LIBS)



pdspevxdriver: pdspevxdriver.o pdorm2l.o libpack.a
	$(F77) -o pdspevxdriver \
		pdspevxdriver.o \
		pdorm2l.o \
		libpack.a \
		$(LIBS)

psspevxdriver: psspevxdriver.o psorm2l.o libpack.a
	$(F77) -o psspevxdriver \
		psspevxdriver.o \
		psorm2l.o \
		libpack.a \
		$(LIBS)


pchpevxdriver: pchpevxdriver.o pcunm2l.o libpack.a
	$(F77) -o pchpevxdriver \
		pchpevxdriver.o \
		pcunm2l.o \
		libpack.a \
		$(LIBS)

pzhpevxdriver: pzhpevxdriver.o pzunm2l.o libpack.a
	$(F77) -o pzhpevxdriver \
		pzhpevxdriver.o \
		pzunm2l.o \
		libpack.a \
		$(LIBS)


pzhpgvxdriver: pzhpgvxdriver.o pzunm2l.o libpack.a
	$(F77)  -o pzhpgvxdriver \
		pzhpgvxdriver.o \
		pzunm2l.o \
		libpack.a \
		$(LIBS)

pchpgvxdriver: pchpgvxdriver.o pzunm2l.o libpack.a
	$(F77)  -o pchpgvxdriver \
		pchpgvxdriver.o \
		pzunm2l.o \
		libpack.a \
		$(LIBS)

pdspgvxdriver: pdspgvxdriver.o pzunm2l.o libpack.a
	$(F77)  -o pdspgvxdriver \
		pdspgvxdriver.o \
		pzunm2l.o \
		libpack.a \
		$(LIBS)




psspgvxdriver: psspgvxdriver.o pzunm2l.o libpack.a
	$(F77)  -o psspgvxdriver \
		psspgvxdriver.o \
		pzunm2l.o \
		libpack.a \
		$(LIBS)



