#undef __FUNC__
#define __FUNC__ "PCColourProcessors"
int PCColourProcessors(VecPipeline ctx,PetscObject pipe_info)
{
  Pipeline_coloured_info *comm_info = (Pipeline_coloured_info *) pipe_info;
  VecPipeline_MPI_General *to = (VecPipeline_MPI_General *) ctx->todata;
  VecPipeline_MPI_General *from = (VecPipeline_MPI_General *) ctx->fromdata;
  int *comm_matrix,*comm_contribution,*my_row,*test_colours;
  int i,col,ierr, len = comm_info->numtids;

  /* allocate permanent space for colours */
  comm_info->proc_colours = (int *) PetscMalloc( len*sizeof(int) );
  CHKPTRQ(comm_info->proc_colours);
  PetscMemzero(comm_info->proc_colours,len*sizeof(int));

  /* allocate temporary space for connectivity matrix */
  comm_matrix = (int *) PetscMalloc( len*len*sizeof(int) );
  CHKPTRQ(comm_matrix);
  PetscMemzero(comm_matrix,len*len*sizeof(int));
  comm_contribution = (int *) PetscMalloc( len*len*sizeof(int) );
  CHKPTRQ(comm_contribution);
  PetscMemzero(comm_contribution,len*len*sizeof(int));
  test_colours = (int *) PetscMalloc( len*sizeof(int) );
  CHKPTRQ(test_colours);

  /* fill in my row of the connectivity matrix */
  my_row = comm_contribution +comm_info->mytid*len;
  for (i=0; i<to->n; i++) my_row[to->procs[i]] = 1;
  for (i=0; i<from->n; i++) my_row[from->procs[i]] = 1;

  /* construct the full matrix */
  ierr = MPI_Allreduce
    (comm_contribution,comm_matrix,len*len,MPI_INT,MPI_MAX,ctx->comm);
  CHKERRQ(ierr);
printf("comm matrix:");
for (i=0; i<len*len; i++) printf("%d ",comm_matrix[i]);
printf("\n");

  /* simply greedy colouring */
  my_row = comm_matrix;
  for (i=0; i<len; i++) {
    PetscMemzero(test_colours,len*sizeof(int));
    for (col=0; col<i; col++) {
      if (i==col) continue;
      if (my_row[col]==1)
	test_colours[comm_info->proc_colours[col]]=1;
    }
    for (col=0; col<len; col++) {
      if (test_colours[col]==0) {
	comm_info->proc_colours[i] = col;
	break;
      }
    }
    my_row += len;
  }
/*
  printf("Processors coloured as: ");
  for (col=0; col<len; col++)
    printf("%d->%d ",col,comm_info->proc_colours[col]);
  printf("\n");
*/
  PetscFree(comm_matrix); PetscFree(comm_contribution); PetscFree(test_colours);
  return 0;
}

