#include "parpre_pc.h"
#include "./ml_head.h"

int ViewIndices(MC_OneLevel_struct *level,Viewer viewer)
{
  int ierr;

  PetscPrintf(level->comm,"First block of indices of level %d:\n",level->level);
  ierr = ISView(level->indices1,viewer); CHKERRQ(ierr);
  if ((int) level->next_level) {
    ierr = ViewIndices(level->next_level,viewer); CHKERRQ(ierr);
  } else {
    PetscPrintf(level->comm,"Indices of deepest level:\n");
    ierr = ISView(level->indices2,viewer); CHKERRQ(ierr);
  }

  return 0;
}

#undef __FUNC__
#define __FUNC__ "ViewLevel"
int ViewLevel(MC_OneLevel_struct *level,Viewer viewer)
{
  ViewerType vtype;
  PetscTruth flg; int i,ierr;

  PetscFunctionBegin;

  ierr = ViewerGetType(viewer,&vtype);CHKERRQ(ierr);
  ierr = PetscTypeCompare((PetscObject)vtype,ASCII_VIEWER,&flg); CHKERRQ(ierr);
  if (flg) {
    ViewerASCIIPrintf(viewer,"== Level %d ==\n",level->level);
    ViewerASCIIPushTab(viewer);
    ViewerASCIIPrintf(viewer,"A11 solver\n");
    ViewerASCIIPushTab(viewer);
    ierr = SLESView(level->a11_solve,viewer); CHKERRQ(ierr);
    ViewerASCIIPopTab(viewer);
    if (level->pre_smooth) {
      ViewerASCIIPrintf(viewer,"Pre smoother\n");
      ViewerASCIIPushTab(viewer);
      ierr = SLESView(level->pre_smooth,viewer);
      ViewerASCIIPopTab(viewer);
    }
    if (level->post_smooth) {
      ViewerASCIIPrintf(viewer,"Post smoother\n");
      ViewerASCIIPushTab(viewer);
      ierr = SLESView(level->post_smooth,viewer);
      ViewerASCIIPopTab(viewer);
    }
    
    if (level->degree>1) {
      ViewerASCIIPrintf
	(viewer,"Generalised W-cycle degree %d;\n coefficients:",
	 level->degree);
      for (i=0; i<=level->degree; i++)
	ViewerASCIIPrintf(viewer," %e",-level->coffs[i]);
      ViewerASCIIPrintf(viewer,"\n");
    } else ViewerASCIIPrintf(viewer,"V-cycle\n");

    if (level->next_level) {
      ierr = ViewLevel(level->next_level,viewer); CHKERRQ(ierr);
    } else {
      ViewerASCIIPrintf(viewer,"== Last level ==\n");
      ierr = SLESView(level->a22_solve,viewer); CHKERRQ(ierr);
    }
    ViewerASCIIPopTab(viewer);
  } else SETERRQ(1,1,"Only ascii viewing implemented for mlevel\n");

  PetscFunctionReturn(0);
}
