#include "petscis.h"
#include "petscmat.h"
#include "petscsles.h"
#include "parpre_pc.h"
#include "./ml_impl.h"

/* from colouring */
extern int SplitOffOneLevel
(Mat mat,Vec u,Vec v,int level,
 IS *set1,IS *set2,int *global_r,int *zero_return,
 int orth,int isize,int jsize);
extern int SetFandCsets(MPI_Comm comm,int lvl,int trace,
			IS ind,IS rest,IS *set1,IS *set2,
			AMLCoarseGridChoice grid_choice,int all_zero);

/* from strong */
extern int MakeStrongMatrix
(Mat mat,int modification,double weight,
 Vec u,Vec v,Mat *strong_matrix,int trace);

/* from split */
extern int PartitionMatrix
(Mat mat,Vec u,Vec v,int level,AMLCoarseGridChoice grid_choice,
 Vec *g1,Vec *u1,Vec *h1,Vec *v1,Vec *k1,Vec *w1,
 Vec *g2,Vec *u2,Vec *h2,Vec *v2,Vec *k2,Vec *w2,
 VecScatter *get_clr,VecScatter *put_clr,
 VecScatter *get_rest,VecScatter *put_rest,
 Vec diag,Vec *cdiag,Vec *cdiag1,
 IS indices,IS *indices1,IS *indices2,IS *g_indices2,
 Mat *g12,Mat *a12,Mat *g21,Mat *a21,
 Mat *l21,Mat *g11,Mat *g22,
 int trace,int make_strong,double weight,
 int cutoff,int *stop_now,int *back_track,
 int orth,int isize,int jsize);

/* from fill */
extern int NextLevelFill
(MPI_Comm comm,int level,
 AMLCoarseGridChoice grid_choice,AMLSchurChoice schur_choice,
 Mat g21,Mat l21,Mat a21,Mat *b12,
 IS indices1,IS indices2,IS g_indices2,
 SLES a11_solve,Mat g11,Vec cdiag1,
 Mat g12,Mat a12,Mat g22,
 Vec g1,Vec h1,Vec k1,Vec g2,Vec h2,Vec k2,
 Vec u1,Vec v1,Vec w1,Vec u2,int mod,int trace,double weight,Mat *fill);
extern int NextMatFill
(MPI_Comm comm,AMLFillMethod fill_method,
 int modification,int repair,int trace,double weight,
 Mat fill,Mat orig,Vec d1,Vec d2,Mat *res_mat);

/* from solve */
extern int SolveMultiLevel
(MC_OneLevel_struct*this_level,Vec x,Vec y,int trace);

/* from utils */
extern int ViewLevel(MC_OneLevel_struct *level,Viewer viewer);
extern int ViewIndices(MC_OneLevel_struct *level,Viewer viewer);
