#include "mpi.h"
#include "petscvec.h"
#include "petscis.h"
#include "petscmat.h"
#include "src/mat/matimpl.h"
#include "petscpc.h"
#include "src/sles/pc/pcimpl.h"
#include "src/vec/impls/mpi/pvecimpl.h"
#include "src/sles/slesimpl.h"
#include "petscoptions.h"

#include "parpre_pc.h"
#include "parpre_pipeline.h"
#include "parpre_subdomains.h"
#include "parpre_is.h"
#include "./ml_impl.h"
#include "./ml_head.h"

int ViewIndices(MC_OneLevel_struct *level,Viewer viewer)
{
  int ierr;

  if ((int) level) {
    PetscPrintf(level->comm,"Indices of level %d:\n",level->level);
    IsView(level->indices,viewer);
    ierr = ViewIndices(level->next_level,viewer); CHKERRQ(ierr);
  }

  return 0;
}

