#include "petscmat.h"
#include "petscviewer.h"
#include "mpi.h"

int MatFileDump(Mat mat,char *name,int num)
{
  MPI_Comm comm;
  Viewer viewer;
  char full_name[25];
  int ierr;

  PetscFunctionBegin;
  ierr = PetscObjectGetComm((PetscObject)mat,&comm); CHKERRQ(ierr);
  sprintf(full_name,"%s%d",name,num);
  ierr = ViewerASCIIOpen(comm,full_name,&viewer); CHKERRQ(ierr);
  ierr = MatView(mat,viewer);
  PetscFunctionReturn(0);

}
