#include "vec.h"
#include "mat.h"
#include "options.h"
#include "stdio.h"
#include "./make_mat.h"

static double coplx(int i,int j,int m,int n,int problem)
{
  Scalar v = 1.0;
  if (problem==1) {
    if (i>m/2) v *= 10;
    if (j>n/2) v *= 10;
  } else if (problem==2) {
    v = v * sqrt(i+j+1);
  }
  return -v;
}

static double coply(int i,int j,int m,int n,int problem)
{
  Scalar v = 1.0;
  if (problem==1) {
    if (i>m/2) v *= 10;
    if (j>n/2) v *= 10;
  } else if (problem==2) {
    v = v * sqrt(i+j+1);
  }
  return -v;
}

static int DomPt(int ii,int jj,int i,int j,int m,int n,int problem,Scalar *cv)
{
  if (ii)
    *cv = coplx(i,j,m,n,problem);
  else
    *cv = coply(i,j,m,n,problem);
  return ((i>=0) & (j>=0) & (i<m) & (j<n));
}

static int Coupling(Mat C,int i,int ii,int j,int jj,int m,int n,int I,
		    int problem,double w,double hv,
		    int *xlo,int *ylo,int npx,int npy,int ipx,int ipy,int *nv,
		    double *dv)
{
  int acpt,J,ierr; double v,cv;

  acpt = DomPt(ii,jj,i+ii,j+jj,m,n,problem,&cv);
  v = w*(hv+cv)*.5; *dv -= v;
  if (acpt) {
    int tx,ty;
    if (i+ii>=ylo[ipy+1]) ty = ipy+1;
    else if (i+ii<ylo[ipy]) ty = ipy-1; else ty = ipy;
    if (j+jj>=xlo[ipx+1]) tx = ipx+1;
    else if (j+jj<xlo[ipx]) tx = ipx-1; else tx = ipx;
    J = nv[tx+npx*ty] + (j+jj-xlo[tx]) + (i+ii-ylo[ty])*(xlo[tx+1]-xlo[tx]);
    /*    J = i*n+j;*/
    ierr = MatSetValues(C,1,&I,1,&J,&v,INSERT_VALUES); CHKERRQ(ierr);
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "make_mat"
int make_mat(MPI_Comm comm,int problem,
	     int ipx,int ipy,int npx,int npy,
	     Mat *C, Vec *V, int dom,int *nn, Scalar **rhs)
{
  int         m,n,N, i,j, IJ=0;
  int         mm,ierr;
  int ilo,ihi, jlo,jhi;

  m = n = dom; N = m*n;

  /* create the matrix for the five point stencil */
  ierr = MatCreateMPIAIJ(comm,PETSC_DECIDE,PETSC_DECIDE,N,N,3,0,2,0,C); 
  CHKERRQ(ierr);
  ierr = MatGetLocalSize(*C,nn,&mm); CHKERRQ(ierr);

  /* and a dummy right hand side for a linear system */
  ierr = VecCreateMPI(comm,*nn,PETSC_DECIDE,V);
  CHKERRQ(ierr);

#define NINE 0
  {
    int *xlo,*ylo,*nv,xp,yp,t=0;
    xlo = (int*) malloc((npx+1)*sizeof(int));
    ylo = (int*) malloc((npy+1)*sizeof(int));
    nv  = (int*) malloc(npx*npy*sizeof(int));
    for (xp=0; xp<=npx; xp++) xlo[xp] = (n*xp)/npx;
    for (yp=0; yp<=npy; yp++) ylo[yp] = (n*yp)/npy;
    ilo = (n*ipy)/npy; ihi = (n*(ipy+1))/npy;
    jlo = (n*ipx)/npx; jhi = (n*(ipx+1))/npx;
    for (yp=0; yp<npy; yp++)
      for (xp=0; xp<npx; xp++) {
	nv[xp+yp*npx] = t; t += (xlo[xp+1]-xlo[xp])*(ylo[yp+1]-ylo[yp]);
      }
    for ( i=ilo; i<ihi; i++ ) { 
      for ( j=jlo; j<jhi; j++ ) {
	/*      int I = j + n*i;*/
	int I = j-jlo + (jhi-jlo)*(i-ilo) + nv[ipx+ipy*npx];
	
	Scalar dv=0.0, hv=(coplx(i,j,m,n,problem)+coply(i,j,m,n,problem))*.5,
	  one=1.0,qrt=0.25;
	
	ierr = Coupling(*C,i,+1,j,+0,m,n,I,problem,one,hv,
			xlo,ylo,npx,npy,ipx,ipy,nv,
			&dv); CHKERRQ(ierr);
	ierr = Coupling(*C,i,-1,j,+0,m,n,I,problem,one,hv,
			xlo,ylo,npx,npy,ipx,ipy,nv,
			&dv); CHKERRQ(ierr);
	ierr = Coupling(*C,i,+0,j,+1,m,n,I,problem,one,hv,
			xlo,ylo,npx,npy,ipx,ipy,nv,
			&dv); CHKERRQ(ierr);
	ierr = Coupling(*C,i,+0,j,-1,m,n,I,problem,one,hv,
			xlo,ylo,npx,npy,ipx,ipy,nv,
			&dv); CHKERRQ(ierr);
	/*
	  if (NINE) {
	  ierr = Coupling(*C,i,+1,j,+1,m,n,I,problem,qrt,hv,
	  &dv); CHKERRQ(ierr);
	  ierr = Coupling(*C,i,-1,j,+1,m,n,I,problem,qrt,hv,
	  &dv); CHKERRQ(ierr);
	  ierr = Coupling(*C,i,+1,j,-1,m,n,I,problem,qrt,hv,
	  &dv); CHKERRQ(ierr);
	  ierr = Coupling(*C,i,-1,j,-1,m,n,I,problem,qrt,hv,
	  &dv); CHKERRQ(ierr);
	  }
	*/
	ierr = MatSetValues(*C,1,&I,1,&I,&dv,INSERT_VALUES); CHKERRQ(ierr);
	{
	  Scalar vv = (Scalar) 1.0 /*(I+1)*/;
	  ierr = VecSetValues(*V,1,&I,&vv,INSERT_VALUES); CHKERRQ(ierr);
	}
	IJ++;
      }
    }
    free(xlo); free(ylo); free(nv);
  }
  ierr = MatAssemblyBegin(*C,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = MatAssemblyEnd(*C,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);

  ierr = VecAssemblyBegin(*V); CHKERRQ(ierr);
  ierr = VecAssemblyEnd(*V); CHKERRQ(ierr);
  ierr = VecGetArray(*V,rhs); CHKERRQ(ierr);

return 0;
}
