/*
       The ParPre error handlers
*/
#include "petsc.h"           /*I "petsc.h" I*/
#include <stdio.h>           /*I <stdio.h> I*/
#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif
#include "pinclude/petscfix.h"

struct EH {
  int    cookie;
  int    (*handler)(int, char*,char *,int,char*,void *);
  void   *ctx;
  struct EH* previous;
};

static struct EH* eh = 0;

#undef __FUNC__
#define __FUNC__ "OldParPreTraceBackErrorHandler"
int OldParPreTraceBackErrorHandler(int line,char *dir,char *file,int number,
                             char *message,void *ctx)
{
  int        tid,flg;

  MPI_Comm_rank(MPI_COMM_WORLD,&tid);
  if (number == PETSC_ERR_MEM) {
    if (!dir) fprintf(stderr,"[%d]PARPRE ERROR: %s line # %d\n",tid,file,line);
    else      fprintf(stderr,"[%d]PARPRE ERROR: %s%s line # %d\n",tid,dir,file,line);
    fprintf(stderr,"[%d]PARPRE ERROR: Out of memory. This could be due to\n",tid);
    fprintf(stderr,"[%d]PARPRE ERROR: allocating too large an object or\n",tid);
    fprintf(stderr,"[%d]PARPRE ERROR: bleeding by not properly destroying\n",tid);
    fprintf(stderr,"[%d]PARPRE ERROR: unneeded objects.\n",tid);
    OptionsHasName(PETSC_NULL,"-trdump",&flg);
    if (flg) {
      PetscTrDump(stderr);
    }
    else {
      fprintf(stderr,"[%d]PARPRE ERROR: Try running with -trdump. \n",tid);
    }
    number = 1;
  }
  else if (number == PETSC_ERR_SUP) {
    if (!dir) fprintf(stderr,"[%d]PARPRE ERROR: %s line # %d\n",tid,file,line);
    else      fprintf(stderr,"[%d]PARPRE ERROR: %s%s line # %d\n",tid,dir,file,line);
    fprintf(stderr,"[%d]PARPRE ERROR: %s: No support for this operation\n",tid,message);
    fprintf(stderr,"[%d]PARPRE ERROR: for this object type!\n",tid);
    number = 1;
  }
  else if (number == PETSC_ERR_SIG) {
    fprintf(stderr,"[%d]PARPRE ERROR: ",tid);
    fprintf(stderr,"%s %s\n",file,message);
  }
  else if (number == PETSC_ERR_ARG_SIZ) {
    if (!dir) fprintf(stderr,"[%d]PARPRE ERROR: %s line # %d\n",tid,file,line);
    else      fprintf(stderr,"[%d]PARPRE ERROR: %s%s line # %d\n",tid,dir,file,line);
    fprintf(stderr,"[%d]PARPRE ERROR: %s: Nonconforming object sizes!\n",tid,message);
    number = 1;
  }
  else {
    fprintf(stderr,"[%d]PARPRE ERROR: ",tid);
    if (!dir) {
      if (!message) fprintf(stderr,"%s line # %d\n",file,line);
      else fprintf(stderr,"%s line # %d %s\n",file,line,message);
    }
    else   {
      if (!message) fprintf(stderr,"%s%s line # %d\n",dir,file,line);
      else fprintf(stderr,"%s%s line # %d %s\n",dir,file,line,message);
    }
  }
  return number;
}

#undef __FUNC__
#define __FUNC__ "ParPreTraceBackErrorHandler"
int ParPreTraceBackErrorHandler(int line,char *fun,char* file,char *dir,int n,int p,char *mess,void *ctx)
{
  int        rank,flg1,flg2;
  PLogDouble mem,rss;

  if (!fun)  fun = "unknownfunction";
  if (!dir)  dir = " ";

  MPI_Comm_rank(MPI_COMM_WORLD,&rank);
  if (n == PETSC_ERR_MEM) {
    fprintf(stderr,"[%d]ParPre ERROR: %s() line %d in %s%s\n",rank,fun,line,dir,file);
    fprintf(stderr,"[%d]ParPre ERROR:   Out of memory. This could be due to allocating\n",rank);
    fprintf(stderr,"[%d]ParPre ERROR:   too large an object or bleeding by not properly\n",rank);
    fprintf(stderr,"[%d]ParPre ERROR:   destroying unneeded objects.\n",rank);
    PetscTrSpace(&mem,PETSC_NULL,PETSC_NULL); PetscGetResidentSetSize(&rss);
    OptionsHasName(PETSC_NULL,"-trdump",&flg1);
    OptionsHasName(PETSC_NULL,"-trmalloc_log",&flg2);
    if (flg2) {
      PetscTrLogDump(stderr);
    } else if (flg1) {
      fprintf(stderr,"[%d]ParPre ERROR:   Memory allocated %d Memory used by process %d\n",rank,(int)mem,(int)rss);
      PetscTrDump(stderr);
    }  else {
      fprintf(stderr,"[%d]ParPre ERROR:   Memory allocated %d Memory used by process %d\n",rank,(int)mem,(int)rss);
      fprintf(stderr,"[%d]ParPre ERROR:   Try running with -trdump or -trmalloc_log for info.\n",rank);
    }
    n = 1;
  }
  else if (n == PETSC_ERR_SUP) {
    if (!mess) mess = " ";
    fprintf(stderr,"[%d]ParPre ERROR: %s() line %d in %s%s\n",rank,fun,line,dir,file);
    fprintf(stderr,"[%d]ParPre ERROR: No support for this operation for this object type!\n",rank);
    fprintf(stderr,"[%d]ParPre ERROR: %s\n",rank,mess);
    n = 1;
  }
  else if (n == PETSC_ERR_SIG) {
    fprintf(stderr,"[%d]ParPre ERROR: %s() line %d in %s%s %s\n",rank,fun,line,dir,file,mess);
  }
  else if (n == PETSC_ERR_ARG_SIZ) {
    if (!mess) mess = " ";
    fprintf(stderr,"[%d]ParPre ERROR: %s() line %d in %s%s\n",rank,fun,line,dir,file);
    fprintf(stderr,"[%d]ParPre ERROR:   %s: Nonconforming object sizes!\n",rank,mess);
    n = 1;
  }
  else {
    if (mess) {
      fprintf(stderr,"[%d]ParPre ERROR: %s() line %d in %s%s\n    %s\n",rank,fun,line,dir,file,mess);
    } else {
      fprintf(stderr,"[%d]ParPre ERROR: %s() line %d in %s%s\n",rank,fun,line,dir,file);
    }
  }
  fflush(stderr);
  return n;
}

