#include "pc.h" /* VE this shoudln't be, but it gets taken from petsc, not parpre */
#include "sles.h"
#include "src/vec/vecimpl.h"
#include "src/pc/pcimpl.h"            /*I "pc.h" I*/
#include "pinclude/pviewer.h"

#define CHUNCKSIZE   100

#undef __FUNC__
#define __FUNC__ "ParPreGenerateSLES"
int ParPreGenerateSLES(MPI_Comm comm,SLES *sles)
{
  KSP subksp; PC subpc; int ierr;

  ierr = SLESCreate(comm,sles); CHKERRQ(ierr);
  ierr = SLESGetKSP(*sles,&subksp); CHKERRQ(ierr);
  ierr = KSPSetType(subksp,KSPPREONLY); CHKERRQ(ierr);
  ierr = SLESGetPC(*sles,&subpc); CHKERRQ(ierr);
  ierr = PCSetType(subpc,PCNONE); CHKERRQ(ierr);
  
  return 0;
}

#undef __FUNC__
#define __FUNC__ "ParPreSetupSLES"
int ParPreSetupSLES(SLES sub_method,PCType type,Mat mat, Vec vec)
{
  PC subpc;
  int ierr;

  ierr = SLESSetOperators(sub_method,mat,mat,(MatStructure)0); CHKERRQ(ierr);
  ierr = SLESGetPC(sub_method,&subpc); CHKERRQ(ierr);
  ierr = PCSetVector(subpc,vec); CHKERRQ(ierr);
  if (type!=PETSC_NULL) {
    ierr = PCSetType(subpc,type); CHKERRQ(ierr);}
  ierr = PCSetUp(subpc); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "IntSort"
int IntSort(int *ar,int len)
{
  int i,j,t;
  for (j=len-1; j>=1; j--)
    for (i=0; i<j; i++)
      if (ar[i]>ar[i+1]) {t = ar[i+1]; ar[i+1]=ar[i]; ar[i]=t;}
  return 0;
}
