/*
    The PC (preconditioner) interface routines, callable by users.
*/
#include "parpre_pc.h"
#include "src/pc/pcimpl.h"            /*I "pc.h" I*/

#undef __FUNC__
#define __FUNC__ "PCHasType"
int PCHasType(PC pc,PCType type,int *flag)
{
  PCType the_type;
  int ierr;

  ierr = PCGetType(pc,&the_type); CHKERRQ(ierr);
  *flag = (int) PetscStrstr(type,the_type);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCIsParallel"
int PCIsParallel(PC pc) /* VE */
{
  /*if (pc->type >= PCAdditiveSchwarz)*/ return 1;
  /*else return 0;*/
}

#undef __FUNC__
#define __FUNC__ "PCIsSchwarzMethod"
int PCIsSchwarzMethod(PC pc) /* VE */
{
  PCType type;
  int ierr;
  
  ierr = PCGetType(pc,&type);
  if (PetscStrstr(type,PCAdditiveSchwarz)||PetscStrstr(type,PCMultiplicativeSchwarz))
    return 1;
  else return 0;
}

