#include "src/pc/pcimpl.h"      /*I "pc.h" I*/
#include "sles.h"
#include "petsc.h"
#include <stdio.h>
#include "src/sys/nreg.h"
#include "sys.h"
#include "options.h"
#include "src/vec/vecimpl.h"                     /*I "vec.h" I*/
#include "parpre_subdomains.h"

extern int PCRegisterParPre(char *path);
int ParPreInitializedCalled = 0;
#if defined(USE_DYNAMIC_LIBRARIES)
extern DLLibraryList DLLibrariesLoaded;
#endif

/****************************************************************
 **************** ParPre Setup and such
 ****************************************************************/
#undef __FUNC__
#define __FUNC__ "ParPreInitialize"
int ParPreInitialize(int*argv,char***argc,char*p1,char*p2)
{
  int ierr;

printf("initialise parpre\n");
  if (!PetscInitializedCalled) {
    ierr = PetscInitialize(argv,argc,p1,p2); CHKERRQ(ierr);
  }

  if (!ParPreInitializedCalled) {
    char libs[256];

    ParPreInitializedCalled = 1;

    ierr = OptionsSetValue("-mat_mpi",0); CHKERRQ(ierr);
#if defined(USE_DYNAMIC_LIBRARIES)
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparpresles"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparpremat"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparprevec"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparpresys"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
#endif

    ierr = PCRegisterParPre(PETSC_NULL); CHKERRQ(ierr);
  }

  return 0;
}

#undef __FUNC__
#define __FUNC__ "ParPreFinalize"
int ParPreFinalize()
{
  int ierr;
  ierr = PetscFinalize(); CHKERRQ(ierr);
  return 0;
}

#undef __FUNC__
#define __FUNC__ "ParPreSetup"
int ParPreSetup(MPI_Comm comm,Mat A,PC B)
{
  Vec pc_vec;
  int ierr,lsize,idum;

  ierr = PCSetOperators(B,A,A,(MatStructure)0); CHKERRQ(ierr);
  ierr = MatGetLocalSize(A,&lsize,&idum); CHKERRQ(ierr);
  ierr = VecCreateMPI(comm,lsize,PETSC_DECIDE,&pc_vec); CHKERRQ(ierr);
  ierr = PCSetVector(B,pc_vec); CHKERRQ(ierr);
  ierr = PCSetFromOptions(B); CHKERRQ(ierr);
  ierr = PCSetUp(B); CHKERRQ(ierr);

  return 0;
}
