/*
   Defines an OVERLAPPING  preconditioner for any Mat implementation
*/
#include "petsc.h"
#include "src/vec/vecimpl.h"
/* #include "src/mat/impls/aij/mpi/mpiaij.h"*/
#include "parpre_pc.h"
#include "parpre_pipeline.h"
#include "parpre_subdomains.h"
#include "pcschwarz.h"

#define CHUNCKSIZE   100

extern int MatMultAXBY_AIJ(Scalar a, Mat aijin,Vec xx,
			   Scalar b, Vec yy,Vec zz);
extern int PCCustomPipelineSetFromOptions(PC pc);
extern int PCSetFromOptions_Schwarz(PC pc);

extern int ParPreTraceBackErrorHandler
    (int,char*,char*,char*,int,int,char*,void*);

#undef __FUNC__
#define __FUNC__ "PCMulSchwarzSetHaloSize"
int PCMulSchwarzSetHaloSize(PC pc, int ns)
{
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  pc_data->halo_width = ns;
  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCApply_MulSchwarz"
static int PCApply_MulSchwarz(PC pc,Vec x,Vec y)
{
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  int ierr,its;
  Scalar zero = 0.0;

  ierr = PetscPushErrorHandler(&ParPreTraceBackErrorHandler,0);
  CHKERRQ(ierr);

  ierr = VecScatterBegin
    (x,pc_data->extended_vec,INSERT_VALUES,SCATTER_FORWARD,
     pc_data->scatter_to_extended);
  CHKERRQ(ierr);
  ierr = VecScatterEnd
    (x,pc_data->extended_vec,INSERT_VALUES,SCATTER_FORWARD,
     pc_data->scatter_to_extended);
  CHKERRQ(ierr);

  /* delegate solving and piping to the embedded ssor solver
     on the extended vectors */
  ierr = SLESSolve(pc_data->ssor_solver,
		   pc_data->extended_vec,pc_data->extended_vec2,&its);
  /*  VecView(pc_data->extended_vec,0); VecView(pc_data->extended_vec2,0);*/
  CHKERRQ(ierr);
  VecSet(&zero,y);

  ierr = VecPipelineBegin
    (pc_data->extended_vec2,y,INSERT_VALUES,SCATTER_FORWARD,PIPELINE_UP,
     pc_data->pipe_from_extended);
  CHKERRQ(ierr);
  ierr = VecPipelineEnd
    (pc_data->extended_vec2,y,INSERT_VALUES,SCATTER_FORWARD,PIPELINE_UP,
     pc_data->pipe_from_extended);
  CHKERRQ(ierr);

  ierr = PetscPopErrorHandler(); CHKERRQ(ierr);

  return 0;

}

#undef __FUNC__
#define __FUNC__ "PCSetFromOptions_MulSchwarz"
static int PCSetFromOptions_MulSchwarz(PC pc)
{
  int ierr;
  
  ierr = PCSetFromOptions_Schwarz(pc); CHKERRQ(ierr);
  ierr = PCCustomPipelineSetFromOptions(pc); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCCreate_MulSchwarz"
int PCCreate_MulSchwarz(PC pc)
{
  int ierr;

  pc->apply     = PCApply_MulSchwarz;
  pc->applyrich = 0;
  pc->destroy   = PCDestroy_Schwarz;
  pc->printhelp = 0;
  pc->view      = PCView_Schwarz;
  pc->setup     = PCSetup_Schwarz;
  pc->setfromoptions   = PCSetFromOptions_MulSchwarz;
  /*  pc->type      = PCMultiplicativeSchwarz;*/

  ierr = PCParallelSubdomainsCreate(pc,sizeof(PC_Schwarz_struct));
  CHKERRQ(ierr);

  ierr = PCSchwartzInstallSSORSubSolve(pc); CHKERRQ(ierr);
  ierr = PCParallelSubdomainPipelineSetType
    (pc,PIPELINE_SEQUENTIAL,(PetscObject)PETSC_NULL); CHKERRQ(ierr);

  return 0;
}

