#ifndef __ML_IMPL_PACKAGE
#define __ML_IMPL_PACKAGE

#include "vec.h"
#include "mat.h"
#include "sles.h"
#include "pc.h"
#include "parpre_pc.h"
#include "parpre_subdomains.h"

struct OneLevel {
  MPI_Comm comm;
  int level,rstart,rend,local_size,global_size;
#if RUGE
  int isize,jsize;
#endif
  Mat mat;
  /* diagonal; id with lumping of small elements, id but 1-block only */
  Vec diag,cdiag,cdiag1; 
  IS indices,indices1,indices2;
  Mat a12,a21;
  Mat l21; /* hmmmmmm */
  Mat g11,g12,g21,g22,s2; /* global versions of same */
  Vec u,v,w,u1,v1,u2,v2,w1,w2,g1,g2,h1,h2,k1,k2;
  SLES a11_solve,a22_solve,pre_smooth,post_smooth;
  VecScatter get_clr,put_clr,get_rest,put_rest;
  AMLSolveScheme solve_scheme;
  int it11,transfer,degree;
  Scalar *coffs;
  struct OneLevel *next_level;
} ;

typedef struct OneLevel MC_OneLevel_struct;

typedef struct {
  PCParallelSubdomainStruct subdomains;
  MC_OneLevel_struct *level_stuff;
  AMLFillMethod fill_method; int modification;
  AMLSolveScheme solve_scheme;
  AMLCoarseGridChoice grid_choice;
  AMLSchurChoice schur_choice;
  AMLSmootherChoice smoother_choice;
  SLES pre_smoother,post_smoother;
  int my_high_level,the_high_level,mis_from_strong,cutoff,it11,transfer,degree,
    pivot_repair,trace_level;
} PC_MCol_struct;

struct _DirectPC {Mat cof; Mat xpl; Vec res; Vec dif; int it;};
typedef struct _DirectPC* DirectPC;

#endif
