#include "petsc.h"
#include "parpre_pc.h"
#include "src/pc/pcimpl.h"
#include "ml_impl.h"

/****************************************************************
 * User Interface                                               *
 ****************************************************************/

#undef __FUNC__
#define __FUNC__ "AMLSetFillMethod"
int AMLSetFillMethod(PC pc,AMLFillMethod fill_method)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Fill method can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->fill_method = fill_method;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetSolutionScheme"
int AMLSetSolutionScheme(PC pc,AMLSolveScheme solve_scheme)
{
  PCType meth; int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Solve scheme can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->solve_scheme = solve_scheme;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetCoarseGridDependent"
int AMLSetCoarseGridDependent(PC pc)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Grid choice can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->grid_choice = AMLCoarseGridDependent;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetCoarseGridIndependent"
int AMLSetCoarseGridIndependent(PC pc)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Grid choice can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->grid_choice = AMLCoarseGridIndependent;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetSchurElimination"
int AMLSetSchurElimination(PC pc)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Schur choice can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->schur_choice = AMLSchurElimination;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetSchurVariational"
int AMLSetSchurVariational(PC pc)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Schur choice can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->schur_choice = AMLSchurVariational;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetCutoffSize"
int AMLSetCutoffSize(PC pc,int siz)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Cutoff sizes can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->cutoff = siz;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetCycleDegree"
int AMLSetCycleDegree(PC pc,int deg)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Cutoff sizes can only be set for AML");
  if (deg<1) SETERRQ(1,0,"Degree has to be positive");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->degree = deg;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetModification"
int AMLSetModification(PC pc,int mod)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Modifiation only be set for AML");
  if (mod<0) SETERRQ(1,0,"Modification has to be non-negative");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->modification = mod;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSet11JacobiIterations"
int AMLSet11JacobiIterations(PC pc,int it)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"11Block iterations can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->it11 = it;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetSmootherChoice"
int AMLSetSmootherChoice(PC pc,AMLSmootherChoice smoother)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Smoothers can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->smoother_choice = smoother;
  }

  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetISFromStrong"
int AMLSetISFromStrong(PC pc)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;

  PetscFunctionBegin;
  pc_data->mis_from_strong = 1;

  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetISFromOriginal"
int AMLSetISFromOriginal(PC pc)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;

  PetscFunctionBegin;
  pc_data->mis_from_strong = 0;

  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetTransfer"
int AMLSetTransfer(PC pc)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Transfer only defined for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->transfer = 1;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetNoTransfer"
int AMLSetNoTransfer(PC pc)
{
  int ierr,flag;

  PetscFunctionBegin;
  ierr = PCHasType(pc,PCMultiLevel,&flag); CHKERRQ(ierr);
  if (!flag) SETERRQ(1,0,"Transfer only defined for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->transfer = 0;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetPivotRepair"
/* how to deal with negative pivots during factorisation:
   0 = leave alone
   1 = Kershaw repair
   2 = on-processor Manteuffel
   3 = globally synchronised Manteuffel */
int AMLSetPivotRepair(PC pc,int rep)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;

  PetscFunctionBegin;
  pc_data->pivot_repair = rep;

  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "AMLSetTraceLevel"
int AMLSetTraceLevel(PC pc,int lev)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;

  PetscFunctionBegin;
  pc_data->trace_level = lev;

  PetscFunctionReturn(0);
}
