#ifndef __PARPRE_MATIMPL_PACKAGE 
#define __PARPRE_MATIMPL_PACKAGE

#include "parpre_mat.h"
#include "parpre_pipeline.h"
#include "sles.h"

struct _MatGatherCtx {
  VecPipeline vs;
  /* this batch of elements comes from the setup */
  int mytid,numtids,N; MPI_Comm comm;
  int send_nrows_tot,request_nrows_tot,custom_sends,custom_recvs;
  int nsends_all,nrecvs_all;
  int *send_procs_all,*recv_procs_all;
  int *send_rows,*send_rows_ptrs;
  int *request_row_ptrs;
  /* passed from send to receive */
  MPI_Request *send_requests; int nsends_outstanding; void **send_buffers;
} ;

extern int MatMultAXBY_AIJ
(Scalar a, Mat aijin,Vec xx, Scalar b, Vec yy,Vec zz);
extern int MatMatMult_AIJ(Mat a, Mat b, Mat *c);
extern int MatMatSubtract_AIJ(Mat a, Mat b, Mat *c);
extern int MatSolveMat_AIJ(SLES solver,Mat off_mat,Mat *off_mult);

extern int MatGetRowLen_MPIAIJ(Mat mat,int row,int *len);
extern int MatMaxRowLen_MPIAIJ(Mat A, int *rowlen);
extern int MatMaxRowOffDiagElement_MPIAIJ(Mat A,Vec e);
extern int MatMaxColOffDiagElement_MPIAIJ(Mat A,Vec e);
extern int MatMatMult_MPIAIJ(Mat A,Mat B,Mat *C);
extern int MatMatAdd_MPIAIJ(Mat A,Mat B,MatReuse use,Mat *C);
extern int MatMatSub_MPIAIJ(Mat A,Mat B,Mat *C);

#endif
