#define PARPRE
/*   Example Program to test ParPre Library */
/*  This is a very simple test and by no means exhaustive */

#include <stdio.h>
#include "petsc.h"
#include "parpre.h"
#include "vec.h"
#ifdef PARPRE
#include "pc.h"
#else
#include "sles.h"
#endif
#include "sys.h"
#include "options.h"
#include <math.h>
#include "./examples.h"

extern int PCRegisterParPre(char *path);
/* void __main() {}*/

#undef __FUNC__
#define __FUNC__ "main"
int main(int Argc,char **Args)
{
  Mat       A;
  PC        B;
  Vec       V;
  MPI_Comm comm;
  int       numtids,mytid,ierr;
  int local_size,domain_size = 20;
  Scalar *rhs_values,*sol_values;

  ParPreInitialize(&Argc,&Args,PETSC_NULL,PETSC_NULL);

  comm = MPI_COMM_WORLD;
  MPI_Comm_size(comm,&numtids);
  MPI_Comm_rank(comm,&mytid);

  /* make Poisson matrix */
  if (mytid==0) {
    int flg;
    ierr = OptionsGetInt(PETSC_NULL,"-size",&domain_size,&flg); CHKERRA(ierr);
    if (!flg) {
      printf("Domain size: "); scanf("%d",&domain_size);
      printf("=> %d\n",domain_size);
    }
  }
  MPI_Bcast(&domain_size,1,MPI_INT,0,comm);

  ierr = make_mat(comm,&A,&V,domain_size,&local_size,&rhs_values);
  sol_values = (double *) malloc(local_size*sizeof(double));

  /* setup and execute cg method */
#ifdef PARPRE
  ierr = PCCreate(comm,&B); CHKERRQ(ierr);
  ierr = PCSetVector(B,V); CHKERRQ(ierr);
  ierr = prec_setup(comm,A,B); CHKERRA(ierr);
  ierr = PCView(B,0); CHKERRA(ierr);
  ierr = cg(comm,A,B,sol_values,rhs_values,local_size); CHKERRA(ierr);
#else
  {
    SLES cg;
    Vec rhs,sol;
    Scalar one = 1.0;
    int its;

    ierr = VecCreateMPI(comm,local_size,PETSC_DECIDE,&rhs); CHKERRA(ierr);
    ierr = VecSet(&one,rhs); CHKERRA(ierr);
    ierr = VecDuplicate(rhs,&sol); CHKERRA(ierr);
    ierr = SLESCreate(MPI_COMM_WORLD,&cg); CHKERRA(ierr);
    ierr = SLESSetOperators(cg,A,A,0); CHKERRA(ierr);
    ierr = SLESSetUp(cg,rhs,sol); CHKERRA(ierr);
    {
      PC B;
      ierr = SLESGetPC(cg,&B); CHKERRA(ierr);
      ierr = PCView(B,0); CHKERRA(ierr);
    }
    ierr = SLESSolve(cg,rhs,sol,&its); CHKERRA(ierr);
    PetscPrintf(comm,"Number of iterations: %d\n",its);
  }
#endif
    /* cleanup after ourselves. */
#ifdef PARPRE
  PCDestroy(B);
#endif
  ParPreFinalize();

return 0;
}
