#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCMultiLevel;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  PetscPrintf(comm,"Setting up AMG pc\n");
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  goto skip_id;

  /****************
    Identity preconditioner
  ****************/

  /* factorisation as ILU but no actual factorisation */
  ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillNone); CHKERRQ(ierr);

  /* solution as ILU, but no transfer,
     and PCNONE on (1,1) blocks and deepest level */
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
  ierr = OptionsSetValue("-11solver_pc_type","none"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-lastlevel_pc_type","none"); CHKERRQ(ierr);
  ierr = AMLSetNoTransfer(the_pc); CHKERRQ(ierr);

 skip_id:
  goto skip_jac;

  /****************
   * Jacobi preconditioner
   ****************/

  /* factorisation as ILU but no actual factorisation */
  ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillNone); CHKERRQ(ierr);

  /* solution as ILU, but no transfer,
     and PCJACOBI on (1,1) blocks and deepest level */
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
  ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = AMLSetNoTransfer(the_pc); CHKERRQ(ierr);

 skip_jac:
  goto skip_ssor;

  /****************
   * SSOR preconditioner
   ****************/

  ierr = AMLSetTraceLevel(the_pc,AMLTraceIndexSets); CHKERRQ(ierr);

  /* factorisation as ILU */
  ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillNone); CHKERRQ(ierr);

  /* solution as ILU with PCJACOBI on (1,1) blocks and deepest level */
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
  ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);

 skip_ssor:
  goto skip_ilu;

  /****************
   * incomplete factorisation
   ****************/

  /* factorisation as ILU(0) */
  ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillDiag); CHKERRQ(ierr);

  /* solution as ILU with PCJACOBI on (1,1) blocks and deepest level */
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
  ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);

 skip_ilu:
  /*  goto skip_amg;*/

  /****************
   * multigrid 
   ****************/

  /* variational elimination */
  ierr = AMLSetCoarseGridIndependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetSchurVariational(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillFull); CHKERRQ(ierr);

  /* solution as ILU for now */
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveMG); CHKERRQ(ierr);
  ierr = AMLSetSmootherChoice(the_pc,AMLPrePostSmooth); CHKERRQ(ierr);
  ierr = OptionsSetValue("-presmoother_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-postsmoother_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
  ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);

  /* undocumented option */
  ierr = AMLSetISFromOriginal/*Strong*/(the_pc); CHKERRQ(ierr);

  goto no_smooth;
  /* set the smoothers */
  {
    PC local_pc;

    /* a11 solver */
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCJACOBI); CHKERRQ(ierr);
    ierr = AMLSet11JacobiIterations(the_pc,1);
    /*
      ierr = PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
      ierr = PCSORSetSymmetric(local_pc,SOR_LOCAL_SYMMETRIC_SWEEP); CHKERRQ(ierr);
      ierr = PCSORSetIterations(local_pc,1); CHKERRQ(ierr);
      */
    
    /* last level solver */
    ierr = AMLSetCutoffSize(the_pc,15); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
  }
 no_smooth:
 skip_amg:

  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  return 0;
}

