#include "vec.h"
#include "mat.h"
#include "options.h"
#include "stdio.h"
#include "./examples.h"

static double coplx(int i,int j,int m,int n)
{
  Scalar v = 1.0;
  /*  if (i>m/2) v *= 10;
      if (j>n/2) v *= 10;*/
  return -v;
}

static double coply(int i,int j,int m,int n)
{
  Scalar v = 1.0;
  /*  if (i>m/2) v *= 10;
      if (j>n/2) v *= 10;*/
  return -v;
}

static int DomPt(int ii,int jj,int i,int j,int m,int n,int *J,Scalar *cv)
{
  *J = i*n+j; 
  if (ii)
    *cv = coplx(i,j,m,n);
  else
    *cv = coply(i,j,m,n);
  return ((i>=0) & (j>=0) & (i<m) & (j<n));
}

static int Coupling(Mat *C,int i,int ii,int j,int jj,int m,int n,int I,
		    double w,double hv,double *dv)
{
  int acpt,J,ierr; double v,cv;

  acpt = DomPt(ii,jj,i+ii,j+jj,m,n,&J,&cv);
  v = w*(hv+cv)*.5; *dv -= v;
  if (acpt) {
    ierr = MatSetValues(*C,1,&I,1,&J,&v,INSERT_VALUES);
    CHKERRQ(ierr);
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "make_mat"
int make_mat(MPI_Comm comm,Mat *C, Vec *V, int dom,int *nn, Scalar **rhs)
{
  int         m,n,N, i,j, mytid,numtids;
  int         mm,ierr;
  int jlo,jhi;

  m = n = dom; N = m*n;

  MPI_Comm_rank(comm,&mytid);
  MPI_Comm_size(comm,&numtids);

  /* create the matrix for the five point stencil */
  ierr = MatCreateMPIAIJ(comm,PETSC_DECIDE,PETSC_DECIDE,N,N,3,0,2,0,C); 
  CHKERRQ(ierr);
  ierr = MatGetLocalSize(*C,nn,&mm); CHKERRQ(ierr);

  /* and a dummy right hand side for a linear system */
  ierr = VecCreateMPI(comm,*nn,PETSC_DECIDE,V);
  CHKERRQ(ierr);

#define NINE 0
/* parallel: j=(n*mytid)/numtids; j<(n*(mytid+1))/numtids */
  jlo = (n*mytid)/numtids; jhi = (n*(mytid+1))/numtids;
  for ( i=0; i<m; i++ ) { 
    for ( j=jlo; j<jhi; j++ ) {
      int I = j + n*i;
      Scalar dv=0.0, hv=(coplx(i,j,m,n)+coply(i,j,m,n))*.5,one=1.0,qrt=0.25;

      ierr = Coupling(C,i,+1,j,+0,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      ierr = Coupling(C,i,-1,j,+0,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      ierr = Coupling(C,i,+0,j,+1,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      ierr = Coupling(C,i,+0,j,-1,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      if (NINE) {
	ierr = Coupling(C,i,+1,j,+1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
	ierr = Coupling(C,i,-1,j,+1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
	ierr = Coupling(C,i,+1,j,-1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
	ierr = Coupling(C,i,-1,j,-1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
      }
      ierr = MatSetValues(*C,1,&I,1,&I,&dv,INSERT_VALUES); CHKERRQ(ierr);
      {
	Scalar vv = (Scalar) 1.0 /*(I+1)*/;
	ierr = VecSetValues(*V,1,&I,&vv,INSERT_VALUES); CHKERRQ(ierr);
      }
    }
  }

  ierr = MatAssemblyBegin(*C,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = MatAssemblyEnd(*C,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);

  ierr = VecAssemblyBegin(*V); CHKERRQ(ierr);
  ierr = VecAssemblyEnd(*V); CHKERRQ(ierr);
  ierr = VecGetArray(*V,rhs); CHKERRQ(ierr);

return 0;
}
