/*   Example Program to test KSP Library */
/*  This is a very simple test and by no means exhaustive */

#include <stdio.h>
#include "mpi.h"
#include "petsc.h"
#include "vec.h"
#include "ksp.h"
#include "sys.h"
#include "pc.h"
#include "options.h"
#include <math.h>

/* from mat.c */
int make_mat(MPI_Comm comm,Mat *A,Vec *b,int *vs, Scalar **vv);

/* from prec.c */
int prec_setup(MPI_Comm comm,Mat A,PC *B);

/* from cg.c */
int cg(MPI_Comm comm,Mat A, PC B,double *sol, double *rhs, int lsize);

int CurrentResidual(KSP itP, double *rnorm)
{
  int ierr;
  Vec r;

  ierr = KSPBuildResidual(itP,0,0,&r); CHKERRQ(ierr);
  ierr = VecNorm(r,NORM_2,rnorm); CHKERRQ(ierr);

  return 0;
}

int usr_monitor(KSP itP,int N,double rnorm,void *uuexact)
{
  double rrnorm; int mytid,ierr;

  MPI_Comm_rank(MPI_COMM_WORLD,&mytid);
  ierr = CurrentResidual( itP, &rrnorm); CHKERRQ(ierr);
  if (!mytid) printf("%3d %14.7e\n",N,rnorm);
  return 0;
}
/*-------------------------------------------------------------*/
int main(int Argc,char **Args)
{
  KSP       itP;
  Vec       x,b;
  Mat       A;
  PC        B;
  MPI_Comm comm;
  Scalar    one = 1.0, zero = 0.0;
  int       its, numtids,mytid,ierr;
  KSPType itmethod = KSPCG;
  int vec_size; Scalar *vec_values;

  ierr = PetscInitialize(&Argc,&Args,0,0); CHKERRQ(ierr);
  comm = MPI_COMM_WORLD;
  MPI_Comm_rank(comm,&mytid);
  MPI_Comm_size(comm,&numtids);

  ierr = KSPCreate(comm,&itP);
  /* set default parameters */
  ierr = KSPSetTolerances(itP,1.e-6,1.e-10,PETSC_DEFAULT,100);
  CHKERRQ(ierr);
  KSPSetType(itP,itmethod);

  /* make Poisson matrix */
  ierr = make_mat(comm,&A,&b,&vec_size,&vec_values); CHKERRQ(ierr);
  if (mytid==0) printf("Matrix created\n");

  /* and a dummy right hand side for a linear system */
/*  if (numtids == 1)
    ierr = VecCreateSeqFromData(comm,vec_size,vec_values,&b);
  else
    ierr = VecCreateMPIFromData(comm,vec_size,-1,vec_values,&b);
  CHKERRQ(ierr);
*/
  ierr = VecDuplicate(b,&x);  CHKERRQ(ierr);
   
    /* Allocate rhs and solution */
    /* set an ==1 start x, because for that case we know the numbers */
    /* Somehow it doesn't work ... */
    ierr = KSPSetInitialGuessNonzero(itP); CHKERRQ(ierr);
    ierr = VecSet(&one,x); CHKERRQ(ierr);
    ierr = KSPSetSolution(itP,x); CHKERRQ(ierr);
    ierr = KSPSetRhs(itP,b); CHKERRQ(ierr);

  PLogStagePush(1);
  ierr = prec_setup(comm,A,&B); CHKERRQ(ierr);
  if (mytid==0) printf("PC setup finished\n");

  /* remainder of the setup */
  ierr = KSPSetPC(itP,B); CHKERRQ(ierr);
  KSPSetMonitor(itP,usr_monitor,(void *)b);
  ierr = KSPSetUp(itP); CHKERRQ(ierr);
  PLogStagePop();

  /* execute cg method */
  ierr = VecSet(&zero,x); CHKERRQ(ierr);
  PLogStagePush(2);

  /* execute cg method */
/*  {
    Scalar *rhs_values,*sol_values;
    sol_values = (double *) PetscMalloc(vec_size*sizeof(double));
    ierr = cg(comm,A,B,sol_values,rhs_values,vec_size);
    CHKERRQ(ierr);
  }*/
  ierr = KSPSolve(itP,&its); CHKERRQ(ierr); CHKERRQ(ierr);

  PLogStagePop();
    /* cleanup after ourselves. */
  KSPDestroy(itP);
  PCDestroy(B);
  PetscFinalize();

return 0;

}
