#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCDomainDecomp;
  int ierr;

  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);
  /* ---------------------------------- */
  {
    PC intface_pc;
    ierr = PCDomainDecompGetInterfacePC(the_pc,&intface_pc); CHKERRQ(ierr);
    ierr = PCSetType(intface_pc,PCGenBlockSSOR); CHKERRQ(ierr);
    {
      PC very_local_pc;
      ierr = PCParallelGetLocalPC(intface_pc,&very_local_pc); CHKERRQ(ierr);
      ierr = PCSetType(very_local_pc,PCLU); CHKERRQ(ierr);
    }
    ierr = PCParallelSubdomainPipelineSetType
              (intface_pc,PIPELINE_SEQUENTIAL,(PetscObject)PETSC_NULL);
    CHKERRQ(ierr);
/*
    ierr = PCSetType(intface_pc,PCAdditiveSchwarz); CHKERRQ(ierr);
    {
      PC very_local_pc;
      ierr = PCParallelGetLocalPC(intface_pc,&very_local_pc); CHKERRQ(ierr);
      ierr = PCSetType(very_local_pc,PCLU); CHKERRQ(ierr);
    }
    ierr = PCParallelSubdomainPipelineSetType
              (intface_pc,PIPELINE_CUSTOM_SEQUENTIAL);
*/
  }

  /* Declare local/global aspects */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCLU); CHKERRQ(ierr);
  }

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  return 0;
}
