#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCAdditiveSchwarz;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);

  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  PetscPrintf(comm,"Setting up Additive Schwarz pc\n");
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  /* parametrised setting over overlap */
  ierr = PCSchwarzSetHaloSize(the_pc,1); CHKERRQ(ierr);

  /* Declare local solve */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    /* set the local solve to some LU solve */
    ierr = PCSetType(local_pc,PCILU); CHKERRQ(ierr);
  }

  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  return 0;
}

